/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.results;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.java.util.common.Unit;

public class QueryResultsFrameProcessor
implements FrameProcessor<Object> {
    private final ReadableFrameChannel inChannel;
    private final WritableFrameChannel outChannel;

    public QueryResultsFrameProcessor(ReadableFrameChannel inChannel, WritableFrameChannel outChannel) {
        this.inChannel = inChannel;
        this.outChannel = outChannel;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)1);
        }
        if (this.inChannel.isFinished()) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        this.writeFrame(this.inChannel.read());
        return ReturnOrAwait.awaitAll((int)1);
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
    }

    private void writeFrame(Frame frame) throws IOException {
        this.outChannel.write(frame);
    }
}

