/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class ClientCompactionIntervalSpec {
    private static final Logger LOGGER = new Logger(ClientCompactionIntervalSpec.class);
    private static final String TYPE = "interval";
    private final Interval interval;
    @Nullable
    private final String sha256OfSortedSegmentIds;

    public static ClientCompactionIntervalSpec fromSegments(List<DataSegment> segments, @Nullable Granularity segmentGranularity) {
        Interval interval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        LOGGER.info("Original umbrella interval %s in compaction task for datasource %s", new Object[]{interval, segments.get(0).getDataSource()});
        if (segmentGranularity != null) {
            interval = JodaUtils.umbrellaInterval((Iterable)segmentGranularity.getIterable(interval));
            LOGGER.info("Interval adjusted to %s in compaction task for datasource %s with configured segmentGranularity %s", new Object[]{interval, segments.get(0).getDataSource(), segmentGranularity});
        }
        return new ClientCompactionIntervalSpec(interval, null);
    }

    @JsonCreator
    public ClientCompactionIntervalSpec(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="sha256OfSortedSegmentIds") @Nullable String sha256OfSortedSegmentIds) {
        if (interval != null && interval.toDurationMillis() == 0L) {
            throw new IAE("Interval[%s] is empty, must specify a nonempty interval", new Object[]{interval});
        }
        this.interval = interval;
        this.sha256OfSortedSegmentIds = sha256OfSortedSegmentIds;
    }

    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public String getSha256OfSortedSegmentIds() {
        return this.sha256OfSortedSegmentIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionIntervalSpec that = (ClientCompactionIntervalSpec)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.sha256OfSortedSegmentIds, that.sha256OfSortedSegmentIds);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.sha256OfSortedSegmentIds);
    }

    public String toString() {
        return "ClientCompactionIntervalSpec{interval=" + String.valueOf(this.interval) + ", sha256OfSortedSegmentIds='" + this.sha256OfSortedSegmentIds + "'}";
    }
}

