/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.discovery.DataServerResponseHandler;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.Query;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.utils.CloseableUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class DataServerClient {
    private static final String BASE_PATH = "/druid/v2/";
    private static final Logger log = new Logger(DataServerClient.class);
    private final ServiceClient serviceClient;
    private final ObjectMapper objectMapper;
    private final ServiceLocation serviceLocation;
    private final ScheduledExecutorService queryCancellationExecutor;

    public DataServerClient(ServiceClientFactory serviceClientFactory, ServiceLocation serviceLocation, ObjectMapper objectMapper, ScheduledExecutorService queryCancellationExecutor) {
        this.serviceClient = serviceClientFactory.makeClient(serviceLocation.getHost(), new FixedServiceLocator(serviceLocation), StandardRetryPolicy.noRetries());
        this.serviceLocation = serviceLocation;
        this.objectMapper = objectMapper;
        this.queryCancellationExecutor = queryCancellationExecutor;
    }

    public <T> Sequence<T> run(final Query<T> query, ResponseContext responseContext, final JavaType queryResultType, Closer closer) {
        final String cancelPath = BASE_PATH + query.getId();
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, BASE_PATH);
        boolean isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        requestBuilder = isSmile ? requestBuilder.smileContent(this.objectMapper, query) : requestBuilder.jsonContent(this.objectMapper, query);
        if (log.isDebugEnabled()) {
            log.debug("Sending request to servers for query[%s], request[%s]", new Object[]{query.getId(), requestBuilder});
        }
        final ListenableFuture<InputStream> resultStreamFuture = this.serviceClient.asyncRequest(requestBuilder, new DataServerResponseHandler(query, responseContext, this.objectMapper));
        closer.register(() -> resultStreamFuture.cancel(true));
        Futures.addCallback(resultStreamFuture, (FutureCallback)new FutureCallback<InputStream>(){

            public void onSuccess(InputStream result) {
            }

            public void onFailure(Throwable t) {
                if (resultStreamFuture.isCancelled()) {
                    DataServerClient.this.cancelQuery(query, cancelPath);
                }
            }
        }, (Executor)Execs.directExecutor());
        return new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            public JsonParserIterator<T> make() {
                return new JsonParserIterator(queryResultType, (Future<InputStream>)resultStreamFuture, DataServerClient.BASE_PATH, query, DataServerClient.this.serviceLocation.getHost(), DataServerClient.this.objectMapper);
            }

            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseableUtils.closeAndWrapExceptions(iterFromMake);
            }
        });
    }

    private void cancelQuery(Query<?> query, String cancelPath) {
        Runnable cancelRunnable = () -> {
            ListenableFuture cancelFuture = this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.DELETE, cancelPath), StatusResponseHandler.getInstance());
            Runnable checkRunnable = () -> {
                try {
                    StatusResponseHolder response;
                    if (!cancelFuture.isDone()) {
                        log.error("Error cancelling query[%s]", new Object[]{query});
                    }
                    if ((response = (StatusResponseHolder)cancelFuture.get()).getStatus().getCode() >= 500) {
                        log.error("Error cancelling query[%s]: queryable node returned status[%d] [%s].", new Object[]{query, response.getStatus().getCode(), response.getStatus().getReasonPhrase()});
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error((Throwable)e, "Error cancelling query[%s]", new Object[]{query});
                }
            };
            this.queryCancellationExecutor.schedule(checkRunnable, 5L, TimeUnit.SECONDS);
        };
        this.queryCancellationExecutor.submit(cancelRunnable);
    }
}

