/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;

public class BasicDataSourceExt
extends BasicDataSource {
    private static final Logger LOGGER = new Logger(BasicDataSourceExt.class);
    private final MetadataStorageConnectorConfig connectorConfig;
    private Properties connectionProperties;

    public BasicDataSourceExt(MetadataStorageConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.connectionProperties = new Properties();
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
        super.addConnectionProperty(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.connectionProperties.remove(name);
        super.removeConnectionProperty(name);
    }

    public void setConnectionProperties(String connectionProperties) {
        if (connectionProperties == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (String entry : entries) {
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
        super.setConnectionProperties(connectionProperties);
    }

    @VisibleForTesting
    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        Driver driverToUse = this.getDriver();
        if (driverToUse == null) {
            Class<?> driverFromCCL;
            block13: {
                driverFromCCL = null;
                if (this.getDriverClassName() != null) {
                    try {
                        try {
                            if (this.getDriverClassLoader() == null) {
                                driverFromCCL = Class.forName(this.getDriverClassName());
                                break block13;
                            }
                            driverFromCCL = Class.forName(this.getDriverClassName(), true, this.getDriverClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.getDriverClassName());
                        }
                    }
                    catch (Exception t) {
                        String message = "Cannot load JDBC driver class '" + this.getDriverClassName() + "'";
                        LOGGER.error((Throwable)t, message, new Object[0]);
                        throw new SQLException(message, t);
                    }
                }
            }
            try {
                if (driverFromCCL == null) {
                    driverToUse = DriverManager.getDriver(this.getUrl());
                } else {
                    driverToUse = (Driver)driverFromCCL.newInstance();
                    if (!driverToUse.acceptsURL(this.getUrl())) {
                        throw new SQLException("No suitable driver", "08001");
                    }
                }
            }
            catch (Exception t) {
                String message = "Cannot create JDBC driver of class '" + (this.getDriverClassName() != null ? this.getDriverClassName() : "") + "' for connect URL '" + this.getUrl() + "'";
                LOGGER.error((Throwable)t, message, new Object[0]);
                throw new SQLException(message, t);
            }
        }
        if (driverToUse == null) {
            throw new RE("Failed to find the DB Driver", new Object[0]);
        }
        Driver finalDriverToUse = driverToUse;
        return () -> {
            String user = this.connectorConfig.getUser();
            if (user != null) {
                this.connectionProperties.put("user", user);
            } else {
                this.log("DBCP DataSource configured without a 'username'");
            }
            String password = this.connectorConfig.getPassword();
            if (password != null) {
                this.connectionProperties.put("password", password);
            } else {
                this.log("DBCP DataSource configured without a 'password'");
            }
            return finalDriverToUse.connect(this.connectorConfig.getConnectURI(), this.connectionProperties);
        };
    }
}

