/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.metadata.SQLInputSourceDatabaseConnector;
import org.apache.druid.metadata.input.SqlEntity;
import org.apache.druid.metadata.input.SqlInputFormat;

public class SqlInputSource
extends AbstractInputSource
implements SplittableInputSource<String> {
    static final String TYPE_KEY = "sql";
    private final List<String> sqls;
    private final SQLInputSourceDatabaseConnector sqlInputSourceDatabaseConnector;
    private final ObjectMapper objectMapper;
    private final boolean foldCase;

    @JsonCreator
    public SqlInputSource(@JsonProperty(value="sqls") List<String> sqls, @JsonProperty(value="foldCase") boolean foldCase, @JsonProperty(value="database") SQLInputSourceDatabaseConnector sqlInputSourceDatabaseConnector, @JacksonInject @Smile ObjectMapper objectMapper) {
        Preconditions.checkArgument((sqls.size() > 0 ? 1 : 0) != 0, (Object)"No SQL queries provided");
        this.sqls = sqls;
        this.foldCase = foldCase;
        this.sqlInputSourceDatabaseConnector = (SQLInputSourceDatabaseConnector)Preconditions.checkNotNull((Object)sqlInputSourceDatabaseConnector, (Object)"SQL Metadata Connector not configured!");
        this.objectMapper = objectMapper;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    @JsonProperty
    public List<String> getSqls() {
        return this.sqls;
    }

    @JsonProperty
    public boolean isFoldCase() {
        return this.foldCase;
    }

    @JsonProperty(value="database")
    public SQLInputSourceDatabaseConnector getSQLInputSourceDatabaseConnector() {
        return this.sqlInputSourceDatabaseConnector;
    }

    public Stream<InputSplit<String>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.sqls.stream().map(InputSplit::new);
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return this.sqls.size();
    }

    public SplittableInputSource<String> withSplit(InputSplit<String> split) {
        return new SqlInputSource(Collections.singletonList((String)split.get()), this.foldCase, this.sqlInputSourceDatabaseConnector, this.objectMapper);
    }

    protected InputSourceReader fixedFormatReader(InputRowSchema inputRowSchema, @Nullable File temporaryDirectory) {
        SqlInputFormat inputFormat = new SqlInputFormat(this.objectMapper);
        return new InputEntityIteratingReader(inputRowSchema, (InputFormat)inputFormat, CloseableIterators.withEmptyBaggage(this.createSplits(inputFormat, null).map(split -> new SqlEntity((String)split.get(), this.sqlInputSourceDatabaseConnector, this.foldCase, this.objectMapper)).iterator()), SystemFieldDecoratorFactory.NONE, temporaryDirectory);
    }

    public boolean needsFormat() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SqlInputSource that = (SqlInputSource)((Object)o);
        return this.foldCase == that.foldCase && this.sqls.equals(that.sqls) && this.sqlInputSourceDatabaseConnector.equals(that.sqlInputSourceDatabaseConnector);
    }

    public int hashCode() {
        return Objects.hash(this.sqls, this.sqlInputSourceDatabaseConnector, this.foldCase);
    }
}

