/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.segment.CachedSegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataReadTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransaction;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionStatus;

public class SqlSegmentMetadataTransactionFactory
implements SegmentMetadataTransactionFactory {
    private static final Logger log = new Logger(SqlSegmentMetadataTransactionFactory.class);
    private static final int QUIET_RETRIES = 2;
    private static final int MAX_RETRIES = 3;
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig tablesConfig;
    private final SQLMetadataConnector connector;
    private final DruidLeaderSelector leaderSelector;
    private final SegmentMetadataCache segmentMetadataCache;
    private final ServiceEmitter emitter;

    @Inject
    public SqlSegmentMetadataTransactionFactory(ObjectMapper jsonMapper, MetadataStorageTablesConfig tablesConfig, SQLMetadataConnector connector, @IndexingService DruidLeaderSelector leaderSelector, SegmentMetadataCache segmentMetadataCache, ServiceEmitter emitter) {
        this.jsonMapper = jsonMapper;
        this.tablesConfig = tablesConfig;
        this.connector = connector;
        this.leaderSelector = leaderSelector;
        this.segmentMetadataCache = segmentMetadataCache;
        this.emitter = emitter;
    }

    public int getMaxRetries() {
        return 3;
    }

    @Override
    public <T> T inReadOnlyDatasourceTransaction(String dataSource, SegmentMetadataReadTransaction.Callback<T> callback) {
        return this.connector.retryReadOnlyTransaction((handle, status) -> {
            SegmentMetadataTransaction sqlTransaction = this.createSqlTransaction(dataSource, handle, status);
            if (this.segmentMetadataCache.isSyncedForRead()) {
                this.emitTransactionCount("segment/metadataCache/transactions/readOnly", dataSource);
                return this.segmentMetadataCache.readCacheForDataSource(dataSource, dataSourceCache -> {
                    CachedSegmentMetadataTransaction cachedTransaction = new CachedSegmentMetadataTransaction(sqlTransaction, dataSourceCache, this.leaderSelector, true);
                    return this.executeReadAndClose(cachedTransaction, callback);
                });
            }
            return this.executeReadAndClose(sqlTransaction, callback);
        }, 2, this.getMaxRetries());
    }

    @Override
    public <T> T inReadWriteDatasourceTransaction(String dataSource, SegmentMetadataTransaction.Callback<T> callback) {
        return this.connector.retryTransaction((handle, status) -> {
            SegmentMetadataTransaction sqlTransaction = this.createSqlTransaction(dataSource, handle, status);
            if (this.segmentMetadataCache.isEnabled()) {
                boolean isSynced = this.segmentMetadataCache.isSyncedForRead();
                if (isSynced) {
                    this.emitTransactionCount("segment/metadataCache/transactions/readWrite", dataSource);
                } else {
                    log.warn("Starting read-write transaction for datasource[%s]. Reads will be done directly from metadata store since cache is not synced yet.", new Object[]{dataSource});
                    this.emitTransactionCount("segment/metadataCache/transactions/writeOnly", dataSource);
                }
                return this.segmentMetadataCache.writeCacheForDataSource(dataSource, dataSourceCache -> {
                    CachedSegmentMetadataTransaction cachedTransaction = new CachedSegmentMetadataTransaction(sqlTransaction, dataSourceCache, this.leaderSelector, isSynced);
                    return this.executeWriteAndClose(cachedTransaction, callback);
                });
            }
            return this.executeWriteAndClose(sqlTransaction, callback);
        }, 2, this.getMaxRetries());
    }

    private SegmentMetadataTransaction createSqlTransaction(String dataSource, Handle handle, TransactionStatus transactionStatus) {
        return new SqlSegmentMetadataTransaction(dataSource, handle, transactionStatus, this.connector, this.tablesConfig, this.jsonMapper);
    }

    private <T> T executeWriteAndClose(SegmentMetadataTransaction transaction, SegmentMetadataTransaction.Callback<T> callback) throws Exception {
        try {
            T t = callback.inTransaction(transaction);
            return t;
        }
        catch (Throwable e) {
            transaction.setRollbackOnly();
            throw e;
        }
        finally {
            transaction.close();
        }
    }

    private <T> T executeReadAndClose(SegmentMetadataReadTransaction transaction, SegmentMetadataReadTransaction.Callback<T> callback) throws Exception {
        try (SegmentMetadataReadTransaction segmentMetadataReadTransaction = transaction;){
            T t = callback.inTransaction(transaction);
            return t;
        }
    }

    private void emitTransactionCount(String metricName, String datasource) {
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("dataSource", (Object)datasource).setMetric(metricName, (Number)1L));
    }
}

