/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.metrics.TaskCountStatsProvider;

public class TaskCountStatsMonitor
extends AbstractMonitor {
    private final TaskCountStatsProvider statsProvider;

    @Inject
    public TaskCountStatsMonitor(TaskCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        this.emit(emitter, "task/success/count", this.statsProvider.getSuccessfulTaskCount());
        this.emit(emitter, "task/failed/count", this.statsProvider.getFailedTaskCount());
        this.emit(emitter, "task/running/count", this.statsProvider.getRunningTaskCount());
        this.emit(emitter, "task/pending/count", this.statsProvider.getPendingTaskCount());
        this.emit(emitter, "task/waiting/count", this.statsProvider.getWaitingTaskCount());
        CoordinatorRunStats stats = this.statsProvider.getStats();
        if (stats != null) {
            stats.forEachStat((stat, dimensions, statValue) -> this.emit(emitter, stat, dimensions.getValues(), statValue));
        }
        return true;
    }

    private void emit(ServiceEmitter emitter, String key, Map<String, Long> counts) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        if (counts != null) {
            counts.forEach((k, v) -> {
                builder.setDimension("dataSource", k);
                emitter.emit((ServiceEventBuilder)builder.setMetric(key, (Number)v));
            });
        }
    }

    private void emit(ServiceEmitter emitter, CoordinatorStat stat, Map<Dimension, String> dimensionValues, long value) {
        if (!stat.shouldEmit()) {
            return;
        }
        ServiceMetricEvent.Builder eventBuilder = new ServiceMetricEvent.Builder();
        dimensionValues.forEach((dim, dimValue) -> eventBuilder.setDimension(dim.reportedName(), dimValue));
        emitter.emit((ServiceEventBuilder)eventBuilder.setMetric(stat.getMetricName(), (Number)value));
    }
}

