/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.util.List;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.sql.AbstractStatement;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PrepareResult;

public class PreparedStatement
extends AbstractStatement {
    private final SqlQueryPlus originalRequest;
    private PrepareResult prepareResult;

    public PreparedStatement(SqlToolbox lifecycleToolbox, SqlQueryPlus queryPlus) {
        super(lifecycleToolbox, queryPlus, null);
        this.originalRequest = queryPlus;
    }

    public PrepareResult prepare() {
        DruidPlanner planner = this.sqlToolbox.plannerFactory.createPlanner(this.sqlToolbox.engine, this.queryPlus.sql(), this.queryContext, this.hook);
        try {
            this.validate(planner);
            this.authorize(planner, this.authorizer());
            PrepareResult prepareResult = this.prepareResult = planner.prepare();
            if (planner != null) {
                planner.close();
            }
            return prepareResult;
        }
        catch (Throwable throwable) {
            try {
                if (planner != null) {
                    try {
                        planner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RuntimeException e) {
                this.reporter.failed(e);
                throw e;
            }
        }
    }

    public DirectStatement execute(List<TypedValue> parameters) {
        return new DirectStatement(this.sqlToolbox, this.originalRequest.withParameters(parameters));
    }
}

