/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class RelParameterizerShuttle
implements RelShuttle {
    private final PlannerContext plannerContext;

    public RelParameterizerShuttle(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public RelNode visit(TableScan scan) {
        return this.bindRel((RelNode)scan);
    }

    public RelNode visit(TableFunctionScan scan) {
        return this.bindRel((RelNode)scan);
    }

    public RelNode visit(LogicalValues values) {
        return this.bindRel((RelNode)values);
    }

    public RelNode visit(LogicalFilter filter) {
        return this.bindRel((RelNode)filter);
    }

    public RelNode visit(LogicalProject project) {
        return this.bindRel((RelNode)project);
    }

    public RelNode visit(LogicalJoin join) {
        return this.bindRel((RelNode)join);
    }

    public RelNode visit(LogicalCorrelate correlate) {
        return this.bindRel((RelNode)correlate);
    }

    public RelNode visit(LogicalUnion union) {
        return this.bindRel((RelNode)union);
    }

    public RelNode visit(LogicalIntersect intersect) {
        return this.bindRel((RelNode)intersect);
    }

    public RelNode visit(LogicalMinus minus) {
        return this.bindRel((RelNode)minus);
    }

    public RelNode visit(LogicalAggregate aggregate) {
        return this.bindRel((RelNode)aggregate);
    }

    public RelNode visit(LogicalMatch match) {
        return this.bindRel((RelNode)match);
    }

    public RelNode visit(LogicalSort sort) {
        RexBuilder builder = sort.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = sort.getCluster().getTypeFactory();
        RexNode newFetch = this.bind(sort.fetch, builder, typeFactory);
        RexNode newOffset = this.bind(sort.offset, builder, typeFactory);
        sort = (LogicalSort)sort.copy(sort.getTraitSet(), sort.getInput(), sort.getCollation(), newOffset, newFetch);
        return this.bindRel((RelNode)sort, builder, typeFactory);
    }

    public RelNode visit(LogicalExchange exchange) {
        return this.bindRel((RelNode)exchange);
    }

    public RelNode visit(LogicalCalc calc) {
        return this.bindRel((RelNode)calc);
    }

    public RelNode visit(LogicalTableModify modify) {
        return this.bindRel((RelNode)modify);
    }

    public RelNode visit(RelNode other) {
        return this.bindRel(other);
    }

    private RelNode bindRel(RelNode node) {
        RexBuilder builder = node.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = node.getCluster().getTypeFactory();
        return this.bindRel(node, builder, typeFactory);
    }

    private RelNode bindRel(RelNode node, final RexBuilder builder, final RelDataTypeFactory typeFactory) {
        final RexShuttle binder = new RexShuttle(){

            public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
                return RelParameterizerShuttle.this.bind((RexNode)dynamicParam, builder, typeFactory);
            }
        };
        node = node.accept(binder);
        node.childrenAccept(new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                super.visit(node, ordinal, parent);
                RelNode transformed = node.accept(binder);
                if (!node.equals(transformed)) {
                    parent.replaceInput(ordinal, transformed);
                }
            }
        });
        return node;
    }

    private RexNode bind(RexNode node, RexBuilder builder, RelDataTypeFactory typeFactory) {
        if (node instanceof RexDynamicParam) {
            RexDynamicParam dynamicParam = (RexDynamicParam)node;
            if (this.plannerContext.getParameters().size() > dynamicParam.getIndex()) {
                TypedValue param = this.plannerContext.getParameters().get(dynamicParam.getIndex());
                if (param == null) {
                    throw RelParameterizerShuttle.unbound(dynamicParam);
                }
                if (param.value == null) {
                    return builder.makeNullLiteral(typeFactory.createSqlType(SqlTypeName.NULL));
                }
                SqlTypeName typeName = SqlTypeName.getNameForJdbcType((int)param.type.typeId);
                return builder.makeLiteral(param.value, typeFactory.createSqlType(typeName), true);
            }
            throw RelParameterizerShuttle.unbound(dynamicParam);
        }
        return node;
    }

    private static DruidException unbound(RexDynamicParam dynamicParam) {
        return InvalidSqlInput.exception((String)"No value bound for parameter (position [%s])", (Object[])new Object[]{dynamicParam.getIndex() + 1});
    }
}

