/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner.querygen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.logical.DruidAggregate;
import org.apache.druid.sql.calcite.rel.logical.DruidJoin;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rel.logical.DruidSort;
import org.apache.druid.sql.calcite.rel.logical.DruidUnion;

public class DruidQueryGenerator {
    private final DruidLogicalNode relRoot;
    private final PDQVertexFactory vertexFactory;

    public DruidQueryGenerator(PlannerContext plannerContext, DruidLogicalNode relRoot, RexBuilder rexBuilder) {
        this.relRoot = relRoot;
        this.vertexFactory = new PDQVertexFactory(plannerContext, rexBuilder);
    }

    public DruidQuery buildQuery() {
        DruidNodeStack stack = new DruidNodeStack();
        stack.push(this.relRoot);
        Vertex vertex = this.buildVertexFor(stack);
        return vertex.buildQuery(true);
    }

    private Vertex buildVertexFor(DruidNodeStack stack) {
        ArrayList<Vertex> newInputs = new ArrayList<Vertex>();
        for (RelNode input : stack.peekNode().getInputs()) {
            stack.push((DruidLogicalNode)input, newInputs.size());
            newInputs.add(this.buildVertexFor(stack));
            stack.pop();
        }
        Vertex vertex = this.processNodeWithInputs(stack, newInputs);
        return vertex;
    }

    private Vertex processNodeWithInputs(DruidNodeStack stack, List<Vertex> newInputs) {
        DruidLogicalNode node = stack.peekNode();
        if (node instanceof SourceDescProducer) {
            return this.vertexFactory.createVertex(stack, PartialDruidQuery.create(node), newInputs);
        }
        if (newInputs.size() == 1) {
            Vertex inputVertex = newInputs.get(0);
            Optional<Vertex> newVertex = inputVertex.extendWith(stack);
            if (newVertex.isPresent()) {
                return newVertex.get();
            }
            inputVertex = this.vertexFactory.createVertex(stack, PartialDruidQuery.createOuterQuery(((PDQVertexFactory.PDQVertex)inputVertex).partialDruidQuery, this.vertexFactory.plannerContext), (List<Vertex>)ImmutableList.of((Object)inputVertex));
            newVertex = inputVertex.extendWith(stack);
            if (newVertex.isPresent()) {
                return newVertex.get();
            }
        }
        throw DruidException.defensive().build("Unable to process relNode[%s]", new Object[]{node});
    }

    public static FilteredDataSource makeFilteredDataSource(SourceDescProducer.SourceDesc sd, DimFilter filter) {
        Filtration filtration = Filtration.create(filter).optimizeFilterOnly(sd.rowSignature);
        DimFilter newFilter = filtration.getDimFilter();
        return FilteredDataSource.create((DataSource)sd.dataSource, (DimFilter)newFilter);
    }

    protected static class PDQVertexFactory {
        private final PlannerContext plannerContext;
        private final RexBuilder rexBuilder;

        public PDQVertexFactory(PlannerContext plannerContext, RexBuilder rexBuilder) {
            this.plannerContext = plannerContext;
            this.rexBuilder = rexBuilder;
        }

        Vertex createVertex(DruidNodeStack stack, PartialDruidQuery partialDruidQuery, List<Vertex> inputs) {
            VertexTweaks tweaks = VertexTweaks.analyze(stack);
            return new PDQVertex(partialDruidQuery, inputs, tweaks);
        }

        public class PDQVertex
        implements Vertex {
            final PartialDruidQuery partialDruidQuery;
            final List<Vertex> inputs;
            final VertexTweaks tweaks;
            private SourceDescProducer.SourceDesc source;

            public PDQVertex(PartialDruidQuery partialDruidQuery, List<Vertex> inputs, VertexTweaks tweaks) {
                this.partialDruidQuery = partialDruidQuery;
                this.inputs = inputs;
                this.tweaks = tweaks;
            }

            @Override
            public DruidQuery buildQuery(boolean topLevel) {
                SourceDescProducer.SourceDesc source = this.getSource();
                return this.partialDruidQuery.build(source.dataSource, source.rowSignature, PDQVertexFactory.this.plannerContext, PDQVertexFactory.this.rexBuilder, !topLevel && this.tweaks.finalizeSubQuery(), true);
            }

            private SourceDescProducer.SourceDesc getSource() {
                if (this.source == null) {
                    this.source = this.realGetSource();
                }
                return this.source;
            }

            private SourceDescProducer.SourceDesc realGetSource() {
                ArrayList<SourceDescProducer.SourceDesc> sourceDescs = new ArrayList<SourceDescProducer.SourceDesc>();
                boolean mayUnwrap = this.mayUnwrapInputs();
                for (Vertex inputVertex : this.inputs) {
                    SourceDescProducer.SourceDesc desc;
                    if (mayUnwrap && inputVertex.canUnwrapSourceDesc()) {
                        desc = inputVertex.unwrapSourceDesc();
                    } else {
                        DruidQuery inputQuery = inputVertex.buildQuery(false);
                        desc = new SourceDescProducer.SourceDesc((DataSource)new QueryDataSource(inputQuery.getQuery()), inputQuery.getOutputRowSignature());
                    }
                    sourceDescs.add(desc);
                }
                RelNode scan = this.partialDruidQuery.getScan();
                if (scan instanceof SourceDescProducer) {
                    SourceDescProducer inp = (SourceDescProducer)scan;
                    return inp.getSourceDesc(PDQVertexFactory.this.plannerContext, sourceDescs);
                }
                if (this.inputs.size() == 1) {
                    return (SourceDescProducer.SourceDesc)sourceDescs.get(0);
                }
                throw DruidException.defensive((String)"Unable to create SourceDesc for Operator [%s]", (Object[])new Object[]{scan});
            }

            private boolean mayUnwrapInputs() {
                if (!(this.partialDruidQuery.getScan() instanceof DruidUnion)) {
                    return true;
                }
                boolean mayUnwrap = true;
                for (Vertex vertex : this.inputs) {
                    if (vertex.canUnwrapSourceDesc()) continue;
                    mayUnwrap = false;
                }
                return mayUnwrap;
            }

            @Override
            public Optional<Vertex> extendWith(DruidNodeStack stack) {
                Optional<PartialDruidQuery> newPartialQuery = this.extendPartialDruidQuery(stack);
                if (!newPartialQuery.isPresent()) {
                    return Optional.empty();
                }
                return Optional.of(PDQVertexFactory.this.createVertex(stack, newPartialQuery.get(), this.inputs));
            }

            private Optional<PartialDruidQuery> extendPartialDruidQuery(DruidNodeStack stack) {
                DruidLogicalNode parentNode = stack.peekNode();
                if (this.accepts(stack, PartialDruidQuery.Stage.WHERE_FILTER, Filter.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withWhereFilter((Filter)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.SELECT_PROJECT, Project.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withSelectProject((Project)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.AGGREGATE, Aggregate.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withAggregate((Aggregate)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.AGGREGATE_PROJECT, Project.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withAggregateProject((Project)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.HAVING_FILTER, Filter.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withHavingFilter((Filter)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.SORT, Sort.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withSort((Sort)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.SORT_PROJECT, Project.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withSortProject((Project)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.WINDOW, Window.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withWindow((Window)parentNode);
                    return Optional.of(newPartialQuery);
                }
                if (this.accepts(stack, PartialDruidQuery.Stage.WINDOW_PROJECT, Project.class)) {
                    PartialDruidQuery newPartialQuery = this.partialDruidQuery.withWindowProject((Project)parentNode);
                    return Optional.of(newPartialQuery);
                }
                return Optional.empty();
            }

            private boolean accepts(DruidNodeStack stack, PartialDruidQuery.Stage stage, Class<? extends RelNode> clazz) {
                DruidLogicalNode currentNode = stack.peekNode();
                if (Project.class == clazz && stack.size() >= 2) {
                    DruidLogicalNode parentNode = stack.parentNode();
                    if (stage.ordinal() > PartialDruidQuery.Stage.AGGREGATE.ordinal() && parentNode instanceof DruidAggregate && !this.partialDruidQuery.canAccept(PartialDruidQuery.Stage.AGGREGATE)) {
                        return false;
                    }
                    if (stage.ordinal() > PartialDruidQuery.Stage.SORT.ordinal() && parentNode instanceof DruidSort && !this.partialDruidQuery.canAccept(PartialDruidQuery.Stage.SORT)) {
                        return false;
                    }
                }
                return this.partialDruidQuery.canAccept(stage) && clazz.isInstance(currentNode);
            }

            @Override
            public SourceDescProducer.SourceDesc unwrapSourceDesc() {
                if (this.canUnwrapSourceDesc()) {
                    DruidQuery q = this.buildQuery(false);
                    SourceDescProducer.SourceDesc origInput = this.getSource();
                    Object dataSource = q.getFilter() == null ? origInput.dataSource : DruidQueryGenerator.makeFilteredDataSource(origInput, q.getFilter());
                    return new SourceDescProducer.SourceDesc((DataSource)dataSource, q.getOutputRowSignature());
                }
                throw DruidException.defensive((String)"Can't unwrap source of vertex[%s]", (Object[])new Object[]{this.partialDruidQuery});
            }

            @Override
            public boolean canUnwrapSourceDesc() {
                if (this.tweaks.forceSubQuery(this.getSource())) {
                    return false;
                }
                if (this.partialDruidQuery.stage() == PartialDruidQuery.Stage.SCAN) {
                    return true;
                }
                if (this.tweaks.filteredDatasourceAllowed() && this.partialDruidQuery.stage() == PartialDruidQuery.Stage.WHERE_FILTER) {
                    return true;
                }
                return this.partialDruidQuery.stage() == PartialDruidQuery.Stage.SELECT_PROJECT && (this.tweaks.filteredDatasourceAllowed() || this.partialDruidQuery.getWhereFilter() == null) && this.mayDiscardSelectProject();
            }

            private boolean mayDiscardSelectProject() {
                if (!this.partialDruidQuery.getSelectProject().isMapping()) {
                    return false;
                }
                if (!this.tweaks.isParentUnion) {
                    return true;
                }
                SourceDescProducer.SourceDesc src = this.getSource();
                List inputFieldNames = src.rowSignature.getColumnNames();
                List outputFieldNames = this.partialDruidQuery.getRowType().getFieldNames();
                if (!this.isNameConsistentMapping(this.partialDruidQuery.getSelectProject(), inputFieldNames, outputFieldNames)) {
                    return false;
                }
                boolean isAssociative = UnionDataSource.isCompatibleDataSource((DataSource)src.dataSource);
                return isAssociative || outputFieldNames.equals(inputFieldNames.subList(0, outputFieldNames.size()));
            }

            private boolean isNameConsistentMapping(Project selectProject, List<String> inputFieldNames, List<String> outputFieldNames) {
                List projects = selectProject.getProjects();
                for (int i = 0; i < projects.size(); ++i) {
                    String outputName;
                    RexInputRef p = (RexInputRef)projects.get(i);
                    String inputName = inputFieldNames.get(p.getIndex());
                    if (inputName.equals(outputName = outputFieldNames.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
    }

    static class DruidNodeStack {
        Stack<Entry> stack = new Stack();

        DruidNodeStack() {
        }

        public void push(DruidLogicalNode item) {
            this.push(item, 0);
        }

        public void push(DruidLogicalNode item, int operandIndex) {
            this.stack.push(new Entry(item, operandIndex));
        }

        public void pop() {
            this.stack.pop();
        }

        public int size() {
            return this.stack.size();
        }

        public DruidLogicalNode peekNode() {
            return this.stack.peek().node;
        }

        public DruidLogicalNode parentNode() {
            return this.getNode((int)1).node;
        }

        public Entry getNode(int i) {
            return (Entry)this.stack.get(this.stack.size() - 1 - i);
        }

        public int peekOperandIndex() {
            return this.stack.peek().operandIndex;
        }

        static class Entry {
            public final DruidLogicalNode node;
            public final int operandIndex;

            public Entry(DruidLogicalNode node, int operandIndex) {
                this.node = node;
                this.operandIndex = operandIndex;
            }
        }
    }

    private static interface Vertex {
        public DruidQuery buildQuery(boolean var1);

        public Optional<Vertex> extendWith(DruidNodeStack var1);

        public boolean canUnwrapSourceDesc();

        public SourceDescProducer.SourceDesc unwrapSourceDesc();
    }

    private static class VertexTweaks {
        public final JoinPosition joinType;
        public final boolean isParentUnion;

        public VertexTweaks(JoinPosition joinType, boolean isParentUnion) {
            this.joinType = joinType;
            this.isParentUnion = isParentUnion;
        }

        static VertexTweaks analyze(DruidNodeStack stack) {
            JoinPosition joinType = JoinPosition.analyze(stack);
            boolean isParentUnion = stack.size() > 2 && stack.parentNode() instanceof DruidUnion;
            return new VertexTweaks(joinType, isParentUnion);
        }

        boolean forceSubQuery(SourceDescProducer.SourceDesc sourceDesc) {
            if (sourceDesc.dataSource.isGlobal()) {
                return false;
            }
            return this.joinType == JoinPosition.RIGHT;
        }

        boolean filteredDatasourceAllowed() {
            return this.joinType == JoinPosition.NONE;
        }

        boolean finalizeSubQuery() {
            return this.joinType == JoinPosition.NONE;
        }

        boolean mayUnwrapWithRename() {
            return !this.isParentUnion;
        }

        static enum JoinPosition {
            NONE,
            LEFT,
            RIGHT;


            public static JoinPosition analyze(DruidNodeStack stack) {
                if (stack.size() < 2) {
                    return NONE;
                }
                DruidLogicalNode possibleJoin = stack.parentNode();
                if (!(possibleJoin instanceof DruidJoin)) {
                    return NONE;
                }
                if (stack.peekOperandIndex() == 0) {
                    return LEFT;
                }
                return RIGHT;
            }
        }
    }
}

