/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rule.ReverseLookupRule;

public class AggregatePullUpLookupRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public AggregatePullUpLookupRule(PlannerContext plannerContext) {
        super(AggregatePullUpLookupRule.operand(Aggregate.class, (RelOptRuleOperand)AggregatePullUpLookupRule.operand(Project.class, (RelOptRuleOperandChildren)AggregatePullUpLookupRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.plannerContext = plannerContext;
    }

    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        Set aggCallInputs = RelOptUtil.getAllFields2((ImmutableBitSet)ImmutableBitSet.of(), (List)aggregate.getAggCallList());
        RexNode[] topProjects = null;
        RexNode[] bottomProjects = null;
        boolean matched = false;
        int dimensionIndex = 0;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            RexCall lookupCall;
            String lookupName;
            LookupExtractor lookup;
            int projectIndex = (Integer)iterator.next();
            RexNode projectExpr = (RexNode)project.getProjects().get(projectIndex);
            if (ReverseLookupRule.isLookupCall(projectExpr) && !aggCallInputs.contains(projectIndex) && (lookup = this.plannerContext.getLookup(lookupName = RexLiteral.stringValue((RexNode)((RexNode)(lookupCall = (RexCall)projectExpr).getOperands().get(1))))) != null && lookup.isOneToOne()) {
                if (!matched) {
                    matched = true;
                    bottomProjects = new RexNode[project.getProjects().size()];
                    topProjects = new RexNode[aggregate.getRowType().getFieldCount()];
                }
                bottomProjects[projectIndex] = (RexNode)lookupCall.getOperands().get(0);
                ArrayList<RexInputRef> newLookupOperands = new ArrayList<RexInputRef>(lookupCall.getOperands());
                RelDataType dimensionType = ((RelDataTypeField)aggregate.getRowType().getFieldList().get(dimensionIndex)).getType();
                newLookupOperands.set(0, rexBuilder.makeInputRef(dimensionType, dimensionIndex));
                topProjects[dimensionIndex] = lookupCall.clone(dimensionType, newLookupOperands);
            }
            ++dimensionIndex;
        }
        if (matched) {
            int i;
            for (i = 0; i < bottomProjects.length; ++i) {
                if (bottomProjects[i] != null) continue;
                bottomProjects[i] = (RexNode)project.getProjects().get(i);
            }
            for (i = 0; i < topProjects.length; ++i) {
                if (topProjects[i] != null) continue;
                topProjects[i] = rexBuilder.makeInputRef(((RelDataTypeField)aggregate.getRowType().getFieldList().get(i)).getType(), i);
            }
            RelBuilder relBuilder = call.builder();
            call.transformTo(relBuilder.push(project.getInput()).project(bottomProjects).aggregate(relBuilder.groupKey(aggregate.getGroupSet(), (Iterable)aggregate.getGroupSets()), aggregate.getAggCallList()).project(topProjects).build());
            call.getPlanner().prune((RelNode)aggregate);
        }
    }
}

