/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;

public class FixIncorrectInExpansionTypes
extends RelOptRule
implements SubstitutionRule {
    public FixIncorrectInExpansionTypes() {
        super(FixIncorrectInExpansionTypes.operand(RelNode.class, (RelOptRuleOperandChildren)FixIncorrectInExpansionTypes.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        RewriteShuttle shuttle;
        RelNode oldNode = call.rel(0);
        RelNode newNode = oldNode.accept((RexShuttle)(shuttle = new RewriteShuttle(oldNode.getCluster().getRexBuilder())));
        if (newNode != oldNode) {
            call.transformTo(newNode);
            call.getPlanner().prune(oldNode);
        }
    }

    private static class RewriteShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public RewriteShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexNode newNode = super.visitCall(call);
            if (newNode.getKind() == SqlKind.EQUALS || newNode.getKind() == SqlKind.NOT_EQUALS) {
                RexCall newCall = (RexCall)newNode;
                RexNode op0 = (RexNode)newCall.getOperands().get(0);
                RexNode op1 = (RexNode)newCall.getOperands().get(1);
                if (RexUtil.isLiteral((RexNode)op1, (boolean)false) && op1.getType().getSqlTypeName() == SqlTypeName.CHAR && op0.getType().getSqlTypeName() == SqlTypeName.VARCHAR) {
                    RexNode newLiteral = this.rexBuilder.ensureType(op0.getType(), op1, true);
                    return this.rexBuilder.makeCall(newCall.getOperator(), new RexNode[]{op0, newLiteral});
                }
            }
            return newNode;
        }
    }
}

