/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.view;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.view.ViewSqlEngine;

public class DruidViewMacro
implements TableMacro {
    private final PlannerFactory plannerFactory;
    private final String viewSql;
    private final String druidSchemaName;

    @Inject
    public DruidViewMacro(@Assisted PlannerFactory plannerFactory, @Assisted String viewSql, @DruidSchemaName String druidSchemaName) {
        this.plannerFactory = plannerFactory;
        this.viewSql = viewSql;
        this.druidSchemaName = druidSchemaName;
    }

    public TranslatableTable apply(List<?> arguments) {
        RelDataType rowType;
        try (DruidPlanner planner = this.plannerFactory.createPlanner(ViewSqlEngine.INSTANCE, this.viewSql, Collections.emptyMap(), null);){
            planner.validate();
            rowType = planner.prepare().getValidatedRowType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ViewTable(null, RelDataTypeImpl.proto((RelDataType)rowType), this.viewSql, (List)ImmutableList.of((Object)this.druidSchemaName), null);
    }

    public List<FunctionParameter> getParameters() {
        return ImmutableList.of();
    }
}

