/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesELResolver
extends ELResolver {
    private static final Logger log = LoggerFactory.getLogger(PagesELResolver.class);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            log.warn("DBELResolver:getCommonPropertyType is not implemented!");
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof PageDefinitions || base == null && property.equals("pages")) {
            log.warn("DBELResolver:getType is not implemented!");
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        log.warn("DBELResolver:getFeatureDescriptors is not implemented!");
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof PageDefinition) {
            String action = String.valueOf(property);
            PageDefinition pageDef = (PageDefinition)base;
            try {
                Method m = pageDef.getPageBeanClass().getMethod(action, new Class[0]);
                if (m != null) {
                    context.setPropertyResolved(true);
                }
                return pageDef.getOutcome(action);
            }
            catch (Exception e) {
                throw new RuntimeException("Method " + action + " not found on bean " + pageDef.getPageBeanClass().getName(), e);
            }
        }
        if (base instanceof PageDefinitions) {
            String name = String.valueOf(property);
            try {
                Field field = base.getClass().getField(name);
                Object pageDef = field.get(base);
                if (pageDef == null || !(pageDef instanceof PageDefinition)) {
                    throw new RuntimeException("Illegal Page Defintion for property " + name);
                }
                context.setPropertyResolved(true);
                return pageDef;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get page defintion.", e);
            }
        }
        if (property.equals("pages") || property.equals("Pages")) {
            PageDefinitions pds = PageDefinitions.getInstance();
            if (pds == null) {
                throw new RuntimeException("No Page defintions available. Please create instance of class " + PageDefinitions.class.getName());
            }
            context.setPropertyResolved(true);
            return pds;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof PageDefinitions || base == null && property.equals("pages")) {
            log.info("ELResolver: property {} is read only.", property);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isReadOnly(context, base, property)) {
            NotSupportedException e = new NotSupportedException((Object)this, "setValue");
            FacesContext.getCurrentInstance().getExternalContext().log(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

