/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.http.HttpSinkConfig;
import org.apache.eventmesh.common.config.connector.http.SinkConnectorConfig;
import org.apache.eventmesh.connector.http.sink.handler.HttpSinkHandler;
import org.apache.eventmesh.connector.http.sink.handler.impl.CommonHttpSinkHandler;
import org.apache.eventmesh.connector.http.sink.handler.impl.HttpSinkHandlerRetryWrapper;
import org.apache.eventmesh.connector.http.sink.handler.impl.WebhookHttpSinkHandler;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSinkConnector
implements Sink,
ConnectorCreateService<Sink> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSinkConnector.class);
    private HttpSinkConfig httpSinkConfig;
    private HttpSinkHandler sinkHandler;
    private ThreadPoolExecutor executor;
    private final LinkedBlockingQueue<ConnectRecord> queue = new LinkedBlockingQueue(10000);
    private final AtomicBoolean isStart = new AtomicBoolean(true);

    public Class<? extends Config> configClass() {
        return HttpSinkConfig.class;
    }

    public Sink create() {
        return new HttpSinkConnector();
    }

    public void init(Config config) throws Exception {
        this.httpSinkConfig = (HttpSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.httpSinkConfig = (HttpSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        SinkConnectorConfig.populateFieldsWithDefaults((SinkConnectorConfig)this.httpSinkConfig.connectorConfig);
        CommonHttpSinkHandler nonRetryHandler = this.httpSinkConfig.connectorConfig.getWebhookConfig().isActivate() ? new WebhookHttpSinkHandler(this.httpSinkConfig.connectorConfig) : new CommonHttpSinkHandler(this.httpSinkConfig.connectorConfig);
        int maxRetries = this.httpSinkConfig.connectorConfig.getRetryConfig().getMaxRetries();
        if (maxRetries == 0) {
            this.sinkHandler = nonRetryHandler;
        } else if (maxRetries > 0) {
            this.sinkHandler = new HttpSinkHandlerRetryWrapper(this.httpSinkConfig.connectorConfig, nonRetryHandler);
        } else {
            throw new IllegalArgumentException("Max retries must be greater than or equal to 0.");
        }
        boolean isParallelized = this.httpSinkConfig.connectorConfig.isParallelized();
        int parallelism = isParallelized ? this.httpSinkConfig.connectorConfig.getParallelism() : 1;
        this.executor = new ThreadPoolExecutor(parallelism, parallelism, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new EventMeshThreadFactory("http-sink-handler"));
    }

    public void start() throws Exception {
        this.sinkHandler.start();
        for (int i = 0; i < this.httpSinkConfig.connectorConfig.getParallelism(); ++i) {
            this.executor.execute(() -> {
                while (this.isStart.get()) {
                    ConnectRecord connectRecord = null;
                    try {
                        connectRecord = this.queue.poll(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (connectRecord == null) continue;
                    this.sinkHandler.handle(connectRecord);
                }
            });
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.httpSinkConfig.connectorConfig.getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
        this.isStart.set(false);
        while (!this.queue.isEmpty()) {
            ConnectRecord record = this.queue.poll();
            this.sinkHandler.handle(record);
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.sinkHandler.stop();
        log.info("All tasks completed, start shut down http sink connector");
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord sinkRecord : sinkRecords) {
            try {
                if (Objects.isNull(sinkRecord)) {
                    log.warn("ConnectRecord data is null, ignore.");
                    continue;
                }
                this.queue.put(sinkRecord);
            }
            catch (Exception e) {
                log.error("Failed to sink message via HTTP. ", (Throwable)e);
            }
        }
    }

    @Generated
    public HttpSinkHandler getSinkHandler() {
        return this.sinkHandler;
    }
}

