/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeBuilder;
import com.navercorp.pinpoint.common.trace.ServiceTypeCategory;
import com.navercorp.pinpoint.common.trace.ServiceTypeProperty;

class DefaultServiceType
implements ServiceType {
    private final short code;
    private final String name;
    private final String desc;
    private final boolean terminal;
    private final boolean queue;
    private final boolean alias;
    private final boolean recordStatistics;
    private final boolean includeDestinationId;
    private final ServiceTypeCategory category;

    DefaultServiceType(ServiceTypeBuilder builder) {
        this.code = builder.code();
        this.name = builder.name();
        this.desc = builder.desc();
        this.terminal = builder.terminal();
        this.queue = builder.queue();
        this.recordStatistics = builder.recordStatistics();
        this.includeDestinationId = builder.includeDestinationId();
        this.category = ServiceTypeCategory.findCategory(this.code);
        this.alias = builder.alias();
    }

    DefaultServiceType(int code, String name, String desc, ServiceTypeProperty ... properties) {
        if (code > Short.MAX_VALUE || code < Short.MIN_VALUE) {
            throw new IllegalArgumentException("code must be a short value");
        }
        this.code = (short)code;
        this.name = name;
        this.desc = desc;
        this.category = ServiceTypeCategory.findCategory((short)code);
        boolean terminal = false;
        boolean queue = false;
        boolean recordStatistics = false;
        boolean includeDestinationId = false;
        boolean alias = false;
        block7: for (ServiceTypeProperty property : properties) {
            switch (property) {
                case TERMINAL: {
                    terminal = true;
                    continue block7;
                }
                case QUEUE: {
                    queue = true;
                    continue block7;
                }
                case RECORD_STATISTICS: {
                    recordStatistics = true;
                    continue block7;
                }
                case INCLUDE_DESTINATION_ID: {
                    includeDestinationId = true;
                    continue block7;
                }
                case ALIAS: {
                    alias = true;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Unknown ServiceTypeProperty:" + (Object)((Object)property));
                }
            }
        }
        this.terminal = terminal;
        this.queue = queue;
        this.recordStatistics = recordStatistics;
        this.includeDestinationId = includeDestinationId;
        this.alias = alias;
    }

    @Override
    public boolean isInternalMethod() {
        return this == INTERNAL_METHOD;
    }

    @Override
    public boolean isRpcClient() {
        return ServiceTypeCategory.RPC.contains(this.code);
    }

    @Override
    public boolean isRecordStatistics() {
        return this.recordStatistics;
    }

    @Override
    public boolean isUnknown() {
        return this == ServiceType.UNKNOWN;
    }

    @Override
    public boolean isUser() {
        return this == ServiceType.USER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public boolean isTerminal() {
        return this.terminal;
    }

    @Override
    public boolean isAlias() {
        return this.alias;
    }

    @Override
    public boolean isQueue() {
        return this.queue;
    }

    @Override
    public boolean isIncludeDestinationId() {
        return this.includeDestinationId;
    }

    @Override
    public ServiceTypeCategory getCategory() {
        return this.category;
    }

    @Override
    public HistogramSchema getHistogramSchema() {
        return this.category.getHistogramSchema();
    }

    @Override
    public boolean isWas() {
        return this.category == ServiceTypeCategory.SERVER;
    }

    public String toString() {
        return this.desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceType that = (DefaultServiceType)o;
        return this.code == that.code;
    }

    public int hashCode() {
        return this.code;
    }

    public static boolean isWas(short code) {
        return ServiceTypeCategory.SERVER.contains(code);
    }
}

