/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DefaultDataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DisabledDataSourceMonitorRegistryService;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSourceMonitorRegistryServiceProvider
implements Provider<DataSourceMonitorRegistryService> {
    private static final int DEFAULT_LIMIT_SIZE = 20;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean traceAgentDataSource;
    private final int dataSourceTraceLimitSize;

    @Inject
    public DataSourceMonitorRegistryServiceProvider(ContextConfig contextConfig) {
        Objects.requireNonNull(contextConfig, "contextConfig");
        this.traceAgentDataSource = contextConfig.isTraceAgentDataSource();
        this.dataSourceTraceLimitSize = contextConfig.getDataSourceTraceLimitSize();
    }

    public DataSourceMonitorRegistryService get() {
        if (!this.traceAgentDataSource) {
            return new DisabledDataSourceMonitorRegistryService();
        }
        if (this.dataSourceTraceLimitSize <= 0) {
            this.logger.info("dataSourceTraceLimitSize must greater than 0. It will be set default size {}", (Object)20);
            return new DefaultDataSourceMonitorRegistryService(20);
        }
        return new DefaultDataSourceMonitorRegistryService(this.dataSourceTraceLimitSize);
    }
}

