/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.GrpcSpanProcessorV2;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import java.util.Objects;

public class GrpcSpanProcessorProvider
implements Provider<SpanProcessor<PSpan.Builder, PSpanChunk.Builder>> {
    private final TraceDataFormatVersion version;

    @Inject
    public GrpcSpanProcessorProvider(TraceDataFormatVersion version) {
        this.version = Objects.requireNonNull(version, "version");
    }

    public SpanProcessor<PSpan.Builder, PSpanChunk.Builder> get() {
        if (this.version == TraceDataFormatVersion.V2) {
            return new GrpcSpanProcessorV2();
        }
        throw new UnsupportedOperationException("unknown version :" + (Object)((Object)this.version));
    }
}

