/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder.proxy;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestAnnotationFactory;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestHeader;
import com.navercorp.pinpoint.profiler.context.recorder.proxy.ProxyRequestParser;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultProxyRequestRecorder<T>
implements ProxyRequestRecorder<T> {
    private static final Logger logger = LogManager.getLogger(DefaultProxyRequestRecorder.class);
    private final boolean isDebug = logger.isDebugEnabled();
    private final ProxyRequestParser[] proxyRequestParsers;
    private final RequestAdaptor<T> requestAdaptor;
    private final ProxyRequestAnnotationFactory annotationFactory = new ProxyRequestAnnotationFactory();

    public DefaultProxyRequestRecorder(List<ProxyRequestParser> proxyRequestParserList, RequestAdaptor<T> requestAdaptor) {
        Objects.requireNonNull(proxyRequestParserList, "proxyRequestParserList");
        this.proxyRequestParsers = proxyRequestParserList.toArray(new ProxyRequestParser[0]);
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
    }

    public void record(SpanRecorder recorder, T request) {
        block4: {
            if (recorder == null || request == null) {
                return;
            }
            try {
                for (ProxyRequestParser parser : this.proxyRequestParsers) {
                    this.parseHeaderAndRecord(recorder, request, parser);
                }
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) break block4;
                logger.info("Failed to record proxy http header. cause={}", (Object)e.getMessage());
            }
        }
    }

    private void parseHeaderAndRecord(SpanRecorder recorder, T request, ProxyRequestParser parser) {
        for (String name : parser.getHttpHeaderNameList()) {
            String value = this.requestAdaptor.getHeader(request, name);
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            ProxyRequestHeader header = parser.parseHeader(name, value);
            if (header.isValid()) {
                recorder.recordAttribute(this.annotationFactory.getAnnotationKey(), this.annotationFactory.getAnnotationValue(parser.getCode(), header));
                if (!this.isDebug) continue;
                logger.debug("Record proxy request header. name={}, value={}", (Object)name, (Object)value);
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info("Failed to parse proxy request header. name={}. value={}, cause={}", (Object)name, (Object)value, (Object)header.getCause());
        }
    }
}

