/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redisson.api.TimeSeriesEntry;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class TimeSeriesEntryReplayDecoder
implements MultiDecoder<List<TimeSeriesEntry<Object, Object>>> {
    private boolean reverse;

    public TimeSeriesEntryReplayDecoder() {
        this(false);
    }

    public TimeSeriesEntryReplayDecoder(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state, long size) {
        if (paramNum % 4 == 2 || paramNum % 4 == 3) {
            return LongCodec.INSTANCE.getValueDecoder();
        }
        return MultiDecoder.super.getDecoder(codec, paramNum, state, size);
    }

    @Override
    public List<TimeSeriesEntry<Object, Object>> decode(List<Object> parts, State state) {
        ArrayList<TimeSeriesEntry<Object, Object>> result = new ArrayList<TimeSeriesEntry<Object, Object>>();
        for (int i = 0; i < parts.size(); i += 4) {
            Long n = (Long)parts.get(i + 2);
            Object label = null;
            if (n == 3L) {
                label = parts.get(i + 1);
            }
            result.add(new TimeSeriesEntry<Object, Object>((Long)parts.get(i + 3), parts.get(i), label));
        }
        if (this.reverse) {
            Collections.reverse(result);
        }
        return result;
    }
}

