/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonMap;
import org.redisson.client.RedisClient;

public class RedissonMapRxIterator<K, V, M> {
    private final RedissonMap<K, V> map;
    private final String pattern;
    private final int count;

    public RedissonMapRxIterator(RedissonMap<K, V> map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    public Flowable<M> create() {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private String nextIterPos = "0";
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            public void accept(long value) throws Exception {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues();
                    this.completed = false;
                }
            }

            protected void nextValues() {
                RedissonMapRxIterator.this.map.scanIteratorAsync(RedissonMapRxIterator.this.map.getRawName(), this.client, this.nextIterPos, RedissonMapRxIterator.this.pattern, RedissonMapRxIterator.this.count).whenComplete((res, e) -> {
                    if (e != null) {
                        p.onError(e);
                        return;
                    }
                    if (this.finished) {
                        this.client = null;
                        this.nextIterPos = "0";
                        return;
                    }
                    this.client = res.getRedisClient();
                    this.nextIterPos = res.getPos();
                    for (Map.Entry entry : res.getValues()) {
                        Object val = RedissonMapRxIterator.this.getValue(entry);
                        p.onNext(val);
                        this.elementsRead.incrementAndGet();
                    }
                    if (this.elementsRead.get() >= this.readAmount.get()) {
                        p.onComplete();
                        this.elementsRead.set(0L);
                        this.completed = true;
                        return;
                    }
                    if ("0".equals(res.getPos()) && !RedissonMapRxIterator.this.tryAgain()) {
                        this.finished = true;
                        p.onComplete();
                    }
                    if (this.finished || this.completed) {
                        return;
                    }
                    this.nextValues();
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    M getValue(final Map.Entry<Object, Object> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()){

            @Override
            public V setValue(V value) {
                return RedissonMapRxIterator.this.map.put(entry.getKey(), value);
            }
        };
    }
}

