/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.position;

import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.AbstractComponent;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceCheckConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.JobRdbFullPosition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbColumnDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbDBDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbTableDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLTableDef;
import org.apache.eventmesh.common.remote.offset.RecordPosition;
import org.apache.eventmesh.common.remote.offset.canal.CanalFullRecordOffset;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.canal.DatabaseConnection;
import org.apache.eventmesh.connector.canal.source.position.TableFullPosition;
import org.apache.eventmesh.connector.canal.source.table.RdbSimpleTable;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalCheckPositionMgr
extends AbstractComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalCheckPositionMgr.class);
    private final CanalSourceCheckConfig config;
    private final Map<RdbSimpleTable, JobRdbFullPosition> positions = new LinkedHashMap<RdbSimpleTable, JobRdbFullPosition>();
    private final RdbTableMgr tableMgr;

    public CanalCheckPositionMgr(CanalSourceCheckConfig config, RdbTableMgr tableMgr) {
        this.config = config;
        this.tableMgr = tableMgr;
    }

    protected void run() throws Exception {
        if (this.config == null || this.config.getSourceConnectorConfig() == null || this.config.getSourceConnectorConfig().getDatabases() == null) {
            log.info("config or database is null");
            return;
        }
        this.prepareRecordPosition();
        this.initPositions();
    }

    public void prepareRecordPosition() {
        if (this.config.getStartPosition() != null && !this.config.getStartPosition().isEmpty()) {
            for (RecordPosition record : this.config.getStartPosition()) {
                CanalFullRecordOffset offset = (CanalFullRecordOffset)record.getRecordOffset();
                RdbSimpleTable table = new RdbSimpleTable(offset.getPosition().getSchema(), offset.getPosition().getTableName());
                this.positions.put(table, offset.getPosition());
            }
        }
    }

    public JobRdbFullPosition getPosition(RdbSimpleTable table) {
        return this.positions.get((Object)table);
    }

    public boolean isFinished() {
        for (JobRdbFullPosition position : this.positions.values()) {
            if (position.isFinished()) continue;
            log.info("schema [{}] table [{}] is not finish", (Object)position.getSchema(), (Object)position.getTableName());
            return false;
        }
        return true;
    }

    private void initPositions() {
        for (RdbDBDefinition database : this.config.getSourceConnectorConfig().getDatabases()) {
            for (RdbTableDefinition table : database.getTables()) {
                try {
                    RdbSimpleTable simpleTable = new RdbSimpleTable(database.getSchemaName(), table.getTableName());
                    RdbTableDefinition tableDefinition = this.tableMgr.getTable(simpleTable);
                    if (tableDefinition == null) {
                        log.error("db [{}] table [{}] definition is null", (Object)database.getSchemaName(), (Object)table.getTableName());
                        continue;
                    }
                    log.info("init position of data [{}] table [{}]", (Object)database.getSchemaName(), (Object)table.getTableName());
                    JobRdbFullPosition recordPosition = this.positions.get((Object)simpleTable);
                    if (recordPosition != null && recordPosition.isFinished()) continue;
                    this.positions.put(simpleTable, this.fetchTableInfo((DataSource)DatabaseConnection.sourceDataSource, (MySQLTableDef)tableDefinition, recordPosition));
                }
                catch (Exception e) {
                    log.error("process schema [{}] table [{}] position fail", new Object[]{database.getSchemaName(), table.getTableName(), e});
                }
            }
        }
    }

    private JobRdbFullPosition fetchTableInfo(DataSource dataSource, MySQLTableDef tableDefinition, JobRdbFullPosition recordPosition) throws SQLException {
        TableFullPosition position = new TableFullPosition();
        LinkedHashMap<String, Object> preMinPrimaryKeys = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> preMaxPrimaryKeys = new LinkedHashMap<String, Object>();
        for (String pk : tableDefinition.getPrimaryKeys()) {
            Object min = this.fetchMinPrimaryKey(dataSource, tableDefinition, preMinPrimaryKeys, pk);
            Object max = this.fetchMaxPrimaryKey(dataSource, tableDefinition, preMaxPrimaryKeys, pk);
            preMinPrimaryKeys.put(pk, min);
            preMaxPrimaryKeys.put(pk, max);
            position.getCurPrimaryKeyCols().put(pk, min);
            position.getMinPrimaryKeyCols().put(pk, min);
            position.getMaxPrimaryKeyCols().put(pk, max);
        }
        JobRdbFullPosition jobRdbFullPosition = new JobRdbFullPosition();
        if (recordPosition != null) {
            TableFullPosition record;
            if (StringUtils.isNotBlank((CharSequence)recordPosition.getPrimaryKeyRecords()) && (record = (TableFullPosition)JsonUtils.parseObject((String)recordPosition.getPrimaryKeyRecords(), TableFullPosition.class)) != null && record.getCurPrimaryKeyCols() != null && !record.getCurPrimaryKeyCols().isEmpty()) {
                position.setCurPrimaryKeyCols(record.getCurPrimaryKeyCols());
            }
            jobRdbFullPosition.setPercent(recordPosition.getPercent());
        }
        long rowCount = this.queryCurTableRowCount(dataSource, tableDefinition);
        jobRdbFullPosition.setSchema(tableDefinition.getSchemaName());
        jobRdbFullPosition.setTableName(tableDefinition.getTableName());
        jobRdbFullPosition.setMaxCount(rowCount);
        jobRdbFullPosition.setPrimaryKeyRecords(JsonUtils.toJSONString((Object)position));
        return jobRdbFullPosition;
    }

    private long queryCurTableRowCount(DataSource datasource, MySQLTableDef tableDefinition) throws SQLException {
        String sql = "select `AVG_ROW_LENGTH`,`DATA_LENGTH` from information_schema.TABLES where `TABLE_SCHEMA`='" + tableDefinition.getSchemaName() + "' and `TABLE_NAME`='" + tableDefinition.getTableName() + "'";
        try (Statement statement = datasource.getConnection().createStatement();){
            long l;
            block14: {
                ResultSet resultSet = statement.executeQuery(sql);
                try {
                    long result = 0L;
                    if (resultSet.next()) {
                        long avgRowLength = resultSet.getLong("AVG_ROW_LENGTH");
                        long dataLength = resultSet.getLong("DATA_LENGTH");
                        if (avgRowLength != 0L) {
                            result = dataLength / avgRowLength;
                        }
                    }
                    l = result;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    private void appendPrePrimaryKey(Map<String, Object> preMap, StringBuilder sql) {
        if (preMap != null && !preMap.isEmpty()) {
            sql.append(" WHERE ");
            boolean first = true;
            for (Map.Entry<String, Object> entry : preMap.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sql.append(" AND ");
                }
                sql.append("`").append(entry.getKey()).append("`").append("=?");
            }
        }
    }

    private void setValue2Statement(PreparedStatement ps, Map<String, Object> preMap, MySQLTableDef tableDefinition) throws SQLException {
        if (preMap != null && !preMap.isEmpty()) {
            int index = 1;
            for (Map.Entry<String, Object> entry : preMap.entrySet()) {
                RdbColumnDefinition def = (RdbColumnDefinition)tableDefinition.getColumnDefinitions().get(entry.getKey());
                ps.setObject(index, entry.getValue(), def.getJdbcType().getVendorTypeNumber());
                ++index;
            }
        }
    }

    private Object fetchMinPrimaryKey(DataSource dataSource, MySQLTableDef tableDefinition, Map<String, Object> prePrimary, String curPrimaryKeyCol) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT MIN(").append("`").append(curPrimaryKeyCol).append("`").append(") min_primary_key FROM").append("`").append(tableDefinition.getSchemaName()).append("`").append(".").append("`").append(tableDefinition.getTableName()).append("`");
        this.appendPrePrimaryKey(prePrimary, builder);
        String sql = builder.toString();
        log.info("fetch min primary sql [{}]", (Object)sql);
        try (PreparedStatement statement = dataSource.getConnection().prepareStatement(sql);){
            this.setValue2Statement(statement, prePrimary, tableDefinition);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    RdbColumnDefinition columnDefinition = (RdbColumnDefinition)tableDefinition.getColumnDefinitions().get(curPrimaryKeyCol);
                    if (columnDefinition.getJdbcType() == JDBCType.TIMESTAMP) {
                        String string = resultSet.getString("min_primary_key");
                        return string;
                    }
                    Object object = resultSet.getObject("min_primary_key");
                    return object;
                }
            }
        }
        return null;
    }

    private Object fetchMaxPrimaryKey(DataSource dataSource, MySQLTableDef tableDefinition, Map<String, Object> prePrimary, String curPrimaryKeyCol) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT MAX(").append("`").append(curPrimaryKeyCol).append("`").append(") max_primary_key FROM").append("`").append(tableDefinition.getSchemaName()).append("`").append(".").append("`").append(tableDefinition.getTableName()).append("`");
        this.appendPrePrimaryKey(prePrimary, builder);
        String sql = builder.toString();
        log.info("fetch max primary sql [{}]", (Object)sql);
        try (PreparedStatement statement = dataSource.getConnection().prepareStatement(sql);){
            this.setValue2Statement(statement, prePrimary, tableDefinition);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    RdbColumnDefinition columnDefinition = (RdbColumnDefinition)tableDefinition.getColumnDefinitions().get(curPrimaryKeyCol);
                    if (columnDefinition.getJdbcType() == JDBCType.TIMESTAMP) {
                        String string = resultSet.getString("max_primary_key");
                        return string;
                    }
                    Object object = resultSet.getObject("max_primary_key");
                    return object;
                }
            }
        }
        return null;
    }

    protected void shutdown() throws Exception {
    }
}

