/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.prometheus.source.connector;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.prometheus.PrometheusSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.prometheus.PrometheusRecordOffset;
import org.apache.eventmesh.common.remote.offset.prometheus.PrometheusRecordPartition;
import org.apache.eventmesh.connector.prometheus.model.QueryPrometheusReq;
import org.apache.eventmesh.connector.prometheus.model.QueryPrometheusRsp;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusSourceConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusSourceConnector.class);
    private static final int MAX_RETRY_TIME = 3;
    private static final int FIXED_WAIT_SECOND = 1;
    private final Retryer<Boolean> retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(res -> res == false).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withRetryListener(new RetryListener(){

        public <V> void onRetry(Attempt<V> attempt) {
            long times = attempt.getAttemptNumber();
            log.warn("retry invoke http,times={}", (Object)times);
        }
    }).build();
    private PrometheusSourceConfig sourceConfig;
    private CloseableHttpClient httpClient;
    private QueryPrometheusReq queryPrometheusReq;
    private Long initTime;
    private Long startTime;
    private Integer interval;
    private String url;

    public Class<? extends Config> configClass() {
        return PrometheusSourceConfig.class;
    }

    public void init(Config config) {
        this.sourceConfig = (PrometheusSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (PrometheusSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        this.queryPrometheusReq = new QueryPrometheusReq();
        this.queryPrometheusReq.setQuery(this.sourceConfig.getConnectorConfig().getQuery());
        this.queryPrometheusReq.setStep(this.sourceConfig.getConnectorConfig().getStep());
        this.interval = this.sourceConfig.getConnectorConfig().getInterval();
        this.initTime = this.sourceConfig.getConnectorConfig().getInitTime();
        this.url = MessageFormat.format("{0}/{1}", this.sourceConfig.getConnectorConfig().getAddress(), this.sourceConfig.getConnectorConfig().getApi());
        this.httpClient = HttpClientBuilder.create().build();
    }

    public void start() {
        log.info("prometheus source connector start.");
        this.startTime = this.initTime != null ? this.initTime : System.currentTimeMillis() / 1000L;
    }

    public void commit(ConnectRecord record) {
        this.startTime = this.startTime + (long)this.interval.intValue();
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        log.info("prometheus source connector stop.");
    }

    public List<ConnectRecord> poll() {
        try {
            if (this.startTime > System.currentTimeMillis() / 1000L - (long)this.interval.intValue()) {
                Thread.sleep(this.interval * 1000);
            }
            AtomicReference response = null;
            this.retryer.call(() -> {
                try {
                    this.queryPrometheusReq.setStart(this.startTime);
                    this.queryPrometheusReq.setEnd(this.startTime + (long)this.interval.intValue());
                    HttpPost httpPost = new HttpPost(this.url);
                    httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)this.queryPrometheusReq), ContentType.APPLICATION_JSON));
                    response.set(this.httpClient.execute((HttpUriRequest)httpPost));
                    return ((CloseableHttpResponse)response.get()).getStatusLine().getStatusCode() == 200;
                }
                catch (Exception e) {
                    log.error("invoke http failed", (Throwable)e);
                    return false;
                }
            });
            String result = EntityUtils.toString((HttpEntity)((CloseableHttpResponse)response.get()).getEntity(), (Charset)StandardCharsets.UTF_8);
            QueryPrometheusRsp responseData = (QueryPrometheusRsp)JSONObject.parseObject((String)result, QueryPrometheusRsp.class);
            List<ConnectRecord> connectRecords = responseData.getData().getResult().stream().map(this::assembleRecord).collect(Collectors.toList());
            return connectRecords;
        }
        catch (Exception e) {
            log.error("failed to poll message from prometheus", (Throwable)e);
            return null;
        }
    }

    private ConnectRecord assembleRecord(String data) {
        Long timestamp = System.currentTimeMillis();
        PrometheusRecordPartition recordPartition = new PrometheusRecordPartition();
        PrometheusRecordOffset recordOffset = new PrometheusRecordOffset();
        return new ConnectRecord((RecordPartition)recordPartition, (RecordOffset)recordOffset, timestamp, (Object)data);
    }
}

