/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;

public class ClassFilters {
    public static final ClassFilter ACCEPT_ALL = new ClassFilter(){

        @Override
        public boolean accept(InstrumentClass clazz) {
            return true;
        }
    };

    private ClassFilters() {
    }

    public static ClassFilter chain(ClassFilter ... classFilters) {
        return new ChainFilter(classFilters);
    }

    public static ClassFilter name(String ... classNames) {
        return new ClassNameFilter(classNames);
    }

    public static ClassFilter enclosingMethod(String methodName, String ... parameterTypes) {
        return new EnclosingMethodFilter(methodName, parameterTypes);
    }

    public static ClassFilter interfaze(String ... interfaceNames) {
        return new InterfaceFilter(interfaceNames);
    }

    private static final class ChainFilter
    implements ClassFilter {
        private final ClassFilter[] classFilters;

        public ChainFilter(ClassFilter[] classFilters) {
            this.classFilters = classFilters;
        }

        @Override
        public boolean accept(InstrumentClass clazz) {
            if (this.classFilters == null) {
                return false;
            }
            for (ClassFilter classFilter : this.classFilters) {
                if (classFilter != null && classFilter.accept(clazz)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class InterfaceFilter
    implements ClassFilter {
        private final String[] interfaceNames;

        public InterfaceFilter(String[] interfaceNames) {
            this.interfaceNames = interfaceNames;
        }

        @Override
        public boolean accept(InstrumentClass clazz) {
            if (this.interfaceNames == null) {
                return false;
            }
            for (String interfaceName : this.interfaceNames) {
                for (String name : clazz.getInterfaces()) {
                    if (name == null || !name.equals(interfaceName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class EnclosingMethodFilter
    implements ClassFilter {
        private final String methodName;
        private final String[] parameterTypes;

        public EnclosingMethodFilter(String methodName, String[] parameterTypes) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean accept(InstrumentClass clazz) {
            if (this.methodName == null) {
                return false;
            }
            return clazz.hasEnclosingMethod(this.methodName, this.parameterTypes);
        }
    }

    private static final class ClassNameFilter
    implements ClassFilter {
        private final String[] classNames;

        public ClassNameFilter(String[] classNames) {
            this.classNames = classNames;
        }

        @Override
        public boolean accept(InstrumentClass clazz) {
            if (this.classNames == null) {
                return false;
            }
            for (String className : this.classNames) {
                if (className == null || !className.equals(clazz.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

