/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import java.util.Locale;
import lombok.Generated;

public class EventRequest
extends Request<EventContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final String eventType;
    private final String eventSubtype;
    private EventContext context = new EventContext();

    public EventRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        JsonObject payload = ((JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class)).getAsJsonObject();
        JsonObject event = payload.get("event").getAsJsonObject();
        this.eventType = event.get("type").getAsString();
        this.eventSubtype = event.get("subtype") != null && !event.get("subtype").isJsonNull() ? event.get("subtype").getAsString() : null;
        String enterpriseId = null;
        String teamId = null;
        if (payload.get("authorizations") != null && !payload.get("authorizations").isJsonNull()) {
            JsonObject authorization;
            JsonArray authorizations = payload.get("authorizations").getAsJsonArray();
            if (authorizations.size() > 0 && (authorization = authorizations.get(0).getAsJsonObject()) != null && !authorization.isJsonNull()) {
                JsonElement teamIdElement;
                JsonElement enterpriseIdElement = authorization.get("enterprise_id");
                if (enterpriseIdElement != null && !enterpriseIdElement.isJsonNull()) {
                    enterpriseId = enterpriseIdElement.getAsString();
                }
                if ((teamIdElement = authorization.get("team_id")) != null && !teamIdElement.isJsonNull()) {
                    teamId = teamIdElement.getAsString();
                }
            }
        } else {
            JsonElement teamIdElement;
            JsonElement enterpriseIdElement = payload.get("enterprise_id");
            if (enterpriseIdElement != null && !enterpriseIdElement.isJsonNull()) {
                enterpriseId = enterpriseIdElement.getAsString();
            }
            if ((teamIdElement = payload.get("team_id")) != null && !teamIdElement.isJsonNull()) {
                teamId = teamIdElement.getAsString();
            }
        }
        this.getContext().setEnterpriseId(enterpriseId);
        this.getContext().setTeamId(teamId);
        if (this.headers != null && this.headers.getNames().size() > 0) {
            for (String name : this.headers.getNames()) {
                String normalizedName = name.toLowerCase(Locale.ENGLISH);
                String value = this.headers.getFirstValue(name);
                if (normalizedName.equals("x-slack-retry-num")) {
                    try {
                        Integer num = Integer.parseInt(value);
                        this.getContext().setRetryNum(num);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!normalizedName.equals("x-slack-retry-reason")) continue;
                this.getContext().setRetryReason(value);
            }
        }
        if (event.get("channel") != null && event.get("channel").isJsonPrimitive()) {
            this.getContext().setChannelId(event.get("channel").getAsString());
        } else if (event.get("channel_id") != null) {
            this.getContext().setChannelId(event.get("channel_id").getAsString());
        }
        if (this.eventType != null && this.eventType.equals("function_executed")) {
            if (event.get("bot_access_token") != null) {
                String functionBotAccessToken = event.get("bot_access_token").getAsString();
                this.getContext().setFunctionBotAccessToken(functionBotAccessToken);
            }
            if (event.get("function_execution_id") != null) {
                String functionExecutionId = event.get("function_execution_id").getAsString();
                this.getContext().setFunctionExecutionId(functionExecutionId);
            }
        }
    }

    @Override
    public EventContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.Event;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventTypeAndSubtype() {
        if (!this.eventType.equals("message") || this.eventSubtype == null) {
            return this.eventType;
        }
        return this.eventType + ":" + this.eventSubtype;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "EventRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", eventType=" + this.getEventType() + ", eventSubtype=" + this.eventSubtype + ", context=" + this.getContext() + ")";
    }
}

