/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.connector.openfunction.config.OpenFunctionServerConfig;
import org.apache.eventmesh.connector.openfunction.service.ConsumerService;
import org.apache.eventmesh.connector.openfunction.service.ProducerService;
import org.apache.eventmesh.connector.openfunction.sink.connector.OpenFunctionSinkConnector;
import org.apache.eventmesh.connector.openfunction.source.connector.OpenFunctionSourceConnector;
import org.apache.eventmesh.openconnect.Application;
import org.apache.eventmesh.openconnect.api.connector.Connector;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFunctionConnectServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFunctionConnectServer.class);
    private static Server server;

    public static void main(String[] args) throws Exception {
        OpenFunctionServerConfig serverConfig = (OpenFunctionServerConfig)((Object)ConfigUtil.parse(OpenFunctionServerConfig.class, (String)"server-config.yml"));
        int serverPort = serverConfig.getServerPort();
        ServerBuilder grpcServerBuilder = ServerBuilder.forPort((int)serverPort);
        if (serverConfig.isSourceEnable()) {
            Application openFunctionSourceApp = new Application();
            openFunctionSourceApp.run(OpenFunctionSourceConnector.class);
        }
        if (serverConfig.isSinkEnable()) {
            Application openFunctionSinkApp = new Application();
            openFunctionSinkApp.run(OpenFunctionSinkConnector.class);
        }
        Map connectorMap = Application.CONNECTOR_MAP;
        for (Map.Entry entry : connectorMap.entrySet()) {
            if (Application.isSource(((Connector)entry.getValue()).getClass())) {
                grpcServerBuilder.addService((BindableService)new ProducerService((OpenFunctionSourceConnector)entry.getValue(), serverConfig));
                continue;
            }
            if (!Application.isSink(((Connector)entry.getValue()).getClass())) continue;
            grpcServerBuilder.addService((BindableService)new ConsumerService((OpenFunctionSinkConnector)entry.getValue(), serverConfig));
        }
        server = grpcServerBuilder.build();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                server.shutdown();
            }
            catch (Exception e) {
                log.error("exception when shutdown.", (Throwable)e);
            }
        }));
        server.awaitTermination();
    }
}

