/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CacheControlDirective {
    PUBLIC("public"),
    PRIVATE("private"),
    NO_STORE("no-store"),
    NO_CACHE("no-cache"),
    SHARED_MAX_AGE("s-maxage"),
    MAX_AGE("max-age"),
    STALE_IF_ERROR("stale-if-error"),
    STALE_WHILE_REVALIDATE("stale-while-revalidate"),
    MUST_REVALIDATE("must-revalidate");

    private final String value;
    private static final Map<String, CacheControlDirective> VALUE_MAP;

    public static Optional<CacheControlDirective> fromHeader(String headerValue) {
        if (VALUE_MAP.containsKey(headerValue)) {
            return Optional.of(VALUE_MAP.get(headerValue));
        }
        return Optional.empty();
    }

    private CacheControlDirective(String value) {
        this.value = value;
    }

    static {
        VALUE_MAP = Arrays.stream(CacheControlDirective.values()).collect(Collectors.toMap(d -> d.value, Function.identity()));
    }
}

