/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.loader;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.delegation.ParserFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.loader.BaseDelegateFactory;
import org.apache.flink.table.planner.loader.PlannerModule;

@Internal
public class DelegatePlannerFactory
extends BaseDelegateFactory<PlannerFactory>
implements PlannerFactory {
    private final Set<SqlDialect> seenDialect = new HashSet<SqlDialect>();

    public DelegatePlannerFactory() {
        super(PlannerModule.getInstance().loadPlannerFactory());
        this.seenDialect.add(SqlDialect.DEFAULT);
    }

    public Planner create(PlannerFactory.Context context) {
        SqlDialect currentDialect = context.getTableConfig().getSqlDialect();
        if (!this.seenDialect.contains(currentDialect)) {
            URL dialectJarUrl = this.tryGetJarURLForDialect(PlannerFactory.class.getClassLoader(), currentDialect);
            PlannerModule.getInstance().addUrlToClassLoader(dialectJarUrl);
        }
        return ((PlannerFactory)this.delegate).create(context);
    }

    private URL tryGetJarURLForDialect(ClassLoader classLoader, SqlDialect sqlDialect) {
        ParserFactory parserFactory = (ParserFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, ParserFactory.class, (String)sqlDialect.name().toLowerCase());
        ProtectionDomain protectionDomain = parserFactory.getClass().getProtectionDomain();
        return protectionDomain.getCodeSource().getLocation();
    }
}

