/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.io;

import java.io.File;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.geode.LogWriter;
import org.apache.geode.internal.io.RollingFileHandler;

public class MainWithChildrenRollingFileHandler
implements RollingFileHandler {
    private static final Pattern MAIN_ID_PATTERN = Pattern.compile(".+-\\d+-\\d+\\..+");
    private static final Pattern META_ID_PATTERN = Pattern.compile("meta-.+-\\d+\\..+");
    private static final Pattern CHILD_ID_PATTERN = Pattern.compile(".+-\\d+-\\d+\\..+");

    @Override
    public int calcNextChildId(File file, int mainId) {
        File[] children;
        int result = 0;
        File dir = this.getParentFile(file.getAbsoluteFile());
        int endIdx1 = file.getName().indexOf(45);
        int endIdx2 = file.getName().lastIndexOf(46);
        String baseName = endIdx1 != -1 ? file.getName().substring(0, endIdx1) : (endIdx2 != -1 ? file.getName().substring(0, endIdx2) : file.getName());
        for (File child : children = this.findChildren(dir, CHILD_ID_PATTERN)) {
            String name = child.getName();
            if (!name.startsWith(baseName)) continue;
            int endIdIdx = name.lastIndexOf(45);
            int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
            String id = name.substring(startIdIdx + 1, endIdIdx);
            int startChild = name.lastIndexOf("-");
            int endChild = name.lastIndexOf(".");
            if (startChild <= 0 || endChild <= 0) continue;
            String childId = name.substring(startChild + 1, endChild);
            try {
                int mainLogId = Integer.parseInt(id);
                int childLogId = Integer.parseInt(childId);
                if (mainLogId != mainId || childLogId <= result) continue;
                result = childLogId;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ++result;
    }

    @Override
    public int calcNextMainId(File dir, boolean toCreateNew) {
        File[] children;
        int result = 0;
        for (File child : children = this.findChildren(dir, MAIN_ID_PATTERN)) {
            String name = child.getName();
            int endIdIdx = name.lastIndexOf(45);
            int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
            String id = name.substring(startIdIdx + 1, endIdIdx);
            try {
                int mid = Integer.parseInt(id);
                if (mid <= result) continue;
                result = mid;
            }
            catch (NumberFormatException mid) {
                // empty catch block
            }
        }
        if (toCreateNew) {
            File[] metaFiles;
            for (File metaFile : metaFiles = this.findChildren(dir, META_ID_PATTERN)) {
                String name = metaFile.getName();
                int endIdIdx = name.lastIndexOf(46);
                int startIdIdx = name.lastIndexOf(45, endIdIdx - 1);
                String id = name.substring(startIdIdx + 1, endIdIdx);
                try {
                    int mid = Integer.parseInt(id);
                    if (mid <= result) continue;
                    result = mid;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++result;
        }
        return result;
    }

    @Override
    public void checkDiskSpace(String type, File newFile, long spaceLimit, File dir, LogWriter logger) {
        this.checkDiskSpace(type, newFile, spaceLimit, dir, this.getFilePattern(newFile.getName()), logger);
    }

    private void checkDiskSpace(String type, File newFile, long spaceLimit, File dir, Pattern pattern, LogWriter logger) {
        if (spaceLimit == 0L || pattern == null) {
            return;
        }
        File[] children = this.findChildrenExcept(dir, pattern, newFile);
        LogWriter logWriter = logger;
        if (children == null) {
            if (dir.isDirectory()) {
                logWriter.warning(String.format("Could not check disk space on %s because java.io.File.listFiles returned null. This could be caused by a lack of file descriptors.", dir));
            }
            return;
        }
        Arrays.sort(children, (o1, o2) -> {
            File f1 = (File)o1;
            File f2 = (File)o2;
            long diff = f1.lastModified() - f2.lastModified();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        });
        long spaceUsed = 0L;
        for (File child : children) {
            spaceUsed += child.length();
        }
        for (int idx = 0; spaceUsed >= spaceLimit && idx < children.length; ++idx) {
            long childSize = children[idx].length();
            if (this.delete(children[idx])) {
                spaceUsed -= childSize;
                logWriter.info(String.format("Deleted inactive %s %s.", type, children[idx]));
                continue;
            }
            logWriter.warning(String.format("Could not delete inactive %s %s.", type, children[idx]));
        }
        if (spaceUsed > spaceLimit) {
            logWriter.warning(String.format("Could not free space in %s directory.  The space used is %s which exceeds the configured limit of %s.", type, spaceUsed, spaceLimit));
        }
    }

    protected boolean delete(File file) {
        return file.delete();
    }

    @Override
    public String formatId(int id) {
        StringBuilder result = new StringBuilder(10);
        result.append('-');
        if (id < 10) {
            result.append('0');
        }
        result.append(id);
        return result.toString();
    }

    @Override
    public File getParentFile(File file) {
        File tmp = file.getAbsoluteFile().getParentFile();
        if (tmp == null) {
            tmp = new File(".");
        }
        return tmp;
    }

    Pattern getFilePattern(String name) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        int extIdx = name.lastIndexOf(46);
        String ext = "";
        if (extIdx != -1) {
            ext = "\\Q" + name.substring(extIdx) + "\\E";
            name = name.substring(0, extIdx);
        }
        name = "\\Q" + name + "\\E-\\d+-\\d+" + ext;
        return Pattern.compile(name);
    }

    private File[] findChildren(File dir, Pattern pattern) {
        return dir.listFiles((dir1, name) -> pattern.matcher(name).matches());
    }

    private File[] findChildrenExcept(File dir, Pattern pattern, File exception) {
        String exceptionName;
        String string = exceptionName = exception == null ? null : exception.getName();
        if (dir == null) {
            return new File[0];
        }
        return dir.listFiles((dir1, name) -> !name.equals(exceptionName) && pattern.matcher(name).matches());
    }
}

