/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.model.AuditFilter;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.CacheMap;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerAbstractPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerAuditPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerCachedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceEvaluatorsRetriever;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyRepository {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyRepository.class);
    private static final Logger PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private static final Logger PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.retrieval");
    private final String serviceName;
    private final String zoneName;
    private final String appId;
    private final RangerPolicyEngineOptions options;
    private final RangerPluginContext pluginContext;
    private final RangerServiceDef serviceDef;
    private List<RangerPolicy> policies;
    private final long policyVersion;
    private List<RangerContextEnricher> contextEnrichers;
    private final AuditModeEnum auditModeEnum;
    private final Map<String, AuditInfo> accessAuditCache;
    private final String componentServiceName;
    private final RangerServiceDef componentServiceDef;
    private final Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> policyResourceTrie;
    private final Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> dataMaskResourceTrie;
    private final Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> rowFilterResourceTrie;
    private final Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> auditFilterResourceTrie;
    private List<RangerPolicyEvaluator> policyEvaluators;
    private List<RangerPolicyEvaluator> dataMaskPolicyEvaluators;
    private List<RangerPolicyEvaluator> rowFilterPolicyEvaluators;
    private final List<RangerPolicyEvaluator> auditPolicyEvaluators;
    private Map<Long, RangerPolicyEvaluator> policyEvaluatorsMap;
    private boolean isContextEnrichersShared = false;
    private boolean isPreCleaned = false;

    RangerPolicyRepository(RangerPolicyRepository other, List<RangerPolicyDelta> deltas, long policyVersion) {
        this.serviceName = other.serviceName;
        this.zoneName = other.zoneName;
        this.appId = other.appId;
        this.options = other.options;
        this.pluginContext = other.pluginContext;
        this.serviceDef = other.serviceDef;
        this.policies = new ArrayList<RangerPolicy>(other.policies);
        this.policyEvaluators = new ArrayList<RangerPolicyEvaluator>(other.policyEvaluators);
        this.dataMaskPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>(other.dataMaskPolicyEvaluators);
        this.rowFilterPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>(other.rowFilterPolicyEvaluators);
        this.auditPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>(other.auditPolicyEvaluators);
        this.auditModeEnum = other.auditModeEnum;
        this.componentServiceName = other.componentServiceName;
        this.componentServiceDef = other.componentServiceDef;
        this.policyEvaluatorsMap = new HashMap<Long, RangerPolicyEvaluator>(other.policyEvaluatorsMap);
        if (other.policyResourceTrie != null) {
            this.policyResourceTrie = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>>();
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : other.policyResourceTrie.entrySet()) {
                this.policyResourceTrie.put(entry.getKey(), new RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>(entry.getValue()));
            }
        } else {
            this.policyResourceTrie = null;
        }
        if (other.dataMaskResourceTrie != null) {
            this.dataMaskResourceTrie = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>>();
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : other.dataMaskResourceTrie.entrySet()) {
                this.dataMaskResourceTrie.put(entry.getKey(), new RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>(entry.getValue()));
            }
        } else {
            this.dataMaskResourceTrie = null;
        }
        if (other.rowFilterResourceTrie != null) {
            this.rowFilterResourceTrie = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>>();
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : other.rowFilterResourceTrie.entrySet()) {
                this.rowFilterResourceTrie.put(entry.getKey(), new RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>(entry.getValue()));
            }
        } else {
            this.rowFilterResourceTrie = null;
        }
        if (other.auditFilterResourceTrie != null) {
            this.auditFilterResourceTrie = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>>();
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : other.auditFilterResourceTrie.entrySet()) {
                this.auditFilterResourceTrie.put(entry.getKey(), new RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>(entry.getValue()));
            }
        } else {
            this.auditFilterResourceTrie = null;
        }
        if (other.accessAuditCache != null) {
            int auditResultCacheSize = other.accessAuditCache.size();
            this.accessAuditCache = Collections.synchronizedMap(new CacheMap(auditResultCacheSize));
        } else {
            this.accessAuditCache = null;
        }
        boolean isExistingPolicies = CollectionUtils.isNotEmpty(this.policies);
        this.updateResourceTrie(deltas);
        this.contextEnrichers = CollectionUtils.isNotEmpty(this.policies) ? (isExistingPolicies ? this.shareWith(other) : this.buildContextEnrichers(this.options)) : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("other.serviceName=" + other.serviceName + ", other.isContextEnrichersShared=" + other.isContextEnrichersShared + ", Context-enrichers are " + (CollectionUtils.isNotEmpty(this.contextEnrichers) ? " not empty " : "empty "));
        }
        this.policyVersion = policyVersion;
    }

    public RangerPolicyRepository(ServicePolicies servicePolicies, RangerPluginContext pluginContext) {
        this(servicePolicies, pluginContext, null);
    }

    RangerPolicyRepository(ServicePolicies servicePolicies, RangerPluginContext pluginContext, String zoneName) {
        this.componentServiceName = this.serviceName = servicePolicies.getServiceName();
        this.componentServiceDef = this.serviceDef = ServiceDefUtil.normalize(servicePolicies.getServiceDef());
        this.zoneName = zoneName;
        this.appId = pluginContext.getConfig().getAppId();
        this.options = new RangerPolicyEngineOptions(pluginContext.getConfig().getPolicyEngineOptions());
        this.pluginContext = pluginContext;
        this.policies = StringUtils.isEmpty((String)zoneName) ? servicePolicies.getPolicies() : servicePolicies.getSecurityZones().get(zoneName).getPolicies();
        this.policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        String auditMode = servicePolicies.getAuditMode();
        this.auditModeEnum = StringUtils.equals((String)auditMode, (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        if (this.auditModeEnum == AuditModeEnum.AUDIT_DEFAULT) {
            String propertyName = "ranger.plugin." + this.serviceName + ".policyengine.auditcachesize";
            if (this.options.cacheAuditResults) {
                int RANGER_POLICYENGINE_AUDITRESULT_CACHE_SIZE = 65536;
                int auditResultCacheSize = pluginContext.getConfig().getInt(propertyName, 65536);
                this.accessAuditCache = Collections.synchronizedMap(new CacheMap(auditResultCacheSize));
            } else {
                this.accessAuditCache = null;
            }
        } else {
            this.accessAuditCache = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerPolicyRepository : building policy-repository for service[" + this.serviceName + "], and zone:[" + zoneName + "] with auditMode[" + (Object)((Object)this.auditModeEnum) + "]");
        }
        this.init(this.options);
        if (StringUtils.isEmpty((String)zoneName)) {
            this.contextEnrichers = this.buildContextEnrichers(this.options);
            this.auditPolicyEvaluators = this.buildAuditPolicyEvaluators(servicePolicies.getServiceConfig());
        } else {
            this.contextEnrichers = null;
            this.auditPolicyEvaluators = Collections.emptyList();
        }
        if (this.options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
            this.auditFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.auditFilterResourceTrie = this.createResourceTrieMap(this.auditPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
        }
    }

    RangerPolicyRepository(ServicePolicies.TagPolicies tagPolicies, RangerPluginContext pluginContext, RangerServiceDef componentServiceDef, String componentServiceName) {
        this.serviceName = tagPolicies.getServiceName();
        this.componentServiceName = componentServiceName;
        this.zoneName = null;
        this.serviceDef = ServiceDefUtil.normalizeAccessTypeDefs(ServiceDefUtil.normalize(tagPolicies.getServiceDef()), componentServiceDef.getName());
        this.componentServiceDef = componentServiceDef;
        this.appId = pluginContext.getConfig().getAppId();
        this.options = new RangerPolicyEngineOptions(pluginContext.getConfig().getPolicyEngineOptions());
        this.pluginContext = pluginContext;
        this.policies = this.normalizeAndPrunePolicies(tagPolicies.getPolicies(), componentServiceDef.getName());
        this.policyVersion = tagPolicies.getPolicyVersion() != null ? tagPolicies.getPolicyVersion() : -1L;
        String auditMode = tagPolicies.getAuditMode();
        this.auditModeEnum = StringUtils.equals((String)auditMode, (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        this.accessAuditCache = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerPolicyRepository : building tag-policy-repository for tag service:[" + this.serviceName + "], with auditMode[" + (Object)((Object)this.auditModeEnum) + "]");
        }
        this.init(this.options);
        if (StringUtils.isEmpty((String)this.zoneName)) {
            this.contextEnrichers = this.buildContextEnrichers(this.options);
            this.auditPolicyEvaluators = this.buildAuditPolicyEvaluators(tagPolicies.getServiceConfig());
        } else {
            this.contextEnrichers = null;
            this.auditPolicyEvaluators = Collections.emptyList();
        }
        if (this.options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
            this.auditFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
            this.auditFilterResourceTrie = this.createResourceTrieMap(this.auditPolicyEvaluators, this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace);
        }
    }

    private List<RangerPolicyEvaluator> buildAuditPolicyEvaluators(Map<String, String> svcConfigs) {
        String jsonStr;
        List<RangerPolicyEvaluator> ret = Collections.emptyList();
        String string = jsonStr = svcConfigs != null ? svcConfigs.get("ranger.plugin.audit.filters") : null;
        if (StringUtils.isNotBlank((String)jsonStr)) {
            int filterCount;
            List<AuditFilter> auditFilters = JsonUtils.jsonToAuditFilterList(jsonStr);
            int n = filterCount = auditFilters != null ? auditFilters.size() : 0;
            if (filterCount > 0) {
                ret = new ArrayList<RangerPolicyEvaluator>(filterCount);
                int policyPriority = filterCount;
                for (AuditFilter auditFilter : auditFilters) {
                    RangerAuditPolicyEvaluator evaluator = new RangerAuditPolicyEvaluator(auditFilter, policyPriority--);
                    evaluator.init(evaluator.getAuditPolicy(), this.serviceDef, this.options);
                    ret.add(evaluator);
                }
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("RangerPolicyRepository={");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("zoneName={").append(this.zoneName).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("appId={").append(this.appId).append("} ");
        sb.append("policyEvaluators={");
        if (this.policyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("dataMaskPolicyEvaluators={");
        if (this.dataMaskPolicyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.dataMaskPolicyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("rowFilterPolicyEvaluators={");
        if (this.rowFilterPolicyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.rowFilterPolicyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("auditPolicyEvaluators={");
        if (this.auditPolicyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.auditPolicyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("contextEnrichers={");
        if (this.contextEnrichers != null) {
            for (RangerContextEnricher contextEnricher : this.contextEnrichers) {
                if (contextEnricher == null) continue;
                sb.append(contextEnricher).append(" ");
            }
        }
        sb.append("} ");
        sb.append("} ");
        return sb;
    }

    List<RangerContextEnricher> shareWith(RangerPolicyRepository other) {
        if (other != null && other.contextEnrichers != null) {
            other.setShared();
        }
        return other == null ? null : other.contextEnrichers;
    }

    void setShared() {
        this.isContextEnrichersShared = true;
    }

    void preCleanup(boolean isForced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> preCleanup(isForced=" + isForced + " )");
            LOG.debug("Repository holds [" + (CollectionUtils.isEmpty(this.contextEnrichers) ? 0 : this.contextEnrichers.size()) + "] enrichers. isPreCleaned=" + this.isPreCleaned);
        }
        if (!this.isPreCleaned) {
            if (CollectionUtils.isNotEmpty(this.contextEnrichers) && (!this.isContextEnrichersShared || isForced)) {
                this.isPreCleaned = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("preCleaning context-enrichers");
                }
                for (RangerContextEnricher enricher : this.contextEnrichers) {
                    enricher.preCleanup();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No preCleaning of context-enrichers; Context-enrichers are " + (CollectionUtils.isNotEmpty(this.contextEnrichers) ? " not empty " : "empty ") + ", isContextEnrichersShared=" + this.isContextEnrichersShared + ", isForced=" + isForced + ")");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("preCleanup() already done. No need to do it again");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== preCleanup(isForced=" + isForced + " )");
        }
    }

    void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> cleanup()");
        }
        this.preCleanup(false);
        if (CollectionUtils.isNotEmpty(this.contextEnrichers) && !this.isContextEnrichersShared) {
            for (RangerContextEnricher enricher : this.contextEnrichers) {
                enricher.cleanup();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== cleanup()");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> reorderEvaluators()");
        }
        if (this.policyResourceTrie == null) {
            this.policyEvaluators = this.getReorderedPolicyEvaluators(this.policyEvaluators);
        }
        if (this.dataMaskResourceTrie == null) {
            this.dataMaskPolicyEvaluators = this.getReorderedPolicyEvaluators(this.dataMaskPolicyEvaluators);
        }
        if (this.rowFilterResourceTrie == null) {
            this.rowFilterPolicyEvaluators = this.getReorderedPolicyEvaluators(this.rowFilterPolicyEvaluators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== reorderEvaluators()");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    String getZoneName() {
        return this.zoneName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    List<RangerPolicy> getPolicies() {
        return this.policies;
    }

    long getPolicyVersion() {
        return this.policyVersion;
    }

    AuditModeEnum getAuditModeEnum() {
        return this.auditModeEnum;
    }

    boolean setAuditEnabledFromCache(RangerAccessRequest request, RangerAccessResult result) {
        AuditInfo auditInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.setAuditEnabledFromCache()");
        }
        AuditInfo auditInfo2 = auditInfo = this.accessAuditCache != null ? this.accessAuditCache.get(request.getResource().getAsString()) : null;
        if (auditInfo != null) {
            result.setIsAudited(auditInfo.getIsAudited());
            result.setAuditPolicyId(auditInfo.getAuditPolicyId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.setAuditEnabledFromCache():" + (auditInfo != null));
        }
        return auditInfo != null;
    }

    void storeAuditEnabledInCache(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.storeAuditEnabledInCache()");
        }
        if (this.accessAuditCache != null && result.getIsAuditedDetermined()) {
            this.accessAuditCache.put(request.getResource().getAsString(), new AuditInfo(result.getIsAudited(), result.getAuditPolicyId()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.storeAuditEnabledInCache()");
        }
    }

    List<RangerContextEnricher> getContextEnrichers() {
        return this.contextEnrichers;
    }

    List<RangerPolicyEvaluator> getPolicyEvaluators(int policyType) {
        switch (policyType) {
            case 0: {
                return this.getPolicyEvaluators();
            }
            case 1: {
                return this.getDataMaskPolicyEvaluators();
            }
            case 2: {
                return this.getRowFilterPolicyEvaluators();
            }
        }
        return this.getPolicyEvaluators();
    }

    public List<RangerPolicyEvaluator> getPolicyEvaluators() {
        return this.policyEvaluators;
    }

    List<RangerPolicyEvaluator> getDataMaskPolicyEvaluators() {
        return this.dataMaskPolicyEvaluators;
    }

    List<RangerPolicyEvaluator> getRowFilterPolicyEvaluators() {
        return this.rowFilterPolicyEvaluators;
    }

    List<RangerPolicyEvaluator> getAuditPolicyEvaluators() {
        return this.auditPolicyEvaluators;
    }

    String getAppId() {
        return this.appId;
    }

    RangerPolicyEngineOptions getOptions() {
        return this.options;
    }

    List<PolicyEvaluatorForTag> getLikelyMatchPolicyEvaluators(RangerAccessRequest request, Set<RangerTagForEval> tags, int policyType, Date accessTime) {
        ArrayList<PolicyEvaluatorForTag> ret = Collections.EMPTY_LIST;
        if (CollectionUtils.isNotEmpty(tags) && this.getServiceDef() != null) {
            ret = new ArrayList<PolicyEvaluatorForTag>();
            for (RangerTagForEval tag : tags) {
                if (tag.isApplicable(accessTime)) {
                    RangerTagAccessRequest tagRequest = new RangerTagAccessRequest(tag, this.getServiceDef(), request);
                    List<RangerPolicyEvaluator> evaluators = this.getLikelyMatchPolicyEvaluators(tagRequest, policyType);
                    if (!CollectionUtils.isNotEmpty(evaluators)) continue;
                    for (RangerPolicyEvaluator evaluator : evaluators) {
                        if (!evaluator.isApplicable(accessTime)) continue;
                        ret.add(new PolicyEvaluatorForTag(evaluator, tag));
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Tag:[" + tag.getType() + "] is not applicable at accessTime:[" + accessTime + "]");
            }
            if (CollectionUtils.isNotEmpty(ret)) {
                switch (policyType) {
                    case 0: 
                    case 3: {
                        Collections.sort(ret, PolicyEvaluatorForTag.EVAL_ORDER_COMPARATOR);
                        break;
                    }
                    case 1: {
                        Collections.sort(ret, PolicyEvaluatorForTag.NAME_COMPARATOR);
                        break;
                    }
                    case 2: {
                        Collections.sort(ret, PolicyEvaluatorForTag.NAME_COMPARATOR);
                        break;
                    }
                    default: {
                        LOG.warn("Unknown policy-type:[" + policyType + "]. Ignoring..");
                    }
                }
            }
        }
        return ret;
    }

    public List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(RangerAccessRequest request) {
        ArrayList<RangerPolicyEvaluator> ret = new ArrayList<RangerPolicyEvaluator>();
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            List<RangerPolicyEvaluator> evaluators = this.getLikelyMatchPolicyEvaluators(request, policyType);
            if (!CollectionUtils.isNotEmpty(evaluators)) continue;
            ret.addAll(evaluators);
        }
        return ret;
    }

    public List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(RangerAccessRequest request, int policyType) {
        switch (policyType) {
            case 0: {
                return this.getLikelyMatchAccessPolicyEvaluators(request);
            }
            case 1: {
                return this.getLikelyMatchDataMaskPolicyEvaluators(request);
            }
            case 2: {
                return this.getLikelyMatchRowFilterPolicyEvaluators(request);
            }
            case 3: {
                return this.getLikelyMatchAuditPolicyEvaluators(request);
            }
        }
        return Collections.EMPTY_LIST;
    }

    Map<Long, RangerPolicyEvaluator> getPolicyEvaluatorsMap() {
        return this.policyEvaluatorsMap;
    }

    RangerPolicyEvaluator getPolicyEvaluator(Long id) {
        return this.policyEvaluatorsMap.get(id);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchAccessPolicyEvaluators(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.policyResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.policyResourceTrie, request);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchDataMaskPolicyEvaluators(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.dataMaskResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getDataMaskPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.dataMaskResourceTrie, request);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchRowFilterPolicyEvaluators(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.rowFilterResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getRowFilterPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.rowFilterResourceTrie, request);
    }

    List<RangerPolicyEvaluator> getLikelyMatchAuditPolicyEvaluators(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.auditFilterResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getAuditPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.auditFilterResourceTrie, request);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> resourceTrie, RangerAccessRequest request) {
        Collection<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> smallestList;
        ArrayList<RangerPolicyEvaluator> ret = Collections.EMPTY_LIST;
        RangerAccessResource resource = request.getResource();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerPolicyRepository.getLikelyMatchEvaluators(resource=" + resource.getAsString() + ")");
        }
        if ((smallestList = RangerResourceEvaluatorsRetriever.getEvaluators(resourceTrie, resource.getAsMap(), request.getResourceMatchingScope())) != null) {
            if (smallestList.size() == 0) {
                ret = new ArrayList<RangerPolicyEvaluator>();
            } else if (smallestList.size() == 1) {
                ret = new ArrayList(1);
                for (RangerPolicyEvaluator.RangerPolicyResourceEvaluator resourceEvaluator : smallestList) {
                    RangerPolicyEvaluator policyEvaluator = resourceEvaluator.getPolicyEvaluator();
                    ret.add(policyEvaluator);
                }
            } else {
                ret = new ArrayList(smallestList.size());
                HashSet<Long> policyIds = new HashSet<Long>();
                for (RangerPolicyEvaluator.RangerPolicyResourceEvaluator resourceEvaluator : smallestList) {
                    RangerPolicyEvaluator policyEvaluator = resourceEvaluator.getPolicyEvaluator();
                    if (!policyIds.add(policyEvaluator.getPolicyId())) continue;
                    ret.add(policyEvaluator);
                }
                ret.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.getLikelyMatchPolicyEvaluators(" + resource.getAsString() + "): evaluatorCount=" + ret.size());
        }
        return ret;
    }

    private List<RangerPolicy> normalizeAndPrunePolicies(List<RangerPolicy> rangerPolicies, String componentType) {
        if (CollectionUtils.isNotEmpty(rangerPolicies) && StringUtils.isNotBlank((String)componentType)) {
            ArrayList<RangerPolicy> policiesToPrune = null;
            for (RangerPolicy policy : rangerPolicies) {
                if (!this.isPolicyNeedsPruning(policy, componentType)) continue;
                if (policiesToPrune == null) {
                    policiesToPrune = new ArrayList<RangerPolicy>();
                }
                policiesToPrune.add(policy);
            }
            if (policiesToPrune != null) {
                rangerPolicies.removeAll(policiesToPrune);
            }
        }
        return rangerPolicies == null ? new ArrayList() : rangerPolicies;
    }

    private boolean isPolicyNeedsPruning(RangerPolicy policy, String componentType) {
        this.normalizeAndPrunePolicyItems(policy.getPolicyItems(), componentType);
        this.normalizeAndPrunePolicyItems(policy.getDenyPolicyItems(), componentType);
        this.normalizeAndPrunePolicyItems(policy.getAllowExceptions(), componentType);
        this.normalizeAndPrunePolicyItems(policy.getDenyExceptions(), componentType);
        this.normalizeAndPrunePolicyItems(policy.getDataMaskPolicyItems(), componentType);
        this.normalizeAndPrunePolicyItems(policy.getRowFilterPolicyItems(), componentType);
        return policy.getIsAuditEnabled() == false && CollectionUtils.isEmpty(policy.getPolicyItems()) && CollectionUtils.isEmpty(policy.getDenyPolicyItems()) && CollectionUtils.isEmpty(policy.getAllowExceptions()) && CollectionUtils.isEmpty(policy.getDenyExceptions()) && CollectionUtils.isEmpty(policy.getDataMaskPolicyItems()) && CollectionUtils.isEmpty(policy.getRowFilterPolicyItems());
    }

    private List<? extends RangerPolicy.RangerPolicyItem> normalizeAndPrunePolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems, String componentType) {
        if (CollectionUtils.isNotEmpty(policyItems)) {
            String prefix = componentType + ":";
            ArrayList<RangerPolicy.RangerPolicyItem> itemsToPrune = null;
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = rangerPolicyItem.getAccesses();
                if (CollectionUtils.isNotEmpty(policyItemAccesses)) {
                    ArrayList<RangerPolicy.RangerPolicyItemAccess> accessesToPrune = null;
                    for (RangerPolicy.RangerPolicyItemAccess access : policyItemAccesses) {
                        String accessType = access.getType();
                        if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                            String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                            access.setType(newAccessType);
                            continue;
                        }
                        if (!accessType.contains(":")) continue;
                        if (accessesToPrune == null) {
                            accessesToPrune = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
                        }
                        accessesToPrune.add(access);
                    }
                    if (accessesToPrune != null) {
                        policyItemAccesses.removeAll(accessesToPrune);
                    }
                    if (policyItemAccesses.isEmpty() && !rangerPolicyItem.getDelegateAdmin().booleanValue()) {
                        if (itemsToPrune == null) {
                            itemsToPrune = new ArrayList<RangerPolicy.RangerPolicyItem>();
                        }
                        itemsToPrune.add(rangerPolicyItem);
                        continue;
                    }
                }
                if (!(rangerPolicyItem instanceof RangerPolicy.RangerDataMaskPolicyItem)) continue;
                RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo = ((RangerPolicy.RangerDataMaskPolicyItem)rangerPolicyItem).getDataMaskInfo();
                String maskType = dataMaskInfo.getDataMaskType();
                if (StringUtils.startsWith((String)maskType, (String)prefix)) {
                    dataMaskInfo.setDataMaskType(StringUtils.removeStart((String)maskType, (String)prefix));
                    continue;
                }
                if (!maskType.contains(":")) continue;
                if (itemsToPrune == null) {
                    itemsToPrune = new ArrayList();
                }
                itemsToPrune.add(rangerPolicyItem);
            }
            if (itemsToPrune != null) {
                policyItems.removeAll(itemsToPrune);
            }
        }
        return policyItems;
    }

    private static boolean isDelegateAdminPolicy(RangerPolicy policy) {
        boolean ret = RangerPolicyRepository.hasDelegateAdminItems(policy.getPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getAllowExceptions()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyExceptions());
        return ret;
    }

    private static boolean hasDelegateAdminItems(List<RangerPolicy.RangerPolicyItem> items) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(items)) {
            for (RangerPolicy.RangerPolicyItem item : items) {
                if (!item.getDelegateAdmin().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean skipBuildingPolicyEvaluator(RangerPolicy policy, RangerPolicyEngineOptions options) {
        boolean ret = false;
        if (!policy.getIsEnabled().booleanValue()) {
            ret = true;
        } else if (options.evaluateDelegateAdminOnly && !RangerPolicyRepository.isDelegateAdminPolicy(policy)) {
            ret = true;
        }
        return ret;
    }

    private void init(RangerPolicyEngineOptions options) {
        RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
        options.setServiceDefHelper(serviceDefHelper);
        ArrayList<RangerPolicyEvaluator> policyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> dataMaskPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> rowFilterPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        for (RangerPolicy policy : this.policies) {
            RangerPolicyEvaluator evaluator;
            if (RangerPolicyRepository.skipBuildingPolicyEvaluator(policy, options) || (evaluator = this.buildPolicyEvaluator(policy, this.serviceDef, options)) == null) continue;
            if (policy.getPolicyType() == null || policy.getPolicyType() == 0) {
                policyEvaluators.add(evaluator);
                continue;
            }
            if (policy.getPolicyType() == 1) {
                dataMaskPolicyEvaluators.add(evaluator);
                continue;
            }
            if (policy.getPolicyType() == 2) {
                rowFilterPolicyEvaluators.add(evaluator);
                continue;
            }
            LOG.warn("RangerPolicyEngine: ignoring policy id=" + policy.getId() + " - invalid policyType '" + policy.getPolicyType() + "'");
        }
        LOG.info("This policy engine contains " + (policyEvaluators.size() + dataMaskPolicyEvaluators.size() + rowFilterPolicyEvaluators.size()) + " policy evaluators");
        RangerPolicyEvaluator.PolicyEvalOrderComparator comparator = new RangerPolicyEvaluator.PolicyEvalOrderComparator();
        Collections.sort(policyEvaluators, comparator);
        this.policyEvaluators = policyEvaluators;
        Collections.sort(dataMaskPolicyEvaluators, comparator);
        this.dataMaskPolicyEvaluators = dataMaskPolicyEvaluators;
        Collections.sort(rowFilterPolicyEvaluators, comparator);
        this.rowFilterPolicyEvaluators = rowFilterPolicyEvaluators;
        this.policyEvaluatorsMap = this.createPolicyEvaluatorsMap();
        if (LOG.isDebugEnabled()) {
            RangerPolicy policy;
            LOG.debug("policy evaluation order: " + this.policyEvaluators.size() + " policies");
            int order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug("policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder());
            }
            LOG.debug("dataMask policy evaluation order: " + this.dataMaskPolicyEvaluators.size() + " policies");
            order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.dataMaskPolicyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug("dataMask policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder());
            }
            LOG.debug("rowFilter policy evaluation order: " + this.rowFilterPolicyEvaluators.size() + " policies");
            order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.rowFilterPolicyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug("rowFilter policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder());
            }
            LOG.debug("audit policy evaluation order: " + (this.auditPolicyEvaluators != null ? Integer.valueOf(this.auditPolicyEvaluators.size()) : "0 policies"));
            if (this.auditPolicyEvaluators != null) {
                order = 0;
                for (RangerPolicyEvaluator policyEvaluator : this.auditPolicyEvaluators) {
                    policy = policyEvaluator.getPolicy();
                    LOG.debug("audit policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder());
                }
            }
        }
    }

    private List<RangerContextEnricher> buildContextEnrichers(RangerPolicyEngineOptions options) {
        ArrayList<RangerContextEnricher> contextEnrichers = new ArrayList<RangerContextEnricher>();
        if (StringUtils.isEmpty((String)this.zoneName) && CollectionUtils.isNotEmpty(this.serviceDef.getContextEnrichers())) {
            for (RangerServiceDef.RangerContextEnricherDef enricherDef : this.serviceDef.getContextEnrichers()) {
                RangerContextEnricher contextEnricher;
                HashMap<String, String> enricherOptions;
                if (enricherDef == null) continue;
                if (options.disableTagRetriever && StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerTagEnricher.class.getName()) && MapUtils.isNotEmpty(enricherDef.getEnricherOptions())) {
                    enricherOptions = new HashMap<String, String>(enricherDef.getEnricherOptions());
                    enricherOptions.remove("tagRetrieverClassName");
                    enricherDef = new RangerServiceDef.RangerContextEnricherDef(enricherDef.getItemId(), enricherDef.getName(), enricherDef.getEnricher(), enricherOptions);
                }
                if (options.disableUserStoreRetriever && StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerUserStoreEnricher.class.getName()) && MapUtils.isNotEmpty(enricherDef.getEnricherOptions())) {
                    enricherOptions = new HashMap<String, String>(enricherDef.getEnricherOptions());
                    enricherOptions.remove("userStoreRetrieverClassName");
                    enricherDef = new RangerServiceDef.RangerContextEnricherDef(enricherDef.getItemId(), enricherDef.getName(), enricherDef.getEnricher(), enricherOptions);
                }
                if (options.disableContextEnrichers) continue;
                RangerServiceDef.RangerContextEnricherDef contextEnricherDef = enricherDef;
                if (options.enableTagEnricherWithLocalRefresher && StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerTagEnricher.class.getName())) {
                    contextEnricherDef = new RangerServiceDef.RangerContextEnricherDef(enricherDef.getItemId(), enricherDef.getName(), "org.apache.ranger.common.RangerAdminTagEnricher", null);
                } else if (options.enableUserStoreEnricherWithLocalRefresher && StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerUserStoreEnricher.class.getName())) {
                    contextEnricherDef = new RangerServiceDef.RangerContextEnricherDef(enricherDef.getItemId(), enricherDef.getName(), "org.apache.ranger.common.RangerAdminUserStoreEnricher", null);
                }
                if ((contextEnricher = this.buildContextEnricher(contextEnricherDef, options)) == null) continue;
                contextEnrichers.add(contextEnricher);
            }
        }
        return contextEnrichers;
    }

    private RangerContextEnricher buildContextEnricher(RangerServiceDef.RangerContextEnricherDef enricherDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.buildContextEnricher(" + enricherDef + ")");
        }
        RangerContextEnricher ret = null;
        Map<String, String> enricherDefOptions = enricherDef.getEnricherOptions();
        String isEnabledAsString = enricherDefOptions.get("IsEnabled");
        if (!StringUtils.equalsIgnoreCase((String)isEnabledAsString, (String)"false")) {
            String clsName;
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerContextEnricher.init(appId=" + this.appId + ",name=" + enricherDef.getName() + ")");
            }
            String name = enricherDef != null ? enricherDef.getName() : null;
            String string = clsName = enricherDef != null ? enricherDef.getEnricher() : null;
            if (!StringUtils.isEmpty((String)clsName)) {
                try {
                    Class<?> enricherClass = Class.forName(clsName);
                    ret = (RangerContextEnricher)enricherClass.newInstance();
                }
                catch (Exception excp) {
                    LOG.error("failed to instantiate context enricher '" + clsName + "' for '" + name + "'", (Throwable)excp);
                }
            }
            if (ret != null) {
                ret.setEnricherDef(enricherDef);
                ret.setServiceName(this.componentServiceName);
                ret.setServiceDef(this.componentServiceDef);
                ret.setAppId(this.appId);
                if (ret instanceof RangerAbstractContextEnricher) {
                    RangerAbstractContextEnricher abstractContextEnricher = (RangerAbstractContextEnricher)ret;
                    abstractContextEnricher.setPluginContext(this.pluginContext);
                    abstractContextEnricher.setPolicyEngineOptions(options);
                }
                ret.init();
            }
            RangerPerfTracer.log(perf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.buildContextEnricher(" + enricherDef + "): " + ret);
        }
        return ret;
    }

    private RangerPolicyEvaluator buildPolicyEvaluator(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + ", " + options + ")");
        }
        this.scrubPolicy(policy);
        RangerOptimizedPolicyEvaluator ret = StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"cached") ? new RangerCachedPolicyEvaluator() : new RangerOptimizedPolicyEvaluator();
        ret.setPluginContext(this.pluginContext);
        ((RangerAbstractPolicyEvaluator)ret).init(policy, serviceDef, options);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + "): " + ret);
        }
        return ret;
    }

    private boolean scrubPolicy(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.scrubPolicy(" + policy + ")");
        }
        boolean altered = false;
        Long policyId = policy.getId();
        Map<String, RangerPolicy.RangerPolicyResource> resourceMap = policy.getResources();
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resourceMap.entrySet()) {
            String resourceName = entry.getKey();
            RangerPolicy.RangerPolicyResource resource = entry.getValue();
            Iterator<String> iterator = resource.getValues().iterator();
            while (iterator.hasNext()) {
                String value = iterator.next();
                if (value != null) continue;
                LOG.warn("RangerPolicyRepository.scrubPolicyResource: found null resource value for " + resourceName + " in policy " + policyId + "!  Removing...");
                iterator.remove();
                altered = true;
            }
        }
        this.scrubPolicyItems(policyId, policy.getPolicyItems());
        this.scrubPolicyItems(policyId, policy.getAllowExceptions());
        this.scrubPolicyItems(policyId, policy.getDenyPolicyItems());
        this.scrubPolicyItems(policyId, policy.getDenyExceptions());
        this.scrubPolicyItems(policyId, policy.getRowFilterPolicyItems());
        this.scrubPolicyItems(policyId, policy.getDataMaskPolicyItems());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.scrubPolicy(" + policy + "): " + altered);
        }
        return altered;
    }

    private void scrubPolicyItems(Long policyId, List<? extends RangerPolicy.RangerPolicyItem> policyItems) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.scrubPolicyItems(" + policyId + "): ");
        }
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
            this.removeNulls(rangerPolicyItem.getUsers(), policyId, rangerPolicyItem);
            this.removeNulls(rangerPolicyItem.getGroups(), policyId, rangerPolicyItem);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.scrubPolicyItems(" + policyId + "): ");
        }
    }

    private void removeNulls(Collection<String> strings, Long policyId, RangerPolicy.RangerPolicyItem policyItem) {
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (value != null) continue;
            LOG.warn("RangerPolicyRepository.removeNulls: found null user/group in policyItem '" + policyItem + "' in policy " + policyId + "!  Removing...");
            iterator.remove();
        }
    }

    private List<RangerPolicyEvaluator> getReorderedPolicyEvaluators(List<RangerPolicyEvaluator> evaluators) {
        List<RangerPolicyEvaluator> ret = evaluators;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            ret = new ArrayList<RangerPolicyEvaluator>(evaluators);
            Collections.sort(ret, new RangerPolicyEvaluator.PolicyEvalOrderComparator());
        }
        return ret;
    }

    private Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> createResourceTrieMap(List<? extends RangerPolicyEvaluator> evaluators, boolean optimizeTrieForRetrieval, boolean optimizeTrieForSpace) {
        HashMap ret;
        if (this.serviceDef != null && CollectionUtils.isNotEmpty(this.serviceDef.getResources())) {
            ret = new HashMap();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                ret.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, evaluators, optimizeTrieForRetrieval, optimizeTrieForSpace, this.pluginContext));
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private void updateTrie(Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> trieMap, Integer policyDeltaType, RangerPolicyEvaluator oldEvaluator, RangerPolicyEvaluator newEvaluator) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.updateTrie(policyDeltaType=" + policyDeltaType + "): ");
        }
        for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
            String resourceDefName = resourceDef.getName();
            RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> trie = trieMap.get(resourceDefName);
            if (trie == null) {
                if (2 == policyDeltaType || 1 == policyDeltaType) {
                    LOG.warn("policyDeltaType is not for POLICY_CREATE and trie for resourceDef:[" + resourceDefName + "] was null! Should not have happened!!");
                }
                trie = new RangerResourceTrie(resourceDef, new ArrayList(), this.options.optimizeTrieForRetrieval, this.options.optimizeTrieForSpace, this.pluginContext);
                trieMap.put(resourceDefName, trie);
            }
            if (policyDeltaType == 0) {
                this.removeEvaluatorFromTrie(oldEvaluator, trie, resourceDefName);
                this.addEvaluatorToTrie(newEvaluator, trie, resourceDefName);
                continue;
            }
            if (policyDeltaType == 2) {
                this.removeEvaluatorFromTrie(oldEvaluator, trie, resourceDefName);
                continue;
            }
            if (policyDeltaType == 1) {
                this.removeEvaluatorFromTrie(oldEvaluator, trie, resourceDefName);
                this.addEvaluatorToTrie(newEvaluator, trie, resourceDefName);
                continue;
            }
            LOG.error("policyDeltaType:" + policyDeltaType + " is currently not handled, policy-id:[" + oldEvaluator.getPolicy().getId() + "]");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.updateTrie(policyDeltaType=" + policyDeltaType + "): ");
        }
    }

    private void addEvaluatorToTrie(RangerPolicyEvaluator newEvaluator, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> trie, String resourceDefName) {
        if (newEvaluator != null) {
            for (RangerPolicyEvaluator.RangerPolicyResourceEvaluator resourceEvaluator : newEvaluator.getResourceEvaluators()) {
                RangerPolicy.RangerPolicyResource resource = resourceEvaluator.getPolicyResource().get(resourceDefName);
                trie.add(resource, resourceEvaluator);
            }
        } else {
            LOG.warn("Unexpected: newPolicyEvaluator is null for resource:[" + resourceDefName + "]");
        }
    }

    private void removeEvaluatorFromTrie(RangerPolicyEvaluator oldEvaluator, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> trie, String resourceDefName) {
        if (oldEvaluator != null) {
            for (RangerPolicyEvaluator.RangerPolicyResourceEvaluator resourceEvaluator : oldEvaluator.getResourceEvaluators()) {
                trie.delete(resourceEvaluator.getPolicyResource().get(resourceDefName), resourceEvaluator);
            }
        }
    }

    private Map<Long, RangerPolicyEvaluator> createPolicyEvaluatorsMap() {
        HashMap<Long, RangerPolicyEvaluator> tmpPolicyEvaluatorMap = new HashMap<Long, RangerPolicyEvaluator>();
        for (RangerPolicyEvaluator evaluator : this.getPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.getDataMaskPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.getRowFilterPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        return tmpPolicyEvaluatorMap;
    }

    private RangerPolicyEvaluator addPolicy(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.addPolicy(" + policy + ")");
        }
        RangerPolicyEvaluator ret = null;
        if (StringUtils.equals((String)this.serviceDef.getName(), (String)this.componentServiceDef.getName()) || !this.isPolicyNeedsPruning(policy, this.componentServiceDef.getName())) {
            this.policies.add(policy);
            if (!RangerPolicyRepository.skipBuildingPolicyEvaluator(policy, this.options) && (ret = this.buildPolicyEvaluator(policy, this.serviceDef, this.options)) != null) {
                if (policy.getPolicyType() == null || policy.getPolicyType() == 0) {
                    this.policyEvaluators.add(ret);
                } else if (policy.getPolicyType() == 1) {
                    this.dataMaskPolicyEvaluators.add(ret);
                } else if (policy.getPolicyType() == 2) {
                    this.rowFilterPolicyEvaluators.add(ret);
                } else {
                    LOG.warn("RangerPolicyEngine: ignoring policy id=" + policy.getId() + " - invalid policyType '" + policy.getPolicyType() + "'");
                }
                if (policy.getPolicyType() != 3) {
                    this.policyEvaluatorsMap.put(policy.getId(), ret);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.addPolicy(" + policy + "): " + ret);
        }
        return ret;
    }

    private void removePolicy(Long id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.removePolicy(" + id + ")");
        }
        Iterator<RangerPolicy> iterator = this.policies.iterator();
        while (iterator.hasNext()) {
            if (!id.equals(iterator.next().getId())) continue;
            iterator.remove();
        }
        this.policyEvaluatorsMap.remove(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.removePolicy(" + id + ")");
        }
    }

    private void deletePolicyEvaluator(RangerPolicyEvaluator evaluator) {
        Integer policyType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.deletePolicyEvaluator(" + evaluator.getPolicy() + ")");
        }
        if ((policyType = evaluator.getPolicy().getPolicyType()) == null) {
            policyType = 0;
        }
        List<RangerPolicyEvaluator> evaluators = null;
        if (policyType == 0) {
            evaluators = this.policyEvaluators;
        } else if (policyType == 1) {
            evaluators = this.dataMaskPolicyEvaluators;
        } else if (policyType == 2) {
            evaluators = this.rowFilterPolicyEvaluators;
        } else {
            LOG.error("Unknown policyType:[" + policyType + "]");
        }
        if (evaluators != null) {
            evaluators.remove(evaluator);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.deletePolicyEvaluator(" + evaluator.getPolicy() + ")");
        }
    }

    private RangerPolicyEvaluator update(RangerPolicyDelta delta, RangerPolicyEvaluator currentEvaluator) {
        RangerPolicyEvaluator ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPolicyRepository.update(delta=" + delta + ", currentEvaluator=" + (currentEvaluator == null ? null : currentEvaluator.getPolicy()) + ")");
        }
        Integer changeType = delta.getChangeType();
        Integer policyType = delta.getPolicyType();
        Long policyId = delta.getPolicyId();
        RangerPolicy policy = delta.getPolicy();
        RangerPolicyEvaluator newEvaluator = null;
        switch (changeType) {
            case 0: {
                if (currentEvaluator != null) {
                    this.removePolicy(policyId);
                }
                if (policy == null) break;
                newEvaluator = this.addPolicy(policy);
                break;
            }
            case 1: {
                if (currentEvaluator != null) {
                    this.removePolicy(policyId);
                }
                if (policy == null) break;
                newEvaluator = this.addPolicy(policy);
                break;
            }
            case 2: {
                if (currentEvaluator == null) break;
                this.removePolicy(policyId);
            }
        }
        Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> trieMap = this.getTrie(policyType);
        if (trieMap != null) {
            this.updateTrie(trieMap, changeType, currentEvaluator, newEvaluator);
        }
        if ((changeType == 1 || changeType == 2) && currentEvaluator != null) {
            this.deletePolicyEvaluator(currentEvaluator);
        }
        RangerPolicyEvaluator rangerPolicyEvaluator = ret = changeType == 2 ? currentEvaluator : newEvaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPolicyRepository.update(delta=" + delta + ", currentEvaluator=" + (currentEvaluator == null ? null : currentEvaluator.getPolicy()) + ")");
        }
        return ret;
    }

    Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> getTrie(int policyType) {
        Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> ret;
        switch (policyType) {
            case 0: {
                ret = this.policyResourceTrie;
                break;
            }
            case 1: {
                ret = this.dataMaskResourceTrie;
                break;
            }
            case 2: {
                ret = this.rowFilterResourceTrie;
                break;
            }
            case 3: {
                ret = this.auditFilterResourceTrie;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    void reinit(List<RangerPolicyDelta> deltas) {
        boolean isExistingPolicies = CollectionUtils.isNotEmpty(this.policies);
        this.updateResourceTrie(deltas);
        if (StringUtils.isEmpty((String)this.zoneName) && CollectionUtils.isNotEmpty(this.policies)) {
            if (!isExistingPolicies) {
                this.contextEnrichers = this.buildContextEnrichers(this.options);
            }
        } else {
            this.contextEnrichers = null;
        }
    }

    private void updateResourceTrie(List<RangerPolicyDelta> deltas) {
        boolean[] flags = new boolean[RangerPolicy.POLICY_TYPES.length];
        block10: for (RangerPolicyDelta delta : deltas) {
            Integer changeType = delta.getChangeType();
            String serviceType = delta.getServiceType();
            Long policyId = delta.getPolicyId();
            Integer policyType = delta.getPolicyType();
            if (!serviceType.equals(this.serviceDef.getName())) continue;
            RangerPolicyEvaluator evaluator = null;
            switch (changeType) {
                case 0: {
                    if (delta.getPolicy() == null) {
                        LOG.warn("Could not find policy for policy-id:[" + policyId + "]");
                        continue block10;
                    }
                    evaluator = this.getPolicyEvaluator(policyId);
                    if (evaluator == null) break;
                    LOG.warn("Unexpected: Found evaluator for policy-id:[" + policyId + "], changeType=CHANGE_TYPE_POLICY_CREATE");
                    break;
                }
                case 1: {
                    evaluator = this.getPolicyEvaluator(policyId);
                    if (evaluator != null) break;
                    LOG.warn("Unexpected:  Did not find evaluator for policy-id:[" + policyId + "], changeType=CHANGE_TYPE_POLICY_UPDATE");
                    break;
                }
                case 2: {
                    evaluator = this.getPolicyEvaluator(policyId);
                    if (evaluator != null) break;
                    LOG.warn("Unexpected:  Did not find evaluator for policy-id:[" + policyId + "], changeType=CHANGE_TYPE_POLICY_DELETE");
                    break;
                }
                default: {
                    LOG.error("Unknown changeType:[" + changeType + "], Ignoring");
                }
            }
            if ((evaluator = this.update(delta, evaluator)) == null) continue;
            switch (changeType) {
                case 0: {
                    this.policyEvaluatorsMap.put(policyId, evaluator);
                    break;
                }
                case 1: {
                    this.policyEvaluatorsMap.put(policyId, evaluator);
                    break;
                }
                case 2: {
                    this.policyEvaluatorsMap.remove(policyId);
                    break;
                }
            }
            flags[policyType.intValue()] = true;
        }
        for (int policyType = 0; policyType < flags.length; ++policyType) {
            Map<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> trie;
            if (!flags[policyType] || (trie = this.getTrie(policyType)) == null) continue;
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : trie.entrySet()) {
                entry.getValue().wrapUpUpdate();
            }
        }
        if (this.auditFilterResourceTrie != null) {
            for (Map.Entry<String, RangerResourceTrie<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>> entry : this.auditFilterResourceTrie.entrySet()) {
                entry.getValue().wrapUpUpdate();
            }
        }
    }

    private static final class AuditInfo {
        final boolean isAudited;
        final long auditPolicyId;

        AuditInfo(boolean isAudited, long auditPolicyId) {
            this.isAudited = isAudited;
            this.auditPolicyId = auditPolicyId;
        }

        long getAuditPolicyId() {
            return this.auditPolicyId;
        }

        boolean getIsAudited() {
            return this.isAudited;
        }
    }

    static enum AuditModeEnum {
        AUDIT_ALL,
        AUDIT_NONE,
        AUDIT_DEFAULT;

    }
}

