/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.util.ConfigurationHelper;
import org.apache.hadoop.util.Preconditions;

public final class FlagSet<E extends Enum<E>>
implements StreamCapabilities {
    private final Class<E> enumClass;
    private final String prefix;
    private final EnumSet<E> flags;
    private final AtomicBoolean immutable = new AtomicBoolean(false);
    private final Map<String, E> namesToValues;

    private FlagSet(Class<E> enumClass, String prefix, @Nullable EnumSet<E> flags) {
        this.enumClass = Objects.requireNonNull(enumClass, "null enumClass");
        this.prefix = Objects.requireNonNull(prefix, "null prefix");
        this.flags = flags != null ? EnumSet.copyOf(flags) : EnumSet.noneOf(enumClass);
        this.namesToValues = ConfigurationHelper.mapEnumNamesToValues(prefix, enumClass);
    }

    public EnumSet<E> flags() {
        return EnumSet.copyOf(this.flags);
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    public boolean enabled(E flag) {
        return this.flags.contains(flag);
    }

    private void checkMutable() {
        Preconditions.checkState(!this.immutable.get(), "FlagSet is immutable");
    }

    public void enable(E flag) {
        this.checkMutable();
        this.flags.add(flag);
    }

    public void disable(E flag) {
        this.checkMutable();
        this.flags.remove(flag);
    }

    public void set(E flag, boolean state) {
        if (state) {
            this.enable(flag);
        } else {
            this.disable(flag);
        }
    }

    @Override
    public boolean hasCapability(String capability) {
        Enum e = (Enum)this.namesToValues.get(capability);
        return e != null && this.enabled(e);
    }

    public void makeImmutable() {
        this.immutable.set(true);
    }

    public boolean isImmutable() {
        return this.immutable.get();
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    public String toString() {
        return "{" + this.flags.stream().map(Enum::name).collect(Collectors.joining(", ")) + "}";
    }

    public List<String> pathCapabilities() {
        return this.namesToValues.keySet().stream().filter(this::hasCapability).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagSet flagSet = (FlagSet)o;
        return Objects.equals(this.enumClass, flagSet.enumClass) && Objects.equals(this.prefix, flagSet.prefix) && Objects.equals(this.flags, flagSet.flags);
    }

    public int hashCode() {
        return Objects.hashCode(this.flags);
    }

    public FlagSet<E> copy() {
        return new FlagSet<E>(this.enumClass, this.prefix, this.flags);
    }

    public String toConfigurationString() {
        return this.flags.stream().map(Enum::name).collect(Collectors.joining(", "));
    }

    public static <E extends Enum<E>> FlagSet<E> createFlagSet(Class<E> enumClass, String prefix, EnumSet<E> flags) {
        return new FlagSet<E>(enumClass, prefix, flags);
    }

    @SafeVarargs
    public static <E extends Enum<E>> FlagSet<E> createFlagSet(Class<E> enumClass, String prefix, E ... enabled) {
        FlagSet flagSet = new FlagSet(enumClass, prefix, null);
        Arrays.stream(enabled).forEach(flag -> {
            if (flag != null) {
                flagSet.enable(flag);
            }
        });
        return flagSet;
    }

    public static <E extends Enum<E>> FlagSet<E> buildFlagSet(Class<E> enumClass, Configuration conf, String key, boolean ignoreUnknown) {
        EnumSet<E> flags = conf.getEnumSet(key, enumClass, ignoreUnknown);
        return FlagSet.createFlagSet(enumClass, key + ".", flags);
    }
}

