/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.UUID;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MessageUtil.class);
    public static final int DEFAULT_STATE_TRANSITION_MESSAGE_RETRY_COUNT = 3;

    public static Message createStateTransitionCancellationMessage(String srcInstanceName, String srcSessionId, Resource resource, String partitionName, String instanceName, String sessionId, String stateModelDefName, String fromState, String toState, String nextState, Message cancellationMessage, boolean isCancellationEnabled, String currentState) {
        if (isCancellationEnabled && cancellationMessage == null) {
            LOG.info("Create cancellation message of the state transition for {}.{} on {}, currentState: {}, nextState: {},  toState: {}", new Object[]{resource.getResourceName(), partitionName, instanceName, currentState, nextState == null ? "N/A" : nextState, toState});
            Message message = MessageUtil.createStateTransitionMessage(Message.MessageType.STATE_TRANSITION_CANCELLATION, srcInstanceName, srcSessionId, resource, partitionName, instanceName, currentState, nextState, sessionId, stateModelDefName);
            message.setFromState(fromState);
            message.setToState(toState);
            return message;
        }
        return null;
    }

    public static Message createStateTransitionMessage(String srcInstanceName, String srcSessionId, Resource resource, String partitionName, String instanceName, String currentState, String nextState, String tgtSessionId, String stateModelDefName) {
        Message message = MessageUtil.createStateTransitionMessage(Message.MessageType.STATE_TRANSITION, srcInstanceName, srcSessionId, resource, partitionName, instanceName, currentState, nextState, tgtSessionId, stateModelDefName);
        message.setRetryCount(3);
        if (resource.getResourceGroupName() != null) {
            message.setResourceGroupName(resource.getResourceGroupName());
        }
        if (resource.getResourceTag() != null) {
            message.setResourceTag(resource.getResourceTag());
        }
        return message;
    }

    public static Message createStatusChangeMessage(LiveInstance.LiveInstanceStatus currentState, LiveInstance.LiveInstanceStatus nextState, String srcInstanceName, String srcSessionId, String tgtInstanceName, String tgtSessionId) {
        return MessageUtil.createBasicMessage(Message.MessageType.PARTICIPANT_STATUS_CHANGE, srcInstanceName, srcSessionId, tgtInstanceName, tgtSessionId, currentState.name(), nextState.name());
    }

    private static Message createBasicMessage(Message.MessageType messageType, String srcInstanceName, String srcSessionId, String tgtInstanceName, String tgtSessionId, String currentState, String nextState) {
        String uuid = UUID.randomUUID().toString();
        Message message = new Message(messageType, uuid);
        message.setSrcName(srcInstanceName);
        message.setTgtName(tgtInstanceName);
        message.setMsgState(Message.MessageState.NEW);
        message.setFromState(currentState);
        message.setToState(nextState);
        message.setTgtSessionId(tgtSessionId);
        message.setSrcSessionId(srcSessionId);
        message.setExpectedSessionId(srcSessionId);
        return message;
    }

    private static Message createStateTransitionMessage(Message.MessageType messageType, String srcInstanceName, String srcSessionId, Resource resource, String partitionName, String instanceName, String currentState, String nextState, String tgtSessionId, String stateModelDefName) {
        Message message = MessageUtil.createBasicMessage(messageType, srcInstanceName, srcSessionId, instanceName, tgtSessionId, currentState, nextState);
        message.setPartitionName(partitionName);
        message.setStateModelDef(stateModelDefName);
        message.setResourceName(resource.getResourceName());
        message.setStateModelFactoryName(resource.getStateModelFactoryname());
        message.setBucketSize(resource.getBucketSize());
        return message;
    }
}

