/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableSet;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.direct.AutoValue_StatefulParDoEvaluatorFactory_AppliedPTransformOutputKeyAndWindow;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DirectTimerInternals;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.DoFnLifecycleManagerRemovingTransformEvaluator;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.local.StructuralKey;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

final class StatefulParDoEvaluatorFactory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements TransformEvaluatorFactory {
    private final @UnknownKeyFor @NonNull @Initialized ParDoEvaluatorFactory<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> delegateFactory;
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;

    StatefulParDoEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext, final @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.delegateFactory = new ParDoEvaluatorFactory(evaluationContext, ParDoEvaluator.defaultRunnerFactory(), new CacheLoader<AppliedPTransform<?, ?, ?>, DoFnLifecycleManager>(){

            public @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManager load(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> appliedStatefulParDo) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ParDoMultiOverrideFactory.StatefulParDo statefulParDo = (ParDoMultiOverrideFactory.StatefulParDo)appliedStatefulParDo.getTransform();
                return DoFnLifecycleManager.of(statefulParDo.getDoFn(), options);
            }
        }, options);
        this.evaluationContext = evaluationContext;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<T> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TransformEvaluator<KeyedWorkItem<K, KV<K, InputT>>> evaluator = this.createEvaluator(application, inputBundle);
        return evaluator;
    }

    @Override
    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.delegateFactory.cleanup();
    }

    private @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> createEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple,  @UnknownKeyFor @NonNull @Initialized ParDoMultiOverrideFactory.StatefulParDo<K, InputT, OutputT>> application, @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        DoFnLifecycleManagerRemovingTransformEvaluator<? extends KeyedWorkItem<K, KV<K, InputT>>> delegateEvaluator = this.delegateFactory.createEvaluator((AppliedPTransform<PCollection<KV<K, ? extends KeyedWorkItem<K, KV<K, InputT>>>>, PCollectionTuple, ?>)application, (PCollection<KV<K, ? extends KeyedWorkItem<K, KV<K, InputT>>>>)inputBundle.getPCollection(), inputBundle.getKey(), application.getTransform().getSideInputs(), application.getTransform().getMainOutputTag(), application.getTransform().getAdditionalOutputTags().getAll(), application.getTransform().getSchemaInformation(), application.getTransform().getSideInputMapping());
        DirectExecutionContext.DirectStepContext stepContext = this.evaluationContext.getExecutionContext(application, inputBundle.getKey()).getStepContext(this.evaluationContext.getStepName(application));
        ((CopyOnAccessInMemoryStateInternals)stepContext.stateInternals()).commit();
        return new StatefulParDoEvaluator(delegateEvaluator, stepContext);
    }

    private static @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> setTimerTag( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        return StateTags.makeSystemTagInternal(StateTags.watermarkStateInternal("timer-" + timerData.getTimerId() + "+" + timerData.getTimerFamilyId(), TimestampCombiner.EARLIEST));
    }

    private static class StatefulParDoEvaluator<@UnknownKeyFor K, @UnknownKeyFor InputT>
    implements TransformEvaluator<KeyedWorkItem<K, KV<K, InputT>>> {
        private final @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManagerRemovingTransformEvaluator<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> delegateEvaluator;
        private final @UnknownKeyFor @NonNull @Initialized DirectTimerInternals timerInternals;
         @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext;

        public StatefulParDoEvaluator(@UnknownKeyFor @NonNull @Initialized DoFnLifecycleManagerRemovingTransformEvaluator<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> delegateEvaluator,  @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext stepContext) {
            this.delegateEvaluator = delegateEvaluator;
            this.timerInternals = delegateEvaluator.getParDoEvaluator().getStepContext().timerInternals();
            this.stepContext = stepContext;
        }

        @Override
        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> gbkResult) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (WindowedValue<KV<K, InputT>> windowedValue : gbkResult.getValue().elementsIterable()) {
                this.delegateEvaluator.processElement(windowedValue);
            }
            for (TimerInternals.TimerData timerData : gbkResult.getValue().timersIterable()) {
                NavigableSet<TimerInternals.TimerData> earlierTimers = this.timerInternals.getModifiedTimersOrdered(timerData.getDomain()).headSet(timerData, true);
                while (!earlierTimers.isEmpty()) {
                    TimerInternals.TimerData insertedTimer = earlierTimers.pollFirst();
                    if (this.timerModified(insertedTimer)) continue;
                    this.timerInternals.deleteTimer(insertedTimer);
                    this.processTimer(insertedTimer, gbkResult.getValue().key());
                }
                if (this.timerModified(timerData)) continue;
                this.processTimer(timerData, gbkResult.getValue().key());
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean timerModified( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
            TimerInternals.TimerData modifiedTimer = this.timerInternals.getModifiedTimerIds().get(timerData.stringKey());
            return modifiedTimer != null && !modifiedTimer.equals(timerData);
        }

        private void processTimer( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData, K key) throws @UnknownKeyFor @NonNull @Initialized Exception {
            StateNamespaces.WindowNamespace windowNamespace = (StateNamespaces.WindowNamespace)timerData.getNamespace();
            Object timerWindow = windowNamespace.getWindow();
            this.delegateEvaluator.onTimer(timerData, key, (BoundedWindow)timerWindow);
            this.clearWatermarkHold(timerData);
        }

        private void clearWatermarkHold( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            StateTag timerWatermarkHoldTag = StatefulParDoEvaluatorFactory.setTimerTag(timer);
            ((WatermarkHoldState)this.stepContext.stateInternals().state(timer.getNamespace(), timerWatermarkHoldTag)).clear();
            ((CopyOnAccessInMemoryStateInternals)this.stepContext.stateInternals()).commit();
        }

        private void setWatermarkHold( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            StateTag timerWatermarkHoldTag = StatefulParDoEvaluatorFactory.setTimerTag(timer);
            ((WatermarkHoldState)this.stepContext.stateInternals().state(timer.getNamespace(), timerWatermarkHoldTag)).add(timer.getOutputTimestamp());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>> finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            void var4_10;
            CopyOnAccessInMemoryStateInternals state;
            TransformResult<KV<K, InputT>> delegateResult = this.delegateEvaluator.finishBundle();
            boolean isTimerDeclared = false;
            for (TimerInternals.TimerData timerData : delegateResult.getTimerUpdate().getSetTimers()) {
                this.setWatermarkHold(timerData);
                isTimerDeclared = true;
            }
            for (TimerInternals.TimerData timerData : delegateResult.getTimerUpdate().getDeletedTimers()) {
                this.clearWatermarkHold(timerData);
            }
            if (isTimerDeclared && delegateResult.getState() != null) {
                state = delegateResult.getState();
                Instant instant = this.stepContext.commitState().getEarliestWatermarkHold();
            } else if (isTimerDeclared) {
                state = this.stepContext.commitState();
                Instant instant = state.getEarliestWatermarkHold();
            } else {
                state = delegateResult.getState();
                Instant instant = delegateResult.getWatermarkHold();
            }
            WatermarkManager.TimerUpdate timerUpdate = delegateResult.getTimerUpdate();
            StepTransformResult.Builder regroupedResult = StepTransformResult.withHold(delegateResult.getTransform(), (Instant)var4_10).withTimerUpdate(timerUpdate).withState(state).withMetricUpdates(delegateResult.getLogicalMetricUpdates()).addOutput(Lists.newArrayList(delegateResult.getOutputBundles())).withBundleFinalizations(delegateResult.getBundleFinalizations());
            Iterator<WindowedValue<KV<K, InputT>>> iterator = delegateResult.getUnprocessedElements().iterator();
            while (iterator.hasNext()) {
                WindowedValue<KV<K, InputT>> untypedUnprocessed;
                WindowedValue<KV<K, InputT>> windowedKv = untypedUnprocessed = iterator.next();
                WindowedValue pushedBack = windowedKv.withValue(KeyedWorkItems.elementsWorkItem(windowedKv.getValue().getKey(), Collections.singleton(windowedKv)));
                regroupedResult.addUnprocessedElements(pushedBack);
            }
            return regroupedResult.build();
        }
    }

    @AutoValue
    static abstract class AppliedPTransformOutputKeyAndWindow<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        AppliedPTransformOutputKeyAndWindow() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple,  @UnknownKeyFor @NonNull @Initialized ParDoMultiOverrideFactory.StatefulParDo<K, InputT, OutputT>> getTransform();

        abstract @UnknownKeyFor @NonNull @Initialized StructuralKey<K> getKey();

        abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow();

        static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedPTransformOutputKeyAndWindow<K, InputT, OutputT> create(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, @UnknownKeyFor @NonNull @Initialized KV<K, InputT>>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple,  @UnknownKeyFor @NonNull @Initialized ParDoMultiOverrideFactory.StatefulParDo<K, InputT, OutputT>> transform, @UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            return new AutoValue_StatefulParDoEvaluatorFactory_AppliedPTransformOutputKeyAndWindow<K, InputT, OutputT>(transform, key, w);
        }
    }
}

