/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import java.util.ArrayList;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class PaneExtractors {
    private PaneExtractors() {
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> onlyPane( @UnknownKeyFor @NonNull @Initialized PAssert.PAssertionSite site) {
        return new ExtractOnlyPane(site);
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> onTimePane() {
        return new ExtractOnTimePane();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> finalPane() {
        return new ExtractFinalPane();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> nonLatePanes() {
        return new ExtractNonLatePanes();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> earlyPanes() {
        return new ExtractEarlyPanes();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> latePanes() {
        return new ExtractLatePanes();
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>, @UnknownKeyFor @NonNull @Initialized Iterable<T>> allPanes() {
        return new ExtractAllPanes();
    }

    private static class ExtractLatePanes<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractLatePanes() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (value.getPane().getTiming() != PaneInfo.Timing.LATE) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractEarlyPanes<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractEarlyPanes() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (value.getPane().getTiming() != PaneInfo.Timing.EARLY) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractNonLatePanes<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractNonLatePanes() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (value.getPane().getTiming() == PaneInfo.Timing.LATE) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractAllPanes<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractAllPanes() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractFinalPane<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractFinalPane() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().isLast()) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnTimePane<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private ExtractOnTimePane() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().getTiming().equals((Object)PaneInfo.Timing.ON_TIME)) continue;
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }

    private static class ExtractOnlyPane<@UnknownKeyFor T>
    extends SimpleFunction<Iterable<ValueInSingleWindow<T>>, Iterable<T>> {
        private final  @UnknownKeyFor @NonNull @Initialized PAssert.PAssertionSite site;

        private ExtractOnlyPane( @UnknownKeyFor @NonNull @Initialized PAssert.PAssertionSite site) {
            this.site = site;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> input) {
            ArrayList<T> outputs = new ArrayList<T>();
            for (ValueInSingleWindow<T> value : input) {
                if (!value.getPane().isFirst() || !value.getPane().isLast()) {
                    throw this.site.wrap(String.format("Expected elements to be produced by a trigger that fires at most once, but got a value %s in a pane that is %s.", value, value.getPane().isFirst() ? "not the last pane" : "not the first pane"));
                }
                outputs.add(value.getValue());
            }
            return outputs;
        }
    }
}

