/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodboutput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodb.MongoDbMeta;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutput;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputData;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputDialog;
import org.w3c.dom.Node;

@Transform(id="MongoDbOutput", image="mongodb-output.svg", name="i18n::MongoDbOutput.Name", description="i18n::MongoDbOutput.Description", documentationUrl="/pipeline/transforms/mongodboutput.html", keywords={"i18n::MongoDbOutputMeta.keyword"}, categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output")
@InjectionSupported(localizationPrefix="MongoDbOutput.Injection.", groups={"FIELDS", "INDEXES"})
public class MongoDbOutputMeta
extends MongoDbMeta<MongoDbOutput, MongoDbOutputData> {
    private static final Class<?> PKG = MongoDbOutputMeta.class;
    public static final String CONST_SPACES = "\n    ";
    public static final String CONST_FIELDS = "mongo_fields";
    public static final String MONGO_FIELD = "mongo_field";
    public static final String CONST_MONGO_INDEXES = "mongo_indexes";
    public static final String CONST_MONGO_INDEX = "mongo_index";
    public static final String CONST_SPACES1 = "\n      ";
    public static final String CONST_SPACES2 = "\n         ";
    @Injection(name="TRUNCATE")
    protected boolean truncate;
    @Injection(name="UPDATE")
    protected boolean update;
    @Injection(name="UPSERT")
    protected boolean upsert;
    @Injection(name="MULTI")
    protected boolean multi;
    @Injection(name="MODIFIER_UPDATE")
    protected boolean modifierUpdate;
    @Injection(name="BATCH_INSERT_SIZE")
    protected String batchInsertSize = "100";
    @InjectionDeep
    protected List<MongoField> mongoFields;
    @InjectionDeep
    protected List<MongoIndex> mongoIndexes;
    public static final int RETRIES = 5;
    public static final int RETRY_DELAY = 10;
    @Injection(name="RETRY_NUMBER")
    private String writeRetries = "5";
    @Injection(name="RETRY_DELAY")
    private String writeRetryDelay = "10";

    public void setDefault() {
        this.setCollection("");
        this.upsert = false;
        this.modifierUpdate = true;
        this.truncate = false;
        this.batchInsertSize = "100";
    }

    public void setMongoFields(List<MongoField> mongoFields) {
        this.mongoFields = mongoFields;
    }

    public List<MongoField> getMongoFields() {
        return this.mongoFields;
    }

    public void setMongoIndexes(List<MongoIndex> mongoIndexes) {
        this.mongoIndexes = mongoIndexes;
    }

    public List<MongoIndex> getMongoIndexes() {
        return this.mongoIndexes;
    }

    public void setWriteRetries(String r) {
        this.writeRetries = r;
    }

    public String getWriteRetries() {
        return this.writeRetries;
    }

    public void setWriteRetryDelay(String d) {
        this.writeRetryDelay = d;
    }

    public String getWriteRetryDelay() {
        return this.writeRetryDelay;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    public boolean getUpsert() {
        return this.upsert;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean getMulti() {
        return this.multi;
    }

    public void setModifierUpdate(boolean u) {
        this.modifierUpdate = u;
    }

    public boolean getModifierUpdate() {
        return this.modifierUpdate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean getTruncate() {
        return this.truncate;
    }

    public String getBatchInsertSize() {
        return this.batchInsertSize;
    }

    public void setBatchInsertSize(String size) {
        this.batchInsertSize = size;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingFields", (Object[])new Object[]{prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)"connection", (String)this.connectionName));
        if (!StringUtils.isEmpty((String)this.getCollection())) {
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"mongo_collection", (String)this.getCollection()));
        }
        if (!StringUtils.isEmpty((String)this.batchInsertSize)) {
            xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"batch_insert_size", (String)this.batchInsertSize));
        }
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"truncate", (boolean)this.truncate));
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"update", (boolean)this.update));
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"upsert", (boolean)this.upsert));
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"multi", (boolean)this.multi));
        xml.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"modifier_update", (boolean)this.modifierUpdate));
        xml.append("    ").append(XmlHandler.addTagValue((String)"write_retries", (String)this.writeRetries));
        xml.append("    ").append(XmlHandler.addTagValue((String)"write_retry_delay", (String)this.writeRetryDelay));
        if (this.mongoFields != null && !this.mongoFields.isEmpty()) {
            xml.append(CONST_SPACES).append(XmlHandler.openTag((String)CONST_FIELDS));
            for (MongoField field : this.mongoFields) {
                xml.append(CONST_SPACES1).append(XmlHandler.openTag((String)MONGO_FIELD));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"incoming_field_name", (String)field.incomingFieldName));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"mongo_doc_path", (String)field.mongoDocPath));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"use_incoming_field_name_as_mongo_field_name", (boolean)field.useIncomingFieldNameAsMongoFieldName));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"update_match_field", (boolean)field.updateMatchField));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"modifier_update_operation", (String)field.modifierUpdateOperation));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"modifier_policy", (String)field.modifierOperationApplyPolicy));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"json_field", (boolean)field.inputJson));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"allow_null", (boolean)field.insertNull));
                xml.append(CONST_SPACES1).append(XmlHandler.closeTag((String)MONGO_FIELD));
            }
            xml.append(CONST_SPACES).append(XmlHandler.closeTag((String)CONST_FIELDS));
        }
        if (this.mongoIndexes != null && !this.mongoIndexes.isEmpty()) {
            xml.append(CONST_SPACES).append(XmlHandler.openTag((String)CONST_MONGO_INDEXES));
            for (MongoIndex index : this.mongoIndexes) {
                xml.append(CONST_SPACES1).append(XmlHandler.openTag((String)CONST_MONGO_INDEX));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"path_to_fields", (String)index.pathToFields));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"drop", (boolean)index.drop));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"unique", (boolean)index.unique));
                xml.append(CONST_SPACES2).append(XmlHandler.addTagValue((String)"sparse", (boolean)index.sparse));
                xml.append(CONST_SPACES1).append(XmlHandler.closeTag((String)CONST_MONGO_INDEX));
            }
            xml.append(CONST_SPACES).append(XmlHandler.closeTag((String)CONST_MONGO_INDEXES));
        }
        return xml.toString();
    }

    public void loadXml(Node node, IHopMetadataProvider metaStore) throws HopXmlException {
        Node fieldNode;
        int i;
        int nrFields;
        Node fields;
        String writeRetryDelay;
        String writeRetries;
        this.connectionName = XmlHandler.getTagValue((Node)node, (String)"connection");
        this.collection = XmlHandler.getTagValue((Node)node, (String)"mongo_collection");
        this.batchInsertSize = XmlHandler.getTagValue((Node)node, (String)"batch_insert_size");
        this.truncate = XmlHandler.getTagValue((Node)node, (String)"truncate").equalsIgnoreCase("Y");
        String update = XmlHandler.getTagValue((Node)node, (String)"update");
        if (!StringUtils.isEmpty((String)update)) {
            this.update = update.equalsIgnoreCase("Y");
        }
        this.upsert = XmlHandler.getTagValue((Node)node, (String)"upsert").equalsIgnoreCase("Y");
        this.multi = XmlHandler.getTagValue((Node)node, (String)"multi").equalsIgnoreCase("Y");
        this.modifierUpdate = XmlHandler.getTagValue((Node)node, (String)"modifier_update").equalsIgnoreCase("Y");
        if (this.upsert || this.multi) {
            this.update = true;
        }
        if (!StringUtils.isEmpty((String)(writeRetries = XmlHandler.getTagValue((Node)node, (String)"write_retries")))) {
            this.writeRetries = writeRetries;
        }
        if (!StringUtils.isEmpty((String)(writeRetryDelay = XmlHandler.getTagValue((Node)node, (String)"write_retry_delay")))) {
            this.writeRetryDelay = writeRetryDelay;
        }
        if ((fields = XmlHandler.getSubNode((Node)node, (String)CONST_FIELDS)) != null && XmlHandler.countNodes((Node)fields, (String)MONGO_FIELD) > 0) {
            nrFields = XmlHandler.countNodes((Node)fields, (String)MONGO_FIELD);
            this.mongoFields = new ArrayList<MongoField>();
            for (i = 0; i < nrFields; ++i) {
                String jsonField;
                fieldNode = XmlHandler.getSubNodeByNr((Node)fields, (String)MONGO_FIELD, (int)i);
                MongoField newField = new MongoField();
                newField.incomingFieldName = XmlHandler.getTagValue((Node)fieldNode, (String)"incoming_field_name");
                newField.mongoDocPath = XmlHandler.getTagValue((Node)fieldNode, (String)"mongo_doc_path");
                newField.useIncomingFieldNameAsMongoFieldName = XmlHandler.getTagValue((Node)fieldNode, (String)"use_incoming_field_name_as_mongo_field_name").equalsIgnoreCase("Y");
                newField.updateMatchField = XmlHandler.getTagValue((Node)fieldNode, (String)"update_match_field").equalsIgnoreCase("Y");
                newField.modifierUpdateOperation = XmlHandler.getTagValue((Node)fieldNode, (String)"modifier_update_operation");
                String policy = XmlHandler.getTagValue((Node)fieldNode, (String)"modifier_policy");
                if (!StringUtils.isEmpty((String)policy)) {
                    newField.modifierOperationApplyPolicy = policy;
                }
                if (!StringUtils.isEmpty((String)(jsonField = XmlHandler.getTagValue((Node)fieldNode, (String)"json_field")))) {
                    newField.inputJson = jsonField.equalsIgnoreCase("Y");
                }
                String allowNull = XmlHandler.getTagValue((Node)fieldNode, (String)"allow_null");
                newField.insertNull = "Y".equalsIgnoreCase(allowNull);
                this.mongoFields.add(newField);
            }
        }
        if ((fields = XmlHandler.getSubNode((Node)node, (String)CONST_MONGO_INDEXES)) != null && XmlHandler.countNodes((Node)fields, (String)CONST_MONGO_INDEX) > 0) {
            nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_MONGO_INDEX);
            this.mongoIndexes = new ArrayList<MongoIndex>();
            for (i = 0; i < nrFields; ++i) {
                fieldNode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_MONGO_INDEX, (int)i);
                MongoIndex newIndex = new MongoIndex();
                newIndex.pathToFields = XmlHandler.getTagValue((Node)fieldNode, (String)"path_to_fields");
                newIndex.drop = XmlHandler.getTagValue((Node)fieldNode, (String)"drop").equalsIgnoreCase("Y");
                newIndex.unique = XmlHandler.getTagValue((Node)fieldNode, (String)"unique").equalsIgnoreCase("Y");
                newIndex.sparse = XmlHandler.getTagValue((Node)fieldNode, (String)"sparse").equalsIgnoreCase("Y");
                this.mongoIndexes.add(newIndex);
            }
        }
    }

    public String getDialogClassName() {
        return MongoDbOutputDialog.class.getCanonicalName();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static class MongoField {
        @Injection(name="INCOMING_FIELD_NAME", group="FIELDS")
        public String incomingFieldName = "";
        String environUpdatedFieldName = "";
        @Injection(name="MONGO_DOCUMENT_PATH", group="FIELDS")
        public String mongoDocPath = "";
        String environUpdateMongoDocPath = "";
        protected List<String> pathList;
        protected List<String> tempPathList;
        @Injection(name="INCOMING_AS_MONGO", group="FIELDS")
        public boolean useIncomingFieldNameAsMongoFieldName;
        @Injection(name="UPDATE_MATCH_FIELD", group="FIELDS")
        public boolean updateMatchField;
        @Injection(name="MODIFIER_OPERATION", group="FIELDS")
        public String modifierUpdateOperation = "N/A";
        String environUpdateModifierOperation = "";
        @Injection(name="MODIFIER_POLICY", group="FIELDS")
        public String modifierOperationApplyPolicy = "Insert&Update";
        @Injection(name="INSERT_NULL", group="FIELDS")
        public boolean insertNull = false;
        @Injection(name="JSON", group="FIELDS")
        public boolean inputJson = false;

        public MongoField copy() {
            MongoField mongoField = new MongoField();
            mongoField.incomingFieldName = this.incomingFieldName;
            mongoField.environUpdatedFieldName = this.environUpdatedFieldName;
            mongoField.mongoDocPath = this.mongoDocPath;
            mongoField.environUpdateMongoDocPath = this.environUpdateMongoDocPath;
            mongoField.useIncomingFieldNameAsMongoFieldName = this.useIncomingFieldNameAsMongoFieldName;
            mongoField.updateMatchField = this.updateMatchField;
            mongoField.modifierUpdateOperation = this.modifierUpdateOperation;
            mongoField.environUpdateModifierOperation = this.environUpdateModifierOperation;
            mongoField.modifierOperationApplyPolicy = this.modifierOperationApplyPolicy;
            mongoField.inputJson = this.inputJson;
            mongoField.insertNull = this.insertNull;
            return mongoField;
        }

        public void init(IVariables variables) {
            this.init(variables, true);
        }

        public void init(IVariables variables, boolean updateFromEnv) {
            if (updateFromEnv) {
                this.environUpdatedFieldName = variables.resolve(this.incomingFieldName);
                this.environUpdateMongoDocPath = variables.resolve(this.mongoDocPath);
                this.environUpdateModifierOperation = variables.resolve(this.modifierUpdateOperation);
            }
            this.pathList = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.environUpdateMongoDocPath)) {
                String[] parts;
                for (String p : parts = this.environUpdateMongoDocPath.split("\\.")) {
                    this.pathList.add(p);
                }
            }
            this.tempPathList = new ArrayList<String>(this.pathList);
        }

        public void reset() {
            if (this.tempPathList != null && !this.tempPathList.isEmpty()) {
                this.tempPathList.clear();
            }
            if (this.tempPathList != null) {
                this.tempPathList.addAll(this.pathList);
            }
        }
    }

    public static class MongoIndex {
        @Injection(name="INDEX_FIELD", group="INDEXES")
        public String pathToFields = "";
        @Injection(name="DROP", group="INDEXES")
        public boolean drop;
        @Injection(name="UNIQUE", group="INDEXES")
        public boolean unique;
        @Injection(name="SPARSE", group="INDEXES")
        public boolean sparse;

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.pathToFields + " (unique = " + Boolean.toString(this.unique) + " sparse = " + Boolean.toString(this.sparse) + ")");
            return buff.toString();
        }
    }
}

