/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkload;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.mysqlbulkload.ActionMysqlBulkLoad;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionMysqlBulkLoadDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionMysqlBulkLoad.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Filetype.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Filetype.All", (String[])new String[0])};
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchemaname;
    private TextVar wTablename;
    private ActionMysqlBulkLoad action;
    private boolean changed;
    private TextVar wFilename;
    private Button wLocalInfile;
    private TextVar wSeparator;
    private TextVar wEnclosed;
    private TextVar wEscaped;
    private TextVar wLineterminated;
    private TextVar wLinestarted;
    private TextVar wListattribut;
    private TextVar wIgnorelines;
    private Button wReplaceData;
    private CCombo wPriorityValue;
    private Button wAddFileToResult;

    public ActionMysqlBulkLoadDialog(Shell parent, ActionMysqlBulkLoad action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), lsMod);
        Label wlSchemaname = new Label((Composite)this.shell, 131072);
        wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Schemaname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, -margin);
        fdlSchemaname.top = new FormAttachment(this.wConnection, margin);
        wlSchemaname.setLayoutData((Object)fdlSchemaname);
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, margin);
        fdSchemaname.right = new FormAttachment(100, 0);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        Label wlTablename = new Label((Composite)this.shell, 131072);
        wlTablename.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Tablename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.right = new FormAttachment(middle, -margin);
        fdlTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        wlTablename.setLayoutData((Object)fdlTablename);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchemaname, margin / 2);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkLoadDialog.this.getTableName();
            }
        });
        this.wTablename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTablename);
        this.wTablename.addModifyListener(lsMod);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        fdTablename.right = new FormAttachment((Control)wbTable, -margin);
        this.wTablename.setLayoutData((Object)fdTablename);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wTablename, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wTablename, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wTablename, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt", "*.csv", "*"}, (String[])FILETYPES, (boolean)true));
        Label wlLocalInfile = new Label((Composite)this.shell, 131072);
        wlLocalInfile.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.LocalInfile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLocalInfile);
        FormData fdlLocalInfile = new FormData();
        fdlLocalInfile.left = new FormAttachment(0, 0);
        fdlLocalInfile.top = new FormAttachment((Control)this.wFilename, margin);
        fdlLocalInfile.right = new FormAttachment(middle, -margin);
        wlLocalInfile.setLayoutData((Object)fdlLocalInfile);
        this.wLocalInfile = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wLocalInfile);
        this.wLocalInfile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.LocalInfile.Tooltip", (String[])new String[0]));
        FormData fdLocalInfile = new FormData();
        fdLocalInfile.left = new FormAttachment(middle, 0);
        fdLocalInfile.top = new FormAttachment((Control)wlLocalInfile, 0, 0x1000000);
        fdLocalInfile.right = new FormAttachment(100, 0);
        this.wLocalInfile.setLayoutData((Object)fdLocalInfile);
        this.wLocalInfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkLoadDialog.this.action.setChanged();
            }
        });
        Label wlPriorityValue = new Label((Composite)this.shell, 131072);
        wlPriorityValue.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.ProrityValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPriorityValue);
        FormData fdlPriorityValue = new FormData();
        fdlPriorityValue.left = new FormAttachment(0, 0);
        fdlPriorityValue.right = new FormAttachment(middle, -margin);
        fdlPriorityValue.top = new FormAttachment((Control)wlLocalInfile, 2 * margin);
        wlPriorityValue.setLayoutData((Object)fdlPriorityValue);
        this.wPriorityValue = new CCombo((Composite)this.shell, 2060);
        this.wPriorityValue.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.NorProrityValue.Label", (String[])new String[0]));
        this.wPriorityValue.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.LowProrityValue.Label", (String[])new String[0]));
        this.wPriorityValue.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.ConProrityValue.Label", (String[])new String[0]));
        this.wPriorityValue.select(0);
        PropsUi.setLook((Widget)this.wPriorityValue);
        FormData fdPriorityValue = new FormData();
        fdPriorityValue.left = new FormAttachment(middle, 0);
        fdPriorityValue.top = new FormAttachment((Control)wlLocalInfile, 2 * margin);
        fdPriorityValue.right = new FormAttachment(100, 0);
        this.wPriorityValue.setLayoutData((Object)fdPriorityValue);
        Label wlSeparator = new Label((Composite)this.shell, 131072);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Separator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        fdlSeparator.top = new FormAttachment((Control)this.wPriorityValue, margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        this.wSeparator = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        this.wSeparator.addModifyListener(lsMod);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.top = new FormAttachment((Control)this.wPriorityValue, margin);
        fdSeparator.right = new FormAttachment(100, 0);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        Label wlEnclosed = new Label((Composite)this.shell, 131072);
        wlEnclosed.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Enclosed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosed);
        FormData fdlEnclosed = new FormData();
        fdlEnclosed.left = new FormAttachment(0, 0);
        fdlEnclosed.right = new FormAttachment(middle, -margin);
        fdlEnclosed.top = new FormAttachment((Control)this.wSeparator, margin);
        wlEnclosed.setLayoutData((Object)fdlEnclosed);
        this.wEnclosed = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosed);
        this.wEnclosed.addModifyListener(lsMod);
        FormData fdEnclosed = new FormData();
        fdEnclosed.left = new FormAttachment(middle, 0);
        fdEnclosed.top = new FormAttachment((Control)this.wSeparator, margin);
        fdEnclosed.right = new FormAttachment(100, 0);
        this.wEnclosed.setLayoutData((Object)fdEnclosed);
        Label wlEscaped = new Label((Composite)this.shell, 131072);
        wlEscaped.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Escaped.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEscaped);
        FormData fdlEscaped = new FormData();
        fdlEscaped.left = new FormAttachment(0, 0);
        fdlEscaped.right = new FormAttachment(middle, -margin);
        fdlEscaped.top = new FormAttachment((Control)this.wEnclosed, margin);
        wlEscaped.setLayoutData((Object)fdlEscaped);
        this.wEscaped = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEscaped);
        this.wEscaped.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Escaped.Tooltip", (String[])new String[0]));
        this.wEscaped.addModifyListener(lsMod);
        FormData fdEscaped = new FormData();
        fdEscaped.left = new FormAttachment(middle, 0);
        fdEscaped.top = new FormAttachment((Control)this.wEnclosed, margin);
        fdEscaped.right = new FormAttachment(100, 0);
        this.wEscaped.setLayoutData((Object)fdEscaped);
        Label wlLinestarted = new Label((Composite)this.shell, 131072);
        wlLinestarted.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Linestarted.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLinestarted);
        FormData fdlLinestarted = new FormData();
        fdlLinestarted.left = new FormAttachment(0, 0);
        fdlLinestarted.right = new FormAttachment(middle, -margin);
        fdlLinestarted.top = new FormAttachment((Control)this.wEscaped, margin);
        wlLinestarted.setLayoutData((Object)fdlLinestarted);
        this.wLinestarted = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLinestarted);
        this.wLinestarted.addModifyListener(lsMod);
        FormData fdLinestarted = new FormData();
        fdLinestarted.left = new FormAttachment(middle, 0);
        fdLinestarted.top = new FormAttachment((Control)this.wEscaped, margin);
        fdLinestarted.right = new FormAttachment(100, 0);
        this.wLinestarted.setLayoutData((Object)fdLinestarted);
        Label wlLineterminated = new Label((Composite)this.shell, 131072);
        wlLineterminated.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Lineterminated.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLineterminated);
        FormData fdlLineterminated = new FormData();
        fdlLineterminated.left = new FormAttachment(0, 0);
        fdlLineterminated.right = new FormAttachment(middle, -margin);
        fdlLineterminated.top = new FormAttachment((Control)this.wLinestarted, margin);
        wlLineterminated.setLayoutData((Object)fdlLineterminated);
        this.wLineterminated = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLineterminated);
        this.wLineterminated.addModifyListener(lsMod);
        FormData fdLineterminated = new FormData();
        fdLineterminated.left = new FormAttachment(middle, 0);
        fdLineterminated.top = new FormAttachment((Control)this.wLinestarted, margin);
        fdLineterminated.right = new FormAttachment(100, 0);
        this.wLineterminated.setLayoutData((Object)fdLineterminated);
        Label wlListattribut = new Label((Composite)this.shell, 131072);
        wlListattribut.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Listattribut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlListattribut);
        FormData fdlListattribut = new FormData();
        fdlListattribut.left = new FormAttachment(0, 0);
        fdlListattribut.right = new FormAttachment(middle, -margin);
        fdlListattribut.top = new FormAttachment((Control)this.wLineterminated, margin);
        wlListattribut.setLayoutData((Object)fdlListattribut);
        Button wbListattribut = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbListattribut);
        wbListattribut.setText(BaseMessages.getString(PKG, (String)"System.Button.Edit", (String[])new String[0]));
        FormData fdbListattribut = new FormData();
        fdbListattribut.right = new FormAttachment(100, 0);
        fdbListattribut.top = new FormAttachment((Control)this.wLineterminated, margin);
        wbListattribut.setLayoutData((Object)fdbListattribut);
        wbListattribut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkLoadDialog.this.getListColumns();
            }
        });
        this.wListattribut = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wListattribut);
        this.wListattribut.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Listattribut.Tooltip", (String[])new String[0]));
        this.wListattribut.addModifyListener(lsMod);
        FormData fdListattribut = new FormData();
        fdListattribut.left = new FormAttachment(middle, 0);
        fdListattribut.top = new FormAttachment((Control)this.wLineterminated, margin);
        fdListattribut.right = new FormAttachment((Control)wbListattribut, -margin);
        this.wListattribut.setLayoutData((Object)fdListattribut);
        Label wlReplaceData = new Label((Composite)this.shell, 131072);
        wlReplaceData.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Replacedata.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReplaceData);
        FormData fdlReplaceData = new FormData();
        fdlReplaceData.left = new FormAttachment(0, 0);
        fdlReplaceData.top = new FormAttachment((Control)this.wListattribut, margin);
        fdlReplaceData.right = new FormAttachment(middle, -margin);
        wlReplaceData.setLayoutData((Object)fdlReplaceData);
        this.wReplaceData = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wReplaceData);
        this.wReplaceData.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Replacedata.Tooltip", (String[])new String[0]));
        FormData fdReplaceData = new FormData();
        fdReplaceData.left = new FormAttachment(middle, 0);
        fdReplaceData.top = new FormAttachment((Control)wlReplaceData, 0, 0x1000000);
        fdReplaceData.right = new FormAttachment(100, 0);
        this.wReplaceData.setLayoutData((Object)fdReplaceData);
        this.wReplaceData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkLoadDialog.this.action.setChanged();
            }
        });
        Label wlIgnorelines = new Label((Composite)this.shell, 131072);
        wlIgnorelines.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Ignorelines.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnorelines);
        FormData fdlIgnorelines = new FormData();
        fdlIgnorelines.left = new FormAttachment(0, 0);
        fdlIgnorelines.right = new FormAttachment(middle, -margin);
        fdlIgnorelines.top = new FormAttachment((Control)wlReplaceData, 2 * margin);
        wlIgnorelines.setLayoutData((Object)fdlIgnorelines);
        this.wIgnorelines = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wIgnorelines);
        this.wIgnorelines.addModifyListener(lsMod);
        FormData fdIgnorelines = new FormData();
        fdIgnorelines.left = new FormAttachment(middle, 0);
        fdIgnorelines.top = new FormAttachment((Control)wlReplaceData, 2 * margin);
        fdIgnorelines.right = new FormAttachment(100, 0);
        this.wIgnorelines.setLayoutData((Object)fdIgnorelines);
        Group wFileResult = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wFileResult);
        wFileResult.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.FileResult.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wFileResult.setLayout((Layout)groupLayout);
        Label wlAddFileToResult = new Label((Composite)wFileResult, 131072);
        wlAddFileToResult.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.AddFileToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddFileToResult);
        FormData fdlAddFileToResult = new FormData();
        fdlAddFileToResult.left = new FormAttachment(0, 0);
        fdlAddFileToResult.top = new FormAttachment((Control)this.wIgnorelines, margin);
        fdlAddFileToResult.right = new FormAttachment(middle, -margin);
        wlAddFileToResult.setLayoutData((Object)fdlAddFileToResult);
        this.wAddFileToResult = new Button((Composite)wFileResult, 32);
        PropsUi.setLook((Widget)this.wAddFileToResult);
        this.wAddFileToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.AddFileToResult.Tooltip", (String[])new String[0]));
        FormData fdAddFileToResult = new FormData();
        fdAddFileToResult.left = new FormAttachment(middle, 0);
        fdAddFileToResult.top = new FormAttachment((Control)wlAddFileToResult, 0, 0x1000000);
        fdAddFileToResult.right = new FormAttachment(100, 0);
        this.wAddFileToResult.setLayoutData((Object)fdAddFileToResult);
        this.wAddFileToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkLoadDialog.this.action.setChanged();
            }
        });
        FormData fdFileResult = new FormData();
        fdFileResult.left = new FormAttachment(0, margin);
        fdFileResult.top = new FormAttachment((Control)this.wIgnorelines, margin);
        fdFileResult.right = new FormAttachment(100, -margin);
        fdFileResult.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wFileResult.setLayoutData((Object)fdFileResult);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        if (this.action.getSchemaname() != null) {
            this.wSchemaname.setText(this.action.getSchemaname());
        }
        if (this.action.getTablename() != null) {
            this.wTablename.setText(this.action.getTablename());
        }
        if (this.action.getFilename() != null) {
            this.wFilename.setText(this.action.getFilename());
        }
        if (this.action.getSeparator() != null) {
            this.wSeparator.setText(this.action.getSeparator());
        }
        if (this.action.getEnclosed() != null) {
            this.wEnclosed.setText(this.action.getEnclosed());
        }
        if (this.action.getEscaped() != null) {
            this.wEscaped.setText(this.action.getEscaped());
        }
        if (this.action.getLinestarted() != null) {
            this.wLinestarted.setText(this.action.getLinestarted());
        }
        if (this.action.getLineterminated() != null) {
            this.wLineterminated.setText(this.action.getLineterminated());
        }
        this.wReplaceData.setSelection(this.action.isReplacedata());
        this.wLocalInfile.setSelection(this.action.isLocalInfile());
        if (this.action.getIgnorelines() != null) {
            this.wIgnorelines.setText(this.action.getIgnorelines());
        } else {
            this.wIgnorelines.setText("0");
        }
        if (this.action.getListattribut() != null) {
            this.wListattribut.setText(this.action.getListattribut());
        }
        if (this.action.prorityvalue >= 0) {
            this.wPriorityValue.select(this.action.prorityvalue);
        } else {
            this.wPriorityValue.select(0);
        }
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        this.wAddFileToResult.setSelection(this.action.isAddFileToResult());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables));
        this.action.setSchemaname(this.wSchemaname.getText());
        this.action.setTablename(this.wTablename.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setSeparator(this.wSeparator.getText());
        this.action.setEnclosed(this.wEnclosed.getText());
        this.action.setEscaped(this.wEscaped.getText());
        this.action.setLineterminated(this.wLineterminated.getText());
        this.action.setLinestarted(this.wLinestarted.getText());
        this.action.setReplacedata(this.wReplaceData.getSelection());
        this.action.setIgnorelines(this.wIgnorelines.getText());
        this.action.setListattribut(this.wListattribut.getText());
        this.action.prorityvalue = this.wPriorityValue.getSelectionIndex();
        this.action.setLocalInfile(this.wLocalInfile.getSelection());
        this.action.setAddFileToResult(this.wAddFileToResult.getSelection());
        this.dispose();
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName, this.variables);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablename.getText());
                if (std.open()) {
                    this.wTablename.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.ConnectionError2.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    private void getListColumns() {
        DatabaseMeta databaseMeta;
        if (!Utils.isEmpty((CharSequence)this.wTablename.getText()) && (databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables)) != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.wSchemaname.getText(), this.wTablename.getText());
                IRowMeta row = database.getTableFields(schemaTable);
                String[] available = row.getFieldNames();
                String[] source = this.wListattribut.getText().split(",");
                for (int i = 0; i < source.length; ++i) {
                    source[i] = Const.trim((String)source[i]);
                }
                int[] idxSource = Const.indexsOfStrings((String[])source, (String[])available);
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, available, BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.SelectColumns.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.SelectColumns.Message", (String[])new String[0]));
                dialog.setMulti(true);
                dialog.setAvoidQuickSearch();
                dialog.setSelectedNrs(idxSource);
                if (dialog.open() != null) {
                    Object columns = "";
                    int[] idx = dialog.getSelectionIndeces();
                    for (int i = 0; i < idx.length; ++i) {
                        if (i > 0) {
                            columns = (String)columns + ", ";
                        }
                        columns = (String)columns + available[idx[i]];
                    }
                    this.wListattribut.setText((String)columns);
                }
            }
            catch (HopDatabaseException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.ConnectionError2.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
            }
        }
    }
}

