/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.seenstate;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum PlatformType {
    WEB,
    DESKTOP,
    MOBILE_IOS,
    MOBILE_ANDROID,
    API,
    UNKNOWN,
    MOBILE,
    OTHER;


    public static class Serializer
    extends UnionSerializer<PlatformType> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PlatformType value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case WEB: {
                    g.writeString("web");
                    break;
                }
                case DESKTOP: {
                    g.writeString("desktop");
                    break;
                }
                case MOBILE_IOS: {
                    g.writeString("mobile_ios");
                    break;
                }
                case MOBILE_ANDROID: {
                    g.writeString("mobile_android");
                    break;
                }
                case API: {
                    g.writeString("api");
                    break;
                }
                case UNKNOWN: {
                    g.writeString("unknown");
                    break;
                }
                case MOBILE: {
                    g.writeString("mobile");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PlatformType deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            PlatformType value = "web".equals(tag) ? WEB : ("desktop".equals(tag) ? DESKTOP : ("mobile_ios".equals(tag) ? MOBILE_IOS : ("mobile_android".equals(tag) ? MOBILE_ANDROID : ("api".equals(tag) ? API : ("unknown".equals(tag) ? UNKNOWN : ("mobile".equals(tag) ? MOBILE : OTHER))))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

