/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserNameLogInfo {
    @Nonnull
    protected final String givenName;
    @Nonnull
    protected final String surname;
    @Nullable
    protected final String locale;

    public UserNameLogInfo(@Nonnull String givenName, @Nonnull String surname, @Nullable String locale) {
        if (givenName == null) {
            throw new IllegalArgumentException("Required value for 'givenName' is null");
        }
        this.givenName = givenName;
        if (surname == null) {
            throw new IllegalArgumentException("Required value for 'surname' is null");
        }
        this.surname = surname;
        this.locale = locale;
    }

    public UserNameLogInfo(@Nonnull String givenName, @Nonnull String surname) {
        this(givenName, surname, null);
    }

    @Nonnull
    public String getGivenName() {
        return this.givenName;
    }

    @Nonnull
    public String getSurname() {
        return this.surname;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.givenName, this.surname, this.locale});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserNameLogInfo other = (UserNameLogInfo)obj;
            return !(this.givenName != other.givenName && !this.givenName.equals(other.givenName) || this.surname != other.surname && !this.surname.equals(other.surname) || this.locale != other.locale && (this.locale == null || !this.locale.equals(other.locale)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserNameLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserNameLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("given_name");
            StoneSerializers.string().serialize(value.givenName, g);
            g.writeFieldName("surname");
            StoneSerializers.string().serialize(value.surname, g);
            if (value.locale != null) {
                g.writeFieldName("locale");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.locale, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserNameLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_locale;
            String f_surname;
            String f_givenName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_givenName = null;
                f_surname = null;
                f_locale = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("given_name".equals(field)) {
                        f_givenName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("surname".equals(field)) {
                        f_surname = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("locale".equals(field)) {
                        f_locale = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_givenName == null) {
                    throw new JsonParseException(p, "Required field \"given_name\" missing.");
                }
                if (f_surname == null) {
                    throw new JsonParseException(p, "Required field \"surname\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserNameLogInfo value = new UserNameLogInfo(f_givenName, f_surname, f_locale);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

