/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.Serializable;

public class AS400Certificate
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private byte[] certificate_;
    private String info_;
    private byte[] byteData_;

    public AS400Certificate() {
    }

    public AS400Certificate(byte[] certificate) {
        this.certificate_ = certificate;
    }

    public byte[] getByteInfo() {
        return this.byteData_;
    }

    public byte[] getEncoded() {
        int len = this.getLength(this.certificate_);
        if (len != this.certificate_.length) {
            byte[] tempBytes = this.certificate_;
            this.certificate_ = new byte[len];
            System.arraycopy(tempBytes, 0, this.certificate_, 0, len);
        }
        return this.certificate_;
    }

    public String getInfo() {
        return this.info_;
    }

    public void setByteInfo(byte[] byteData) {
        this.byteData_ = byteData;
    }

    public void setEncoded(byte[] certificate) {
        this.certificate_ = certificate;
    }

    public void setInfo(String information) {
        this.info_ = information;
    }

    private int getLength(byte[] derSeq) {
        int length;
        int lengthByteCount = derSeq[1];
        int addlen = 2;
        if (0 == (derSeq[1] & 0x80)) {
            length = derSeq[1];
        } else {
            lengthByteCount &= 0x7F;
            length = 0;
            int i = 2;
            while (lengthByteCount > 0) {
                length <<= 8;
                length += derSeq[i] & 0xFF;
                ++addlen;
                --lengthByteCount;
                ++i;
            }
        }
        return length + addlen;
    }
}

