/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VSystemValue;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class VSysvalTextDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private JTextField valueText_;
    private VSystemValue systemValue_;
    private Frame frame_;
    private JButton okButton_;
    private JButton cancelButton_;
    private JButton applyButton_;
    private static final String okButtonText_ = ResourceLoader.getText("DLG_OK");
    private static final String cancelButtonText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String applyButtonText_ = ResourceLoader.getText("DLG_APPLY");
    private static final String modifyDialogTitle_ = ResourceLoader.getText("DLG_MODIFY_0");
    private static final String modifyActionTab_ = ResourceLoader.getText("ACTION_MODIFY");
    private static final String valueName_ = ResourceLoader.getText("COLUMN_NAME");
    private static final String valueDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION");
    private static final String valueInformation_ = ResourceLoader.getText("COLUMN_VALUE");

    public VSysvalTextDialog(VSystemValue systemValue, Frame frame) {
        super(frame, ResourceLoader.substitute(modifyDialogTitle_, systemValue.getName()), true);
        this.systemValue_ = systemValue;
        this.frame_ = frame;
        int length = this.systemValue_.getDescription().length();
        if (length <= 29) {
            length = 30;
        }
        this.setSize(30 + 8 * length, 200);
        this.setResizable(false);
        JPanel line1 = new JPanel();
        this.okButton_ = new JButton(okButtonText_);
        this.cancelButton_ = new JButton(cancelButtonText_);
        this.applyButton_ = new JButton(applyButtonText_);
        this.applyButton_.setEnabled(false);
        this.okButton_.addActionListener(this);
        this.cancelButton_.addActionListener(this);
        this.applyButton_.addActionListener(this);
        line1.add(this.okButton_);
        line1.add(this.cancelButton_);
        line1.add(this.applyButton_);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(modifyActionTab_, this.getComponent());
        Container c = this.getContentPane();
        c.add("North", tabbedPane);
        c.add("South", line1);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton_)) {
            try {
                this.applyChanges();
                this.dispose();
            }
            catch (Exception x) {
                x.fillInStackTrace();
                this.systemValue_.errorEventSupport_.fireError(x);
            }
        }
        if (e.getSource().equals(this.cancelButton_)) {
            this.dispose();
        }
        if (e.getSource().equals(this.applyButton_)) {
            try {
                this.applyChanges();
                this.applyButton_.setEnabled(false);
            }
            catch (Exception x) {
                x.fillInStackTrace();
                this.systemValue_.errorEventSupport_.fireError(x);
            }
        }
    }

    public void applyChanges() {
        int type = this.systemValue_.getType();
        switch (type) {
            case 3: {
                Integer intValue = null;
                intValue = Integer.valueOf(this.valueText_.getText());
                this.systemValue_.setValue(intValue);
                break;
            }
            case 2: {
                BigDecimal decValue = null;
                decValue = new BigDecimal(this.valueText_.getText());
                this.systemValue_.setValue(decValue);
                break;
            }
            case 1: {
                this.systemValue_.setValue(this.valueText_.getText());
            }
        }
        Object value = null;
        value = this.systemValue_.getValue();
        this.applyButton_.setEnabled(false);
        this.systemValue_.load();
    }

    private Component getComponent() {
        JPanel jPanel1 = new JPanel();
        GridBagLayout gridBa2 = new GridBagLayout();
        jPanel1.setLayout(gridBa2);
        jPanel1.setBorder(new EmptyBorder(10, 10, 10, 10));
        int int3 = 0;
        int n = ++int3;
        ++int3;
        VUtilities.constrain(valueName_ + ": ", this.systemValue_.getName(), jPanel1, gridBa2, n);
        ++int3;
        this.valueText_ = new JTextField();
        this.valueText_.addKeyListener(this);
        int valueType = this.systemValue_.getType();
        String valueString = null;
        Object valueObject = null;
        valueObject = this.systemValue_.getValue();
        Integer in = null;
        BigDecimal bd = null;
        switch (valueType) {
            case 3: {
                in = (Integer)valueObject;
                valueString = in.toString();
                break;
            }
            case 2: {
                bd = (BigDecimal)valueObject;
                valueString = bd.toString();
                break;
            }
            case 1: {
                valueString = (String)valueObject;
            }
        }
        this.valueText_.setText(valueString);
        VUtilities.constrain(new JLabel(valueInformation_ + ": "), jPanel1, gridBa2, 0, int3, 1, 1);
        VUtilities.constrain(this.valueText_, jPanel1, gridBa2, 1, int3++, 1, 1);
        ++int3;
        int length1 = this.systemValue_.getDescription().length();
        if (length1 < 29) {
            StringBuffer sb = new StringBuffer(this.systemValue_.getDescription());
            for (int i = 0; i < 29 - length1; ++i) {
                sb.append(" ");
            }
            VUtilities.constrain(valueDescription_ + ": ", sb.toString(), jPanel1, gridBa2, int3++);
        } else {
            VUtilities.constrain(valueDescription_ + ": ", this.systemValue_.getDescription(), jPanel1, gridBa2, int3++);
        }
        return jPanel1;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.applyButton_.setEnabled(true);
    }
}

