/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.copy.CopyOperation;
import com.amazon.redshift.core.CommandCompleteParser;
import com.amazon.redshift.core.Encoding;
import com.amazon.redshift.core.EncodingPredictor;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.NativeQuery;
import com.amazon.redshift.core.Notification;
import com.amazon.redshift.core.Oid;
import com.amazon.redshift.core.ParameterList;
import com.amazon.redshift.core.Parser;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.QueryExecutorBase;
import com.amazon.redshift.core.RedshiftBindException;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.ReplicationProtocol;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandler;
import com.amazon.redshift.core.ResultHandlerBase;
import com.amazon.redshift.core.ResultHandlerDelegate;
import com.amazon.redshift.core.SqlCommand;
import com.amazon.redshift.core.SqlCommandType;
import com.amazon.redshift.core.TransactionState;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.core.v3.BatchedQuery;
import com.amazon.redshift.core.v3.CompositeQuery;
import com.amazon.redshift.core.v3.ConnectionFactoryImpl;
import com.amazon.redshift.core.v3.CopyOperationImpl;
import com.amazon.redshift.core.v3.CopyQueryExecutor;
import com.amazon.redshift.core.v3.DescribeRequest;
import com.amazon.redshift.core.v3.ExecuteRequest;
import com.amazon.redshift.core.v3.MessageLoopState;
import com.amazon.redshift.core.v3.Portal;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.core.v3.SimpleParameterList;
import com.amazon.redshift.core.v3.SimpleQuery;
import com.amazon.redshift.core.v3.V3ParameterList;
import com.amazon.redshift.core.v3.replication.V3ReplicationProtocol;
import com.amazon.redshift.jdbc.AutoSave;
import com.amazon.redshift.jdbc.BatchResultHandler;
import com.amazon.redshift.jdbc.FieldMetadata;
import com.amazon.redshift.jdbc.TimestampUtils;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ByteStreamWriter;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.QuerySanitizer;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftPropertyMaxResultBufferParser;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftWarning;
import com.amazon.redshift.util.ServerErrorMessage;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class QueryExecutorImpl
extends QueryExecutorBase {
    private static final String COPY_ERROR_MESSAGE = "COPY commands are only supported using the CopyManager API.";
    private static final Pattern ROLLBACK_PATTERN = Pattern.compile("\\brollback\\b", 2);
    private static final Pattern COMMIT_PATTERN = Pattern.compile("\\bcommit\\b", 2);
    private static final Pattern PREPARE_PATTERN = Pattern.compile("\\bprepare ++transaction\\b", 2);
    private TimeZone timeZone;
    private String applicationName;
    private boolean integerDateTimes;
    private final Set<Integer> useBinaryReceiveForOids = new HashSet<Integer>();
    private final Set<Integer> useBinarySendForOids = new HashSet<Integer>();
    private final SimpleQuery sync;
    private short deallocateEpoch;
    private String lastSetSearchPathQuery;
    private SQLException transactionFailCause;
    private final ReplicationProtocol replicationProtocol;
    private boolean enableFetchRingBuffer;
    private long fetchRingBufferSize;
    private RingBufferThread m_ringBufferThread;
    private boolean m_ringBufferStopThread;
    private Object m_ringBufferThreadLock;
    private final Lock m_executingLock;
    private final CommandCompleteParser commandCompleteParser;
    private final CopyQueryExecutor copyQueryExecutor;
    private Object lockedFor;
    private static final int MAX_BUFFERED_RECV_BYTES = 64000;
    private static final int NODATA_QUERY_RESPONSE_SIZE_BYTES = 250;
    private final HashMap<PhantomReference<SimpleQuery>, String> parsedQueryMap;
    private final ReferenceQueue<SimpleQuery> parsedQueryCleanupQueue;
    private final HashMap<PhantomReference<Portal>, String> openPortalMap;
    private final ReferenceQueue<Portal> openPortalCleanupQueue;
    private static final Portal UNNAMED_PORTAL = new Portal(null, "unnamed");
    private final Deque<SimpleQuery> pendingParseQueue;
    private final Deque<Portal> pendingBindQueue;
    private final Deque<ExecuteRequest> pendingExecuteQueue;
    private final Deque<DescribeRequest> pendingDescribeStatementQueue;
    private final Deque<SimpleQuery> pendingDescribePortalQueue;
    private long nextUniqueID;
    private final boolean allowEncodingChanges;
    private final boolean cleanupSavePoints;
    private int estimatedReceiveBufferBytes;
    private final SimpleQuery beginTransactionQuery;
    private final SimpleQuery beginReadOnlyTransactionQuery;
    private final SimpleQuery emptyQuery;
    private final SimpleQuery autoSaveQuery;
    private final SimpleQuery releaseAutoSave;
    private final SimpleQuery restoreToAutoSave;

    private static boolean looksLikeCommit(String sql) {
        if ("COMMIT".equalsIgnoreCase(sql)) {
            return true;
        }
        if ("ROLLBACK".equalsIgnoreCase(sql)) {
            return false;
        }
        return COMMIT_PATTERN.matcher(sql).find() && !ROLLBACK_PATTERN.matcher(sql).find();
    }

    private static boolean looksLikePrepare(String sql) {
        return sql.startsWith("PREPARE TRANSACTION") || PREPARE_PATTERN.matcher(sql).find();
    }

    public QueryExecutorImpl(RedshiftStream pgStream, String user, String database, int cancelSignalTimeout, Properties info, RedshiftLogger logger) throws SQLException, IOException {
        super(pgStream, user, database, cancelSignalTimeout, info, logger);
        this.sync = (SimpleQuery)this.createQuery((String)"SYNC", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.m_ringBufferThread = null;
        this.m_ringBufferStopThread = false;
        this.m_ringBufferThreadLock = new Object();
        this.m_executingLock = new ReentrantLock();
        this.commandCompleteParser = new CommandCompleteParser();
        this.lockedFor = null;
        this.parsedQueryMap = new HashMap();
        this.parsedQueryCleanupQueue = new ReferenceQueue();
        this.openPortalMap = new HashMap();
        this.openPortalCleanupQueue = new ReferenceQueue();
        this.pendingParseQueue = new ArrayDeque<SimpleQuery>();
        this.pendingBindQueue = new ArrayDeque<Portal>();
        this.pendingExecuteQueue = new ArrayDeque<ExecuteRequest>();
        this.pendingDescribeStatementQueue = new ArrayDeque<DescribeRequest>();
        this.pendingDescribePortalQueue = new ArrayDeque<SimpleQuery>();
        this.nextUniqueID = 1L;
        this.estimatedReceiveBufferBytes = 0;
        this.beginTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN", new int[0], false, SqlCommand.BLANK), null, false, this.logger);
        this.beginReadOnlyTransactionQuery = new SimpleQuery(new NativeQuery("BEGIN READ ONLY", new int[0], false, SqlCommand.BLANK), null, false, this.logger);
        this.emptyQuery = new SimpleQuery(new NativeQuery("", new int[0], false, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)), null, false, this.logger);
        this.autoSaveQuery = new SimpleQuery(new NativeQuery("SAVEPOINT RSJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false, this.logger);
        this.releaseAutoSave = new SimpleQuery(new NativeQuery("RELEASE SAVEPOINT RSJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false, this.logger);
        this.restoreToAutoSave = new SimpleQuery(new NativeQuery("ROLLBACK TO SAVEPOINT RSJDBC_AUTOSAVE", new int[0], false, SqlCommand.BLANK), null, false, this.logger);
        this.allowEncodingChanges = RedshiftProperty.ALLOW_ENCODING_CHANGES.getBoolean(info);
        this.cleanupSavePoints = RedshiftProperty.CLEANUP_SAVEPOINTS.getBoolean(info);
        this.replicationProtocol = new V3ReplicationProtocol(this, pgStream);
        this.enableFetchRingBuffer = RedshiftProperty.ENABLE_FETCH_RING_BUFFER.getBoolean(info);
        String fetchRingBufferSizeStr = RedshiftProperty.FETCH_RING_BUFFER_SIZE.get(info);
        this.fetchRingBufferSize = fetchRingBufferSizeStr != null ? RedshiftPropertyMaxResultBufferParser.parseProperty(fetchRingBufferSizeStr, RedshiftProperty.FETCH_RING_BUFFER_SIZE.getName()) : 0L;
        this.enableStatementCache = RedshiftProperty.ENABLE_STATEMENT_CACHE.getBoolean(info);
        this.copyQueryExecutor = new CopyQueryExecutor(this, logger, pgStream);
        this.serverProtocolVersion = 0;
        this.readStartupMessages();
    }

    @Override
    public int getProtocolVersion() {
        return 3;
    }

    public long getBytesReadFromStream() {
        return this.pgStream.getBytesFromStream();
    }

    void lock(Object obtainer) throws RedshiftException {
        if (this.lockedFor == obtainer) {
            throw new RedshiftException(GT.tr("Tried to obtain lock while already holding it", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
        }
        this.waitOnLock();
        this.lockedFor = obtainer;
    }

    void unlock(Object holder) throws RedshiftException {
        if (this.lockedFor != holder) {
            throw new RedshiftException(GT.tr("Tried to break lock on database connection", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE);
        }
        this.lockedFor = null;
        this.notify();
    }

    void waitOnLock() throws RedshiftException {
        while (this.lockedFor != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RedshiftException(GT.tr("Interrupted while waiting to obtain lock on database connection", new Object[0]), RedshiftState.OBJECT_NOT_IN_STATE, (Throwable)ie);
            }
        }
    }

    boolean hasLock(Object holder) {
        return this.lockedFor == holder;
    }

    @Override
    public Query createSimpleQuery(String sql) throws SQLException {
        List<NativeQuery> queries = Parser.parseJdbcSql(sql, this.getStandardConformingStrings(), false, true, true, this.isReWriteBatchedInsertsEnabled(), new String[0]);
        return this.wrap(queries);
    }

    @Override
    public Query wrap(List<NativeQuery> queries) {
        if (queries.isEmpty()) {
            return this.emptyQuery;
        }
        if (queries.size() == 1) {
            NativeQuery firstQuery = queries.get(0);
            if (this.isReWriteBatchedInsertsEnabled() && firstQuery.getCommand().isBatchedReWriteCompatible()) {
                int valuesBraceOpenPosition = firstQuery.getCommand().getBatchRewriteValuesBraceOpenPosition();
                int valuesBraceClosePosition = firstQuery.getCommand().getBatchRewriteValuesBraceClosePosition();
                return new BatchedQuery(firstQuery, this, valuesBraceOpenPosition, valuesBraceClosePosition, this.isColumnSanitiserDisabled(), this.logger);
            }
            return new SimpleQuery(firstQuery, this, this.isColumnSanitiserDisabled(), this.logger);
        }
        SimpleQuery[] subqueries = new SimpleQuery[queries.size()];
        int[] offsets = new int[subqueries.length];
        int offset = 0;
        for (int i = 0; i < queries.size(); ++i) {
            NativeQuery nativeQuery = queries.get(i);
            offsets[i] = offset;
            subqueries[i] = new SimpleQuery(nativeQuery, this, this.isColumnSanitiserDisabled(), this.logger);
            offset += nativeQuery.bindPositions.length;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    private int updateQueryMode(int flags) {
        switch (this.getPreferQueryMode()) {
            case SIMPLE: {
                return flags | 0x400;
            }
            case EXTENDED: {
                return flags & 0xFFFFFBFF;
            }
        }
        return flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.waitForRingBufferThreadToFinish(false, false, false, null, null);
        QueryExecutorImpl queryExecutorImpl = this;
        synchronized (queryExecutorImpl) {
            this.waitOnLock();
            try {
                this.m_executingLock.lock();
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "  simple execute, handler={0}, maxRows={1}, fetchSize={2}, flags={3}", handler, maxRows, fetchSize, flags);
                }
                if (handler != null) {
                    handler.setStatementStateInQueryFromIdle();
                }
                if (parameters == null) {
                    parameters = SimpleQuery.NO_PARAMETERS;
                }
                boolean describeOnly = (0x20 & (flags = this.updateQueryMode(flags))) != 0;
                ((V3ParameterList)parameters).convertFunctionOutParameters();
                if (!describeOnly) {
                    ((V3ParameterList)parameters).checkAllParametersSet();
                }
                boolean autosave = false;
                try {
                    try {
                        handler = this.sendQueryPreamble(handler, flags);
                        autosave = this.sendAutomaticSavepoint(query, flags);
                        this.sendQuery(query, (V3ParameterList)parameters, maxRows, fetchSize, flags, handler, null);
                        if ((flags & 0x400) == 0) {
                            this.sendFlush();
                            this.sendSync(true);
                        }
                        this.processResults(handler, flags, fetchSize, query.getSubqueries() != null, maxRows);
                        this.estimatedReceiveBufferBytes = 0;
                    }
                    catch (RedshiftBindException se) {
                        this.sendSync(true);
                        this.processResults(handler, flags, 0, query.getSubqueries() != null, maxRows);
                        this.estimatedReceiveBufferBytes = 0;
                        handler.handleError(new RedshiftException(GT.tr("Unable to bind parameter values for statement.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE, se.getIOException(), this.logger));
                    }
                }
                catch (IOException e) {
                    this.abort();
                    handler.handleError(new RedshiftException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), RedshiftState.CONNECTION_FAILURE, e, this.logger));
                }
                catch (SQLException sqe) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logError(sqe);
                    }
                    throw sqe;
                }
                try {
                    handler.handleCompletion();
                    if (this.cleanupSavePoints) {
                        this.releaseSavePoint(autosave, flags);
                    }
                }
                catch (SQLException e) {
                    this.rollbackIfRequired(autosave, e);
                }
            }
            finally {
                this.m_executingLock.unlock();
            }
        }
    }

    private boolean sendAutomaticSavepoint(Query query, int flags) throws IOException {
        if (!((flags & 0x10) != 0 && this.getTransactionState() != TransactionState.OPEN || query == this.restoreToAutoSave || this.getAutoSave() == AutoSave.NEVER || this.getAutoSave() != AutoSave.ALWAYS && query instanceof SimpleQuery && ((SimpleQuery)query).getFields() == null)) {
            this.sendOneQuery(this.autoSaveQuery, SimpleQuery.NO_PARAMETERS, 1, 0, 1030);
            return true;
        }
        return false;
    }

    private void releaseSavePoint(boolean autosave, int flags) throws SQLException {
        if (autosave && this.getAutoSave() == AutoSave.ALWAYS && this.getTransactionState() == TransactionState.OPEN) {
            try {
                this.sendOneQuery(this.releaseAutoSave, SimpleQuery.NO_PARAMETERS, 1, 0, 1030);
            }
            catch (IOException ex) {
                throw new RedshiftException(GT.tr("Error releasing savepoint", new Object[0]), RedshiftState.IO_ERROR);
            }
        }
    }

    private void rollbackIfRequired(boolean autosave, SQLException e) throws SQLException {
        if (autosave && this.getTransactionState() == TransactionState.FAILED && (this.getAutoSave() == AutoSave.ALWAYS || this.willHealOnRetry(e))) {
            try {
                this.execute(this.restoreToAutoSave, SimpleQuery.NO_PARAMETERS, new ResultHandlerDelegate(null), 1, 0, 1030);
            }
            catch (SQLException e2) {
                e.setNextException(e2);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.logError(e);
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Query[] queries, ParameterList[] parameterLists, BatchResultHandler batchHandler, int maxRows, int fetchSize, int flags) throws SQLException {
        this.waitForRingBufferThreadToFinish(false, false, false, null, null);
        QueryExecutorImpl queryExecutorImpl = this;
        synchronized (queryExecutorImpl) {
            this.waitOnLock();
            try {
                boolean describeOnly;
                this.m_executingLock.lock();
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "  batch execute {0} queries, handler={1}, maxRows={2}, fetchSize={3}, flags={4}", queries.length, batchHandler, maxRows, fetchSize, flags);
                }
                if (batchHandler != null) {
                    batchHandler.setStatementStateInQueryFromIdle();
                }
                boolean bl = describeOnly = (0x20 & (flags = this.updateQueryMode(flags))) != 0;
                if (!describeOnly) {
                    for (ParameterList parameterList : parameterLists) {
                        if (parameterList == null) continue;
                        ((V3ParameterList)parameterList).checkAllParametersSet();
                    }
                }
                boolean autosave = false;
                ResultHandler handler = batchHandler;
                try {
                    handler = this.sendQueryPreamble(batchHandler, flags);
                    autosave = this.sendAutomaticSavepoint(queries[0], flags);
                    this.estimatedReceiveBufferBytes = 0;
                    for (int i = 0; i < queries.length; ++i) {
                        Query query = queries[i];
                        V3ParameterList parameters = (V3ParameterList)parameterLists[i];
                        if (parameters == null) {
                            parameters = SimpleQuery.NO_PARAMETERS;
                        }
                        this.sendQuery(query, parameters, maxRows, fetchSize, flags, handler, batchHandler);
                        if (handler.getException() != null) break;
                    }
                    if (handler.getException() == null) {
                        if ((flags & 0x400) == 0) {
                            this.sendFlush();
                            this.sendSync(true);
                        }
                        this.processResults(handler, flags, fetchSize, true, maxRows);
                        this.estimatedReceiveBufferBytes = 0;
                    }
                }
                catch (IOException e) {
                    this.abort();
                    handler.handleError(new RedshiftException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), RedshiftState.CONNECTION_FAILURE, e, this.logger));
                }
                catch (SQLException sqe) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logError(sqe);
                    }
                    throw sqe;
                }
                try {
                    handler.handleCompletion();
                    if (this.cleanupSavePoints) {
                        this.releaseSavePoint(autosave, flags);
                    }
                }
                catch (SQLException e) {
                    this.rollbackIfRequired(autosave, e);
                }
            }
            finally {
                this.m_executingLock.unlock();
            }
        }
    }

    private ResultHandler sendQueryPreamble(ResultHandler delegateHandler, int flags) throws IOException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((flags & 0x10) != 0 || this.getTransactionState() != TransactionState.IDLE) {
            return delegateHandler;
        }
        int beginFlags = 2;
        if ((flags & 1) != 0) {
            beginFlags |= 1;
        }
        beginFlags |= 0x400;
        beginFlags = this.updateQueryMode(beginFlags);
        SimpleQuery beginQuery = (flags & 0x800) == 0 ? this.beginTransactionQuery : this.beginReadOnlyTransactionQuery;
        this.sendOneQuery(beginQuery, SimpleQuery.NO_PARAMETERS, 0, 0, beginFlags);
        return new ResultHandlerDelegate(delegateHandler){
            private boolean sawBegin;
            {
                this.sawBegin = false;
            }

            @Override
            public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
                if (this.sawBegin) {
                    super.handleResultRows(fromQuery, fields, tuples, cursor, queueTuples, rowCount, ringBufferThread);
                }
            }

            @Override
            public void handleCommandStatus(String status, long updateCount, long insertOID) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        this.handleError(new RedshiftException(GT.tr("Expected command status BEGIN, got {0}.", status), RedshiftState.PROTOCOL_VIOLATION));
                    }
                } else {
                    super.handleCommandStatus(status, updateCount, insertOID);
                }
            }
        };
    }

    @Override
    public byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        return null;
    }

    public void doSubprotocolBegin() throws SQLException {
        if (this.getTransactionState() == TransactionState.IDLE) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, "Issuing BEGIN before fastpath or copy call.", new Object[0]);
            }
            ResultHandlerBase handler = new ResultHandlerBase(){
                private boolean sawBegin = false;

                @Override
                public void handleCommandStatus(String status, long updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new RedshiftException(GT.tr("Expected command status BEGIN, got {0}.", status), RedshiftState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new RedshiftException(GT.tr("Unexpected command status: {0}.", status), RedshiftState.PROTOCOL_VIOLATION));
                    }
                }

                @Override
                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }
            };
            try {
                int beginFlags = 1027;
                beginFlags = this.updateQueryMode(beginFlags);
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, beginFlags);
                this.sendSync(true);
                this.processResults(handler, 0, 0, false, 0);
                this.estimatedReceiveBufferBytes = 0;
            }
            catch (IOException ioe) {
                throw new RedshiftException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
    }

    @Override
    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count, this);
    }

    @Override
    public synchronized void processNotifies() throws SQLException {
        this.processNotifies(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void processNotifies(int timeoutMillis) throws SQLException {
        this.waitOnLock();
        if (this.getTransactionState() != TransactionState.IDLE) {
            return;
        }
        if (this.hasNotifications()) {
            timeoutMillis = -1;
        }
        boolean useTimeout = timeoutMillis > 0;
        long startTime = 0L;
        int oldTimeout = 0;
        if (useTimeout) {
            startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            try {
                oldTimeout = this.pgStream.getSocket().getSoTimeout();
            }
            catch (SocketException e) {
                throw new RedshiftException(GT.tr("An error occurred while trying to get the socket timeout.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        try {
            block14: while (true) {
                if (timeoutMillis < 0) {
                    if (!this.pgStream.hasMessagePending()) return;
                }
                if (useTimeout && timeoutMillis >= 0) {
                    this.setSocketTimeout(timeoutMillis);
                }
                int c = this.pgStream.receiveChar();
                if (useTimeout && timeoutMillis >= 0) {
                    this.setSocketTimeout(0);
                }
                switch (c) {
                    case 65: {
                        this.receiveAsyncNotify();
                        timeoutMillis = -1;
                        continue block14;
                    }
                    case 69: {
                        throw this.receiveErrorResponse(false);
                    }
                    case 78: {
                        SQLWarning warning = this.receiveNoticeResponse();
                        this.addWarning(warning);
                        if (!useTimeout) continue block14;
                        long newTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                        timeoutMillis = (int)((long)timeoutMillis + (startTime - newTimeMillis));
                        startTime = newTimeMillis;
                        if (timeoutMillis != 0) continue block14;
                        timeoutMillis = -1;
                        continue block14;
                    }
                }
                throw new RedshiftException(GT.tr("Unknown Response Type {0}.", Character.valueOf((char)c)), RedshiftState.CONNECTION_FAILURE);
            }
        }
        catch (SocketTimeoutException c) {
            return;
        }
        catch (IOException ioe) {
            throw new RedshiftException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)ioe);
        }
        finally {
            if (useTimeout) {
                this.setSocketTimeout(oldTimeout);
            }
        }
    }

    private void setSocketTimeout(int millis) throws RedshiftException {
        try {
            Socket s = this.pgStream.getSocket();
            if (!s.isClosed()) {
                this.pgStream.setNetworkTimeout(millis);
            }
        }
        catch (IOException e) {
            throw new RedshiftException(GT.tr("An error occurred while trying to reset the socket timeout.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    @Override
    public CopyOperation startCopy(String sql, boolean suppressBegin) throws SQLException {
        return this.copyQueryExecutor.startCopy(sql, suppressBegin);
    }

    public void cancelCopy(CopyOperationImpl op) throws SQLException {
        this.copyQueryExecutor.cancelCopy(op);
    }

    public synchronized long endCopy(CopyOperationImpl op) throws SQLException {
        return this.copyQueryExecutor.endCopy(op);
    }

    public synchronized void writeToCopy(CopyOperationImpl op, byte[] data, int off, int siz) throws SQLException {
        this.copyQueryExecutor.writeToCopy(op, data, off, siz);
    }

    public synchronized void writeToCopy(CopyOperationImpl op, ByteStreamWriter from) throws SQLException {
        this.copyQueryExecutor.writeToCopy(op, from);
    }

    public synchronized void flushCopy(CopyOperationImpl op) throws SQLException {
        this.copyQueryExecutor.flushCopy(op);
    }

    synchronized void readFromCopy(CopyOperationImpl op, boolean block) throws SQLException {
        this.copyQueryExecutor.readFromCopy(op, block);
    }

    private void flushIfDeadlockRisk(Query query, boolean disallowBatching, ResultHandler resultHandler, BatchResultHandler batchHandler, int flags) throws IOException {
        this.estimatedReceiveBufferBytes += 250;
        SimpleQuery sq = (SimpleQuery)query;
        if (sq.isStatementDescribed()) {
            int maxResultRowSize = sq.getMaxResultRowSize();
            if (maxResultRowSize >= 0) {
                this.estimatedReceiveBufferBytes += maxResultRowSize;
            } else {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "Couldn't estimate result size or result size unbounded, disabling batching for this query.", new Object[0]);
                }
                disallowBatching = true;
            }
        }
        if (disallowBatching || this.estimatedReceiveBufferBytes >= 64000) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, "Forcing Sync, receive buffer full or batching disallowed", new Object[0]);
            }
            this.sendSync(true);
            this.processResults(resultHandler, flags, 0, query.getSubqueries() != null, 0);
            this.estimatedReceiveBufferBytes = 0;
            if (batchHandler != null) {
                batchHandler.secureProgress();
            }
        }
    }

    private void sendQuery(Query query, V3ParameterList parameters, int maxRows, int fetchSize, int flags, ResultHandler resultHandler, BatchResultHandler batchHandler) throws IOException, SQLException {
        boolean disallowBatching;
        Query[] subqueries = query.getSubqueries();
        SimpleParameterList[] subparams = parameters.getSubparams();
        boolean bl = disallowBatching = (flags & 0x80) != 0;
        if (subqueries == null) {
            this.flushIfDeadlockRisk(query, disallowBatching, resultHandler, batchHandler, flags);
            if (resultHandler.getException() == null) {
                this.sendOneQuery((SimpleQuery)query, (SimpleParameterList)parameters, maxRows, fetchSize, flags);
            }
        } else {
            for (int i = 0; i < subqueries.length; ++i) {
                Query subquery = subqueries[i];
                this.flushIfDeadlockRisk(subquery, disallowBatching, resultHandler, batchHandler, flags);
                if (resultHandler.getException() != null) break;
                SimpleParameterList subparam = SimpleQuery.NO_PARAMETERS;
                if (subparams != null) {
                    subparam = subparams[i];
                }
                this.sendOneQuery((SimpleQuery)subquery, subparam, maxRows, fetchSize, flags);
            }
        }
    }

    private void sendSync(boolean addInQueue) throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> Sync", new Object[0]);
        }
        this.pgStream.sendChar(83);
        this.pgStream.sendInteger4(4);
        this.pgStream.flush();
        if (addInQueue) {
            this.pendingExecuteQueue.add(new ExecuteRequest(this.sync, null, true));
            this.pendingDescribePortalQueue.add(this.sync);
        }
    }

    private void sendFlush() throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> Flush", new Object[0]);
        }
        this.pgStream.sendChar(72);
        this.pgStream.sendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery query, SimpleParameterList params, boolean oneShot) throws IOException {
        int[] typeOIDs = params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs, this.deallocateEpoch)) {
            return;
        }
        query.unprepare();
        this.processDeadParsedQueries();
        query.setFields(null);
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++ + "-" + System.nanoTime();
            query.setStatementName(statementName, this.deallocateEpoch);
            query.setPrepareTypes(typeOIDs);
            this.registerParsedQuery(query, statementName);
        }
        byte[] encodedStatementName = query.getEncodedStatementName();
        String nativeSql = query.getNativeSql();
        if (RedshiftLogger.isEnable()) {
            StringBuilder sbuf = new StringBuilder(" FE=> Parse(stmt=" + statementName + ",query=\"");
            sbuf.append(QuerySanitizer.filterCredentials(nativeSql));
            sbuf.append("\",oids={");
            for (int i = 1; i <= params.getParameterCount(); ++i) {
                if (i != 1) {
                    sbuf.append(",");
                }
                sbuf.append(params.getTypeOID(i));
            }
            sbuf.append("})");
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, sbuf.toString(), new Object[0]);
            }
        }
        byte[] queryUtf8 = Utils.encodeUTF8(nativeSql);
        int encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + queryUtf8.length + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.sendChar(80);
        this.pgStream.sendInteger4(encodedSize);
        if (encodedStatementName != null) {
            this.pgStream.send(encodedStatementName);
        }
        this.pgStream.sendChar(0);
        this.pgStream.send(queryUtf8);
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger2(params.getParameterCount());
        for (int i = 1; i <= params.getParameterCount(); ++i) {
            this.pgStream.sendInteger4(params.getTypeOID(i));
        }
        this.pendingParseQueue.add(query);
    }

    private void sendBind(SimpleQuery query, SimpleParameterList params, Portal portal, boolean noBinaryTransfer) throws IOException {
        int i;
        byte[] encodedPortalName;
        String statementName = query.getStatementName();
        byte[] encodedStatementName = query.getEncodedStatementName();
        byte[] byArray = encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        if (RedshiftLogger.isEnable()) {
            StringBuilder sbuf = new StringBuilder(" FE=> Bind(stmt=" + statementName + ",portal=" + portal);
            for (int i2 = 1; i2 <= params.getParameterCount(); ++i2) {
                sbuf.append(",$").append(i2).append("=<").append(params.toString(i2, true)).append(">,type=").append(Oid.toString(params.getTypeOID(i2)));
            }
            sbuf.append(")");
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, sbuf.toString(), new Object[0]);
            }
        }
        long encodedSize = 0L;
        for (int i3 = 1; i3 <= params.getParameterCount(); ++i3) {
            if (params.isNull(i3)) {
                encodedSize += 4L;
                continue;
            }
            encodedSize += 4L + (long)params.getV3Length(i3);
        }
        Field[] fields = query.getFields();
        if (!noBinaryTransfer && query.needUpdateFieldFormats()) {
            for (Field field : fields) {
                if (!this.useBinary(field)) continue;
                field.setFormat(1);
                query.setHasBinaryFields(true);
            }
        }
        if (noBinaryTransfer && query.hasBinaryFields()) {
            for (Field field : fields) {
                if (field.getFormat() == 0) continue;
                field.setFormat(0);
            }
            query.resetNeedUpdateFieldFormats();
            query.setHasBinaryFields(false);
        }
        int numBinaryFields = !noBinaryTransfer && query.hasBinaryFields() ? fields.length : 0;
        encodedSize = (long)(4 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + 2 + params.getParameterCount() * 2 + 2) + encodedSize + 2L + (long)(numBinaryFields * 2);
        if (encodedSize > 0x3FFFFFFFL) {
            throw new RedshiftBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", encodedSize)));
        }
        this.pgStream.sendChar(66);
        this.pgStream.sendInteger4((int)encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.send(encodedPortalName);
        }
        this.pgStream.sendChar(0);
        if (encodedStatementName != null) {
            this.pgStream.send(encodedStatementName);
        }
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger2(params.getParameterCount());
        for (int i4 = 1; i4 <= params.getParameterCount(); ++i4) {
            this.pgStream.sendInteger2(params.isBinary(i4) ? 1 : 0);
        }
        this.pgStream.sendInteger2(params.getParameterCount());
        RedshiftBindException bindException = null;
        for (i = 1; i <= params.getParameterCount(); ++i) {
            if (params.isNull(i)) {
                this.pgStream.sendInteger4(-1);
                continue;
            }
            this.pgStream.sendInteger4(params.getV3Length(i));
            try {
                params.writeV3Value(i, this.pgStream);
                continue;
            }
            catch (RedshiftBindException be) {
                bindException = be;
            }
        }
        this.pgStream.sendInteger2(numBinaryFields);
        for (i = 0; i < numBinaryFields; ++i) {
            this.pgStream.sendInteger2(fields[i].getFormat());
        }
        this.pendingBindQueue.add(portal == null ? UNNAMED_PORTAL : portal);
        if (bindException != null) {
            throw bindException;
        }
    }

    private boolean useBinary(Field field) {
        int oid = field.getOID();
        return this.useBinaryForReceive(oid);
    }

    private void sendDescribePortal(SimpleQuery query, Portal portal) throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> Describe(portal={0})", portal);
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.sendChar(68);
        this.pgStream.sendInteger4(encodedSize);
        this.pgStream.sendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.send(encodedPortalName);
        }
        this.pgStream.sendChar(0);
        this.pendingDescribePortalQueue.add(query);
        query.setPortalDescribed(true);
    }

    private void sendDescribeStatement(SimpleQuery query, SimpleParameterList params, boolean describeOnly) throws IOException {
        byte[] encodedStatementName;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> Describe(statement={0})", query.getStatementName());
        }
        int encodedSize = 5 + ((encodedStatementName = query.getEncodedStatementName()) == null ? 0 : encodedStatementName.length) + 1;
        this.pgStream.sendChar(68);
        this.pgStream.sendInteger4(encodedSize);
        this.pgStream.sendChar(83);
        if (encodedStatementName != null) {
            this.pgStream.send(encodedStatementName);
        }
        this.pgStream.sendChar(0);
        this.pendingDescribeStatementQueue.add(new DescribeRequest(query, params, describeOnly, query.getStatementName()));
        this.pendingDescribePortalQueue.add(query);
        query.setStatementDescribed(true);
        query.setPortalDescribed(true);
    }

    private void sendExecute(SimpleQuery query, Portal portal, int limit) throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> Execute(portal={0},limit={1})", portal, limit);
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.sendChar(69);
        this.pgStream.sendInteger4(5 + encodedSize + 4);
        if (encodedPortalName != null) {
            this.pgStream.send(encodedPortalName);
        }
        this.pgStream.sendChar(0);
        this.pgStream.sendInteger4(limit);
        this.pendingExecuteQueue.add(new ExecuteRequest(query, portal, false));
    }

    private void sendClosePortal(String portalName) throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> ClosePortal({0})", portalName);
        }
        byte[] encodedPortalName = portalName == null ? null : Utils.encodeUTF8(portalName);
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.sendChar(67);
        this.pgStream.sendInteger4(6 + encodedSize);
        this.pgStream.sendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.send(encodedPortalName);
        }
        this.pgStream.sendChar(0);
    }

    private void sendCloseStatement(String statementName) throws IOException {
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> CloseStatement({0})", statementName);
        }
        byte[] encodedStatementName = statementName == null ? null : Utils.encodeUTF8(statementName);
        int encodedSize = encodedStatementName == null ? 0 : encodedStatementName.length;
        this.pgStream.sendChar(67);
        this.pgStream.sendInteger4(5 + encodedSize + 1);
        this.pgStream.sendChar(83);
        if (encodedStatementName != null) {
            this.pgStream.send(encodedStatementName);
        }
        this.pgStream.sendChar(0);
    }

    private void sendOneQuery(SimpleQuery query, SimpleParameterList params, int maxRows, int fetchSize, int flags) throws IOException {
        boolean describeStatement;
        int rows;
        boolean autoCommit;
        boolean asSimple;
        boolean bl = asSimple = (flags & 0x400) != 0;
        if (asSimple) {
            assert ((flags & 0x20) == 0) : "Simple mode does not support describe requests. sql = " + query.getNativeSql() + ", flags = " + flags;
            this.sendSimpleQuery(query, params);
            return;
        }
        assert (!query.getNativeQuery().multiStatement) : "Queries that might contain ; must be executed with QueryExecutor.QUERY_EXECUTE_AS_SIMPLE mode. Given query is " + query.getNativeSql();
        boolean noResults = (flags & 4) != 0;
        boolean noMeta = (flags & 2) != 0;
        boolean describeOnly = (flags & 0x20) != 0;
        boolean oneShot = (flags & 1) != 0;
        boolean usePortal = !oneShot || (flags & 8) != 0 && !noResults && !noMeta && fetchSize > 0 && !describeOnly;
        boolean noBinaryTransfer = (flags & 0x100) != 0;
        boolean forceDescribePortal = (flags & 0x200) != 0;
        boolean bl2 = autoCommit = (flags & 0x10) != 0;
        if (noResults) {
            rows = 1;
        } else if (!usePortal || autoCommit) {
            rows = maxRows;
        } else if (maxRows != 0 && (this.enableFetchRingBuffer || fetchSize > maxRows)) {
            rows = maxRows;
        } else {
            int n = rows = this.enableFetchRingBuffer ? maxRows : fetchSize;
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> OneQuery(rows=\"{0}\")", rows);
        }
        this.sendParse(query, params, oneShot);
        boolean queryHasUnknown = query.hasUnresolvedTypes();
        boolean paramsHasUnknown = params.hasUnresolvedTypes();
        boolean bl3 = describeStatement = describeOnly || !oneShot && paramsHasUnknown && queryHasUnknown && !query.isStatementDescribed();
        if (!describeStatement && paramsHasUnknown && !queryHasUnknown) {
            int[] queryOIDs = query.getPrepareTypes();
            int[] paramOIDs = params.getTypeOIDs();
            for (int i = 0; i < paramOIDs.length; ++i) {
                if (paramOIDs[i] != 0) continue;
                params.setResolvedType(i + 1, queryOIDs[i]);
            }
        }
        if (describeStatement) {
            this.sendDescribeStatement(query, params, describeOnly);
            if (describeOnly) {
                return;
            }
        }
        Portal portal = null;
        if (usePortal) {
            String portalName = "C_" + this.nextUniqueID++ + "-" + System.nanoTime();
            portal = new Portal(query, portalName);
        }
        this.sendBind(query, params, portal, noBinaryTransfer);
        if (!(noMeta || describeStatement || query.isPortalDescribed() && !forceDescribePortal)) {
            this.sendDescribePortal(query, portal);
        }
        this.sendExecute(query, portal, rows);
    }

    private void sendSimpleQuery(SimpleQuery query, SimpleParameterList params) throws IOException {
        String nativeSql = query.toString(params);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " FE=> SimpleQuery(query=\"{0}\")", QuerySanitizer.filterCredentials(nativeSql));
        }
        Encoding encoding = this.pgStream.getEncoding();
        byte[] encoded = encoding.encode(nativeSql);
        this.pgStream.sendChar(81);
        this.pgStream.sendInteger4(encoded.length + 4 + 1);
        this.pgStream.send(encoded);
        this.pgStream.sendChar(0);
        this.pgStream.flush();
        this.pendingExecuteQueue.add(new ExecuteRequest(query, null, true));
        this.pendingDescribePortalQueue.add(query);
    }

    private void registerParsedQuery(SimpleQuery query, String statementName) {
        if (statementName == null) {
            return;
        }
        PhantomReference<SimpleQuery> cleanupRef = new PhantomReference<SimpleQuery>(query, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupRef, statementName);
        query.setCleanupRef(cleanupRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStatementAndPortal() {
        QueryExecutorImpl queryExecutorImpl = this;
        synchronized (queryExecutorImpl) {
            block7: {
                try {
                    this.processDeadParsedQueries();
                    this.processDeadPortals();
                    this.sendFlush();
                    this.sendSync(false);
                    this.processSyncOnClose();
                }
                catch (IOException e) {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.logError(e);
                    }
                }
                catch (SQLException sqe) {
                    if (!RedshiftLogger.isEnable()) break block7;
                    this.logger.logError(sqe);
                }
            }
        }
    }

    private void processDeadParsedQueries() throws IOException {
        Reference<SimpleQuery> deadQuery;
        while ((deadQuery = this.parsedQueryCleanupQueue.poll()) != null) {
            String statementName = this.parsedQueryMap.remove(deadQuery);
            this.sendCloseStatement(statementName);
            deadQuery.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == UNNAMED_PORTAL) {
            return;
        }
        String portalName = portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(cleanupRef, portalName);
        portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        Reference<Portal> deadPortal;
        while ((deadPortal = this.openPortalCleanupQueue.poll()) != null) {
            String portalName = this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(portalName);
            deadPortal.clear();
        }
    }

    @Override
    public boolean isRingBufferThreadRunning() {
        return this.m_ringBufferThread != null;
    }

    @Override
    public void closeRingBufferThread(RedshiftRowsBlockingQueue<Tuple> queueRows, Thread ringBufferThread) {
        this.waitForRingBufferThreadToFinish(false, true, false, queueRows, ringBufferThread);
    }

    @Override
    public void sendQueryCancel() throws SQLException {
        super.sendQueryCancel();
    }

    protected void processSyncOnClose() throws IOException, SQLException {
        boolean endQuery = false;
        SQLException error = null;
        block7: while (!endQuery) {
            int c = this.pgStream.receiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 51: {
                    this.pgStream.receiveInteger4();
                    if (!RedshiftLogger.isEnable()) continue block7;
                    this.logger.log(LogLevel.DEBUG, " <=BE CloseComplete", new Object[0]);
                    continue block7;
                }
                case 69: {
                    SQLException newError = this.receiveErrorResponse(true);
                    if (error == null) {
                        error = newError;
                        continue block7;
                    }
                    error.setNextException(newError);
                    continue block7;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    this.addWarning(warning);
                    continue block7;
                }
                case 90: {
                    this.receiveRFQ();
                    this.pendingExecuteQueue.clear();
                    endQuery = true;
                    continue block7;
                }
            }
            throw new IOException("Unexpected packet type: " + c);
        }
        if (error != null) {
            throw error;
        }
    }

    protected void processResults(ResultHandler handler, int flags, int fetchSize, boolean subQueries, int maxRows) throws IOException {
        this.processResults(handler, flags, fetchSize, subQueries, 0, maxRows);
    }

    protected void processResults(ResultHandler handler, int flags, int fetchSize, boolean subQueries, int initRowCount, int maxRows) throws IOException {
        MessageLoopState msgLoopState = new MessageLoopState();
        int[] rowCount = new int[]{initRowCount};
        this.processResultsOnThread(handler, flags, fetchSize, msgLoopState, subQueries, rowCount, maxRows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processResultsOnThread(ResultHandler handler, int flags, int fetchSize, MessageLoopState msgLoopState, boolean subQueries, int[] rowCount, int maxRows) throws IOException {
        boolean noResults = (flags & 4) != 0;
        boolean bothRowsAndStatus = (flags & 0x40) != 0;
        boolean useRingBuffer = this.enableFetchRingBuffer && !handler.wantsScrollableResultSet() && !subQueries && !bothRowsAndStatus;
        ArrayList<Tuple> tuples = null;
        boolean endQuery = false;
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "  useRingBuffer={0}, handler.wantsScrollableResultSet()={1}, subQueries={2}, bothRowsAndStatus={3}", useRingBuffer, handler.wantsScrollableResultSet(), subQueries, bothRowsAndStatus);
        }
        try {
            int c;
            block36: while (!endQuery) {
                c = this.pgStream.receiveChar();
                if (RedshiftLogger.isEnable() && c != 68) {
                    this.logger.log(LogLevel.DEBUG, " FE=> Received packet of type:{0}={1}", c, Character.valueOf((char)c));
                }
                switch (c) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block36;
                    }
                    case 49: {
                        this.pgStream.receiveInteger4();
                        SimpleQuery parsedQuery = this.pendingParseQueue.removeFirst();
                        String parsedStatementName = parsedQuery.getStatementName();
                        if (!RedshiftLogger.isEnable()) continue block36;
                        this.logger.log(LogLevel.DEBUG, " <=BE ParseComplete [{0}]", parsedStatementName);
                        continue block36;
                    }
                    case 116: {
                        this.pgStream.receiveInteger4();
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE ParameterDescription", new Object[0]);
                        }
                        DescribeRequest describeData = this.pendingDescribeStatementQueue.getFirst();
                        SimpleQuery query = describeData.query;
                        SimpleParameterList params = describeData.parameterList;
                        boolean describeOnly = describeData.describeOnly;
                        String origStatementName = describeData.statementName;
                        int numParams = this.pgStream.receiveInteger2();
                        for (int i = 1; i <= numParams; ++i) {
                            int typeOid = this.pgStream.receiveInteger4();
                            params.setResolvedType(i, typeOid);
                        }
                        if (origStatementName == null && query.getStatementName() == null || origStatementName != null && origStatementName.equals(query.getStatementName())) {
                            query.setPrepareTypes(params.getTypeOIDs());
                        }
                        if (describeOnly) {
                            msgLoopState.doneAfterRowDescNoData = true;
                            continue block36;
                        }
                        this.pendingDescribeStatementQueue.removeFirst();
                        continue block36;
                    }
                    case 50: {
                        this.pgStream.receiveInteger4();
                        Portal boundPortal = this.pendingBindQueue.removeFirst();
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE BindComplete [{0}]", boundPortal);
                        }
                        this.registerOpenPortal(boundPortal);
                        continue block36;
                    }
                    case 51: {
                        this.pgStream.receiveInteger4();
                        if (!RedshiftLogger.isEnable()) continue block36;
                        this.logger.log(LogLevel.DEBUG, " <=BE CloseComplete", new Object[0]);
                        continue block36;
                    }
                    case 110: {
                        this.pgStream.receiveInteger4();
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE NoData", new Object[0]);
                        }
                        this.pendingDescribePortalQueue.removeFirst();
                        if (!msgLoopState.doneAfterRowDescNoData) continue block36;
                        DescribeRequest describeData = this.pendingDescribeStatementQueue.removeFirst();
                        SimpleQuery currentQuery = describeData.query;
                        Field[] fields = currentQuery.getFields();
                        if (fields == null) continue block36;
                        tuples = new ArrayList();
                        handler.handleResultRows(currentQuery, fields, tuples, null, null, rowCount, null);
                        tuples = null;
                        msgLoopState.queueTuples = null;
                        continue block36;
                    }
                    case 115: {
                        this.pgStream.receiveInteger4();
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE PortalSuspended", new Object[0]);
                        }
                        ExecuteRequest executeData = this.pendingExecuteQueue.removeFirst();
                        SimpleQuery currentQuery = executeData.query;
                        Portal currentPortal = executeData.portal;
                        Field[] fields = currentQuery.getFields();
                        if (fields != null && tuples == null && msgLoopState.queueTuples == null) {
                            ArrayList<Tuple> arrayList = tuples = noResults ? Collections.emptyList() : new ArrayList<Tuple>();
                        }
                        if (msgLoopState.queueTuples != null) {
                            try {
                                msgLoopState.queueTuples.checkAndAddEndOfRowsIndicator(currentPortal);
                            }
                            catch (InterruptedException ie) {
                                handler.handleError(new RedshiftException(GT.tr("Interrupted exception retrieving query results.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ie));
                            }
                        } else {
                            handler.handleResultRows(currentQuery, fields, tuples, currentPortal, null, rowCount, null);
                        }
                        tuples = null;
                        msgLoopState.queueTuples = null;
                        continue block36;
                    }
                    case 67: {
                        String status = this.receiveCommandStatus();
                        if (this.isFlushCacheOnDeallocate() && (status.startsWith("DEALLOCATE ALL") || status.startsWith("DISCARD ALL"))) {
                            this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                        }
                        msgLoopState.doneAfterRowDescNoData = false;
                        ExecuteRequest executeData = this.pendingExecuteQueue.peekFirst();
                        SimpleQuery currentQuery = executeData.query;
                        Portal currentPortal = executeData.portal;
                        String nativeSql = currentQuery.getNativeQuery().nativeSql;
                        if (this.isRaiseExceptionOnSilentRollback() && handler.getException() == null && status.startsWith("ROLLBACK")) {
                            String message = null;
                            if (QueryExecutorImpl.looksLikeCommit(nativeSql)) {
                                message = this.transactionFailCause == null ? GT.tr("The database returned ROLLBACK, so the transaction cannot be committed. Transaction failure is not known (check server logs?)", new Object[0]) : GT.tr("The database returned ROLLBACK, so the transaction cannot be committed. Transaction failure cause is <<{0}>>", this.transactionFailCause.getMessage());
                            } else if (QueryExecutorImpl.looksLikePrepare(nativeSql)) {
                                message = this.transactionFailCause == null ? GT.tr("The database returned ROLLBACK, so the transaction cannot be prepared. Transaction failure is not known (check server logs?)", new Object[0]) : GT.tr("The database returned ROLLBACK, so the transaction cannot be prepared. Transaction failure cause is <<{0}>>", this.transactionFailCause.getMessage());
                            }
                            if (message != null) {
                                handler.handleError(new RedshiftException(message, RedshiftState.IN_FAILED_SQL_TRANSACTION, (Throwable)this.transactionFailCause));
                            }
                        }
                        if (status.startsWith("SET") && nativeSql.lastIndexOf("search_path", 1024) != -1 && !nativeSql.equals(this.lastSetSearchPathQuery)) {
                            this.lastSetSearchPathQuery = nativeSql;
                            this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                        }
                        if (!executeData.asSimple) {
                            this.pendingExecuteQueue.removeFirst();
                        }
                        if (currentQuery == this.autoSaveQuery || currentQuery == this.releaseAutoSave) {
                            if (!RedshiftLogger.isEnable()) continue block36;
                            this.logger.log(LogLevel.DEBUG, "CommandStatus breaking to ignore SAVEPOINT or RELEASE SAVEPOINT status from autosave query", new Object[0]);
                            continue block36;
                        }
                        Field[] fields = currentQuery.getFields();
                        if (fields != null && tuples == null && msgLoopState.queueTuples == null) {
                            ArrayList<Tuple> arrayList = tuples = noResults ? Collections.emptyList() : new ArrayList<Tuple>();
                        }
                        if (fields == null) {
                            if (tuples != null) throw new IllegalStateException("Received resultset tuples, but no field structure for them");
                            if (msgLoopState.queueTuples != null) {
                                throw new IllegalStateException("Received resultset tuples, but no field structure for them");
                            }
                        }
                        if (fields != null || tuples != null || msgLoopState.queueTuples != null) {
                            if (msgLoopState.queueTuples == null) {
                                handler.handleResultRows(currentQuery, fields, tuples, null, null, rowCount, null);
                            } else {
                                try {
                                    msgLoopState.queueTuples.checkAndAddEndOfRowsIndicator();
                                }
                                catch (InterruptedException ie) {
                                    handler.handleError(new RedshiftException(GT.tr("Interrupted exception retrieving query results.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ie));
                                }
                            }
                            tuples = null;
                            msgLoopState.queueTuples = null;
                            rowCount = new int[1];
                            if (bothRowsAndStatus) {
                                this.interpretCommandStatus(status, handler);
                            }
                        } else {
                            this.interpretCommandStatus(status, handler);
                        }
                        if (executeData.asSimple) {
                            currentQuery.setFields(null);
                        }
                        if (currentPortal == null) continue block36;
                        currentPortal.close();
                        continue block36;
                    }
                    case 68: {
                        ExecuteRequest executeData;
                        boolean skipRow = false;
                        Tuple tuple = null;
                        try {
                            tuple = this.pgStream.receiveTupleV3();
                        }
                        catch (OutOfMemoryError oome) {
                            if (!noResults) {
                                handler.handleError(new RedshiftException(GT.tr("Ran out of memory retrieving query results.", new Object[0]), RedshiftState.OUT_OF_MEMORY, (Throwable)oome));
                            }
                        }
                        catch (SQLException e) {
                            handler.handleError(e);
                        }
                        if (!noResults) {
                            if (rowCount != null) {
                                if (maxRows > 0 && rowCount[0] >= maxRows) {
                                    skipRow = true;
                                } else {
                                    rowCount[0] = rowCount[0] + 1;
                                }
                            }
                            if (useRingBuffer) {
                                boolean firstRow = false;
                                if (msgLoopState.queueTuples == null) {
                                    firstRow = true;
                                    msgLoopState.queueTuples = new RedshiftRowsBlockingQueue(fetchSize, this.fetchRingBufferSize, this.logger);
                                }
                                if (!skipRow) {
                                    try {
                                        msgLoopState.queueTuples.put(tuple);
                                    }
                                    catch (InterruptedException ie) {
                                        handler.handleError(new RedshiftException(GT.tr("Interrupted exception retrieving query results.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ie));
                                    }
                                }
                                if (firstRow) {
                                    executeData = this.pendingExecuteQueue.peekFirst();
                                    SimpleQuery currentQuery = executeData.query;
                                    Field[] fields = currentQuery.getFields();
                                    this.m_ringBufferThread = new RingBufferThread(handler, flags, fetchSize, msgLoopState, subQueries, rowCount, maxRows);
                                    handler.handleResultRows(currentQuery, fields, null, null, msgLoopState.queueTuples, rowCount, this.m_ringBufferThread);
                                    if (RedshiftLogger.isEnable()) {
                                        int length = tuple == null ? -1 : tuple.length();
                                        this.logger.log(LogLevel.DEBUG, " <=BE DataRow(len={0})", length);
                                    }
                                    this.m_ringBufferThread.start();
                                    if (!RedshiftLogger.isEnable()) return;
                                    this.logger.log(LogLevel.DEBUG, "DataRow exiting the message loop on the application thread", new Object[0]);
                                    return;
                                }
                                if (this.m_ringBufferStopThread) {
                                    if (!RedshiftLogger.isEnable()) return;
                                    this.logger.log(LogLevel.DEBUG, "DataRow exiting the ring buffer thread loop", new Object[0]);
                                    return;
                                }
                            } else {
                                if (tuples == null) {
                                    tuples = new ArrayList();
                                }
                                if (!skipRow) {
                                    tuples.add(tuple);
                                }
                            }
                        }
                        if (!RedshiftLogger.isEnable()) continue block36;
                        int length = tuple == null ? -1 : tuple.length();
                        this.logger.log(LogLevel.DEBUG, " <=BE DataRow(len={0})", length);
                        if (!skipRow) continue block36;
                        this.logger.log(LogLevel.DEBUG, " skipRow={0}, rowCount = {1},  maxRows = {2}", skipRow, rowCount != null ? rowCount[0] : 0, maxRows);
                        continue block36;
                    }
                    case 69: {
                        SQLException error = this.receiveErrorResponse(false);
                        handler.handleError(error);
                        if (!this.willHealViaReparse(error)) continue block36;
                        this.deallocateEpoch = (short)(this.deallocateEpoch + 1);
                        if (!RedshiftLogger.isEnable()) continue block36;
                        this.logger.log(LogLevel.DEBUG, " FE: received {0}, will invalidate statements. deallocateEpoch is now {1}", error.getSQLState(), this.deallocateEpoch);
                        continue block36;
                    }
                    case 73: {
                        this.pgStream.receiveInteger4();
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE EmptyQuery", new Object[0]);
                        }
                        ExecuteRequest executeData = this.pendingExecuteQueue.removeFirst();
                        Portal currentPortal = executeData.portal;
                        handler.handleCommandStatus("EMPTY", 0L, 0L);
                        if (currentPortal == null) continue block36;
                        currentPortal.close();
                        continue block36;
                    }
                    case 78: {
                        SQLWarning warning = this.receiveNoticeResponse();
                        handler.handleWarning(warning);
                        continue block36;
                    }
                    case 83: {
                        try {
                            this.receiveParameterStatus();
                        }
                        catch (SQLException e) {
                            if (RedshiftLogger.isEnable()) {
                                this.logger.log(LogLevel.ERROR, "ParameterStatus exiting processResultsOnThread loop with error={0}, state={1}", e.getMessage(), e.getSQLState());
                            }
                            handler.handleError(e);
                            endQuery = true;
                        }
                        continue block36;
                    }
                    case 84: {
                        Field[] fields = this.receiveFields(this.serverProtocolVersion);
                        tuples = new ArrayList<Tuple>();
                        SimpleQuery query = this.pendingDescribePortalQueue.peekFirst();
                        if (!this.pendingExecuteQueue.isEmpty() && !this.pendingExecuteQueue.peekFirst().asSimple) {
                            this.pendingDescribePortalQueue.removeFirst();
                        }
                        query.setFields(fields);
                        if (!msgLoopState.doneAfterRowDescNoData) continue block36;
                        DescribeRequest describeData = this.pendingDescribeStatementQueue.removeFirst();
                        SimpleQuery currentQuery = describeData.query;
                        currentQuery.setFields(fields);
                        if (msgLoopState.queueTuples != null) {
                            // empty if block
                        }
                        handler.handleResultRows(currentQuery, fields, tuples, null, null, rowCount, null);
                        tuples = null;
                        msgLoopState.queueTuples = null;
                        continue block36;
                    }
                    case 90: {
                        this.receiveRFQ();
                        if (!this.pendingExecuteQueue.isEmpty() && this.pendingExecuteQueue.peekFirst().asSimple) {
                            if (msgLoopState.queueTuples != null) {
                                try {
                                    msgLoopState.queueTuples.checkAndAddEndOfRowsIndicator();
                                }
                                catch (InterruptedException ie) {
                                    handler.handleError(new RedshiftException(GT.tr("Interrupted exception retrieving query results.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ie));
                                }
                            }
                            tuples = null;
                            msgLoopState.queueTuples = null;
                            this.pgStream.clearResultBufferCount();
                            ExecuteRequest executeRequest = this.pendingExecuteQueue.removeFirst();
                            executeRequest.query.setFields(null);
                            this.pendingDescribePortalQueue.removeFirst();
                            if (!this.pendingExecuteQueue.isEmpty()) {
                                if (this.getTransactionState() == TransactionState.IDLE) {
                                    handler.secureProgress();
                                }
                                if (!RedshiftLogger.isEnable()) continue block36;
                                this.logger.log(LogLevel.DEBUG, "ReadyForQuery breaking to process subsequent results", new Object[0]);
                                continue block36;
                            }
                        }
                        endQuery = true;
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, "ReadyForQuery will exit from processResultsOnThread loop", new Object[0]);
                        }
                        while (!this.pendingParseQueue.isEmpty()) {
                            SimpleQuery failedQuery = this.pendingParseQueue.removeFirst();
                            if (RedshiftLogger.isEnable()) {
                                this.logger.log(LogLevel.DEBUG, "ReadyForQuery resetting statement name for failed parse:{0}", failedQuery.getStatementName());
                            }
                            failedQuery.unprepare();
                        }
                        this.pendingParseQueue.clear();
                        while (!this.pendingDescribeStatementQueue.isEmpty()) {
                            DescribeRequest request = this.pendingDescribeStatementQueue.removeFirst();
                            if (RedshiftLogger.isEnable()) {
                                this.logger.log(LogLevel.DEBUG, " FE marking setStatementDescribed(false) for query {0}", QuerySanitizer.filterCredentials(request.query.toString()));
                            }
                            request.query.setStatementDescribed(false);
                        }
                        while (!this.pendingDescribePortalQueue.isEmpty()) {
                            SimpleQuery describePortalQuery = this.pendingDescribePortalQueue.removeFirst();
                            if (RedshiftLogger.isEnable()) {
                                this.logger.log(LogLevel.DEBUG, " FE marking setPortalDescribed(false) for query {0}", QuerySanitizer.filterCredentials(describePortalQuery.toString()));
                            }
                            describePortalQuery.setPortalDescribed(false);
                        }
                        this.pendingBindQueue.clear();
                        this.pendingExecuteQueue.clear();
                        continue block36;
                    }
                    case 71: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyInResponse", new Object[0]);
                            this.logger.log(LogLevel.DEBUG, " FE=> CopyFail", new Object[0]);
                        }
                        byte[] buf = Utils.encodeUTF8(COPY_ERROR_MESSAGE);
                        this.pgStream.sendChar(102);
                        this.pgStream.sendInteger4(buf.length + 4 + 1);
                        this.pgStream.send(buf);
                        this.pgStream.sendChar(0);
                        this.pgStream.flush();
                        this.sendSync(true);
                        this.skipMessage();
                        continue block36;
                    }
                    case 72: {
                        if (RedshiftLogger.isEnable()) {
                            this.logger.log(LogLevel.DEBUG, " <=BE CopyOutResponse", new Object[0]);
                        }
                        this.skipMessage();
                        handler.handleError(new RedshiftException(GT.tr(COPY_ERROR_MESSAGE, new Object[0]), RedshiftState.NOT_IMPLEMENTED));
                        continue block36;
                    }
                    case 99: {
                        this.skipMessage();
                        if (!RedshiftLogger.isEnable()) continue block36;
                        this.logger.log(LogLevel.DEBUG, " <=BE CopyDone", new Object[0]);
                        continue block36;
                    }
                    case 100: {
                        this.skipMessage();
                        if (!RedshiftLogger.isEnable()) continue block36;
                        this.logger.log(LogLevel.DEBUG, " <=BE CopyData", new Object[0]);
                        continue block36;
                    }
                }
            }
            return;
            throw new IOException("Unexpected packet type: " + c);
        }
        catch (Exception e) {
            if (!RedshiftLogger.isEnable()) throw e;
            this.logger.log(LogLevel.ERROR, e, "Exception in query executor processResultsOnThread", new Object[0]);
            throw e;
        }
    }

    void skipMessage() throws IOException {
        int len = this.pgStream.receiveInteger4();
        assert (len >= 4) : "Length from skip message must be at least 4 ";
        this.pgStream.skip(len - 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize, int initRowCount) throws SQLException {
        this.waitForRingBufferThreadToFinish(false, false, false, null, null);
        QueryExecutorImpl queryExecutorImpl = this;
        synchronized (queryExecutorImpl) {
            this.waitOnLock();
            try {
                this.m_executingLock.lock();
                final Portal portal = (Portal)cursor;
                ResultHandler delegateHandler = handler;
                handler = new ResultHandlerDelegate(delegateHandler){

                    @Override
                    public void handleCommandStatus(String status, long updateCount, long insertOID) {
                        this.handleResultRows(portal.getQuery(), null, new ArrayList<Tuple>(), null, null, null, null);
                    }
                };
                try {
                    this.processDeadParsedQueries();
                    this.processDeadPortals();
                    this.sendExecute(portal.getQuery(), portal, fetchSize);
                    this.sendFlush();
                    this.sendSync(true);
                    this.processResults(handler, 0, fetchSize, portal.getQuery().getSubqueries() != null, initRowCount);
                    this.estimatedReceiveBufferBytes = 0;
                }
                catch (IOException e) {
                    this.abort();
                    handler.handleError(new RedshiftException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e));
                }
                handler.handleCompletion();
            }
            finally {
                this.m_executingLock.unlock();
            }
        }
    }

    private Field[] receiveFields(int serverProtocolVersion) throws IOException {
        this.pgStream.receiveInteger4();
        int size = this.pgStream.receiveInteger2();
        Field[] fields = new Field[size];
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE RowDescription({0})", size);
        }
        for (int i = 0; i < fields.length; ++i) {
            String columnLabel = this.pgStream.receiveString();
            int tableOid = this.pgStream.receiveInteger4();
            short positionInTable = (short)this.pgStream.receiveInteger2();
            int typeOid = this.pgStream.receiveInteger4();
            int typeLength = this.pgStream.receiveInteger2();
            int typeModifier = this.pgStream.receiveInteger4();
            int formatType = this.pgStream.receiveInteger2();
            fields[i] = new Field(columnLabel, typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i].setFormat(formatType);
            if (serverProtocolVersion >= ConnectionFactoryImpl.EXTENDED_RESULT_METADATA_SERVER_PROTOCOL_VERSION) {
                String schemaName = this.pgStream.receiveString();
                String tableName = this.pgStream.receiveString();
                String columnName = this.pgStream.receiveString();
                String catalogName = this.pgStream.receiveString();
                int temp = this.pgStream.receiveInteger2();
                int nullable = temp & 1;
                int autoincrement = temp >> 4 & 1;
                int readOnly = temp >> 8 & 1;
                int searchable = temp >> 12 & 1;
                int caseSensitive = 0;
                if (serverProtocolVersion >= ConnectionFactoryImpl.EXTENDED2_RESULT_METADATA_SERVER_PROTOCOL_VERSION) {
                    caseSensitive = temp >> 1 & 1;
                }
                fields[i].setMetadata(new FieldMetadata(columnName, tableName, schemaName, nullable == 1 ? 0 : 1, autoincrement != 0, catalogName, readOnly != 0, searchable != 0, caseSensitive != 0));
            }
            if (!RedshiftLogger.isEnable()) continue;
            this.logger.log(LogLevel.DEBUG, "        {0}", fields[i]);
        }
        return fields;
    }

    void receiveAsyncNotify() throws IOException {
        int len = this.pgStream.receiveInteger4();
        assert (len > 4) : "Length for AsyncNotify must be at least 4";
        int pid = this.pgStream.receiveInteger4();
        String msg = this.pgStream.receiveString();
        String param = this.pgStream.receiveString();
        this.addNotification(new Notification(msg, pid, param));
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE AsyncNotify({0},{1},{2})", pid, msg, param);
        }
    }

    SQLException receiveErrorResponse(boolean calledFromClose) throws IOException {
        int elen = this.pgStream.receiveInteger4();
        assert (elen > 4) : "Error response length must be greater than 4";
        EncodingPredictor.DecodeResult totalMessage = this.pgStream.receiveErrorString(elen - 4);
        ServerErrorMessage errorMsg = new ServerErrorMessage(totalMessage);
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE ErrorMessage({0})", errorMsg.toString());
        }
        RedshiftException error = new RedshiftException(errorMsg, this.logServerErrorDetail);
        if (!calledFromClose) {
            if (this.transactionFailCause == null) {
                this.transactionFailCause = error;
            } else {
                error.initCause(this.transactionFailCause);
            }
        }
        return error;
    }

    SQLWarning receiveNoticeResponse() throws IOException {
        int nlen = this.pgStream.receiveInteger4();
        assert (nlen > 4) : "Notice Response length must be greater than 4";
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.pgStream.receiveString(nlen - 4));
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE NoticeResponse({0})", warnMsg.toString());
        }
        return new RedshiftWarning(warnMsg);
    }

    String receiveCommandStatus() throws IOException {
        int len = this.pgStream.receiveInteger4();
        String status = this.pgStream.receiveString(len - 5);
        this.pgStream.receiveChar();
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE CommandStatus({0})", status);
        }
        return status;
    }

    private void interpretCommandStatus(String status, ResultHandler handler) {
        try {
            this.commandCompleteParser.parse(status);
        }
        catch (SQLException e) {
            handler.handleError(e);
            return;
        }
        long oid = this.commandCompleteParser.getOid();
        long count = this.commandCompleteParser.getRows();
        handler.handleCommandStatus(status, count, oid);
    }

    void receiveRFQ() throws IOException {
        if (this.pgStream.receiveInteger4() != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char tStatus = (char)this.pgStream.receiveChar();
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE ReadyForQuery({0})", Character.valueOf(tStatus));
        }
        switch (tStatus) {
            case 'I': {
                this.transactionFailCause = null;
                this.setTransactionState(TransactionState.IDLE);
                break;
            }
            case 'T': {
                this.transactionFailCause = null;
                this.setTransactionState(TransactionState.OPEN);
                break;
            }
            case 'E': {
                this.setTransactionState(TransactionState.FAILED);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + tStatus);
            }
        }
    }

    @Override
    protected void sendCloseMessage() throws IOException {
        this.waitForRingBufferThreadToFinish(true, false, false, null, null);
        this.pgStream.sendChar(88);
        this.pgStream.sendInteger4(4);
    }

    public void readStartupMessages() throws IOException, SQLException {
        block7: for (int i = 0; i < 1000; ++i) {
            int beresp = this.pgStream.receiveChar();
            switch (beresp) {
                case 90: {
                    this.receiveRFQ();
                    return;
                }
                case 75: {
                    int msgLen = this.pgStream.receiveInteger4();
                    if (msgLen != 12) {
                        throw new RedshiftException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                    }
                    int pid = this.pgStream.receiveInteger4();
                    int ckey = this.pgStream.receiveInteger4();
                    if (RedshiftLogger.isEnable()) {
                        this.logger.log(LogLevel.DEBUG, " <=BE BackendKeyData(pid={0},ckey={1})", pid, ckey);
                    }
                    this.setBackendKeyData(pid, ckey);
                    continue block7;
                }
                case 69: {
                    throw this.receiveErrorResponse(false);
                }
                case 78: {
                    this.addWarning(this.receiveNoticeResponse());
                    continue block7;
                }
                case 83: {
                    this.receiveParameterStatus();
                    continue block7;
                }
                default: {
                    if (RedshiftLogger.isEnable()) {
                        this.logger.log(LogLevel.DEBUG, "  invalid message type={0}", Character.valueOf((char)beresp));
                    }
                    throw new RedshiftException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                }
            }
        }
        throw new RedshiftException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveParameterStatus() throws IOException, SQLException {
        this.pgStream.receiveInteger4();
        String name = this.pgStream.receiveString();
        String value = this.pgStream.receiveString();
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, " <=BE ParameterStatus({0} = {1})", name, value);
        }
        if (name != null && !name.equals("")) {
            this.onParameterStatus(name, value);
        }
        if (name.equals("client_encoding")) {
            if (this.allowEncodingChanges) {
                if (!value.equalsIgnoreCase("UTF8") && !value.equalsIgnoreCase("UTF-8") && RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "Redshift jdbc expects client_encoding to be UTF8 for proper operation. Actual encoding is {0}", value);
                }
                this.pgStream.setEncoding(Encoding.getDatabaseEncoding(value, this.logger));
            } else if (!value.equalsIgnoreCase("UTF8") && !value.equalsIgnoreCase("UTF-8")) {
                this.close();
                throw new RedshiftException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UTF8 for correct operation.", value), RedshiftState.CONNECTION_FAILURE);
            }
        }
        if (name.equals("DateStyle") && !value.startsWith("ISO") && !value.toUpperCase().startsWith("ISO")) {
            this.close();
            throw new RedshiftException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), RedshiftState.CONNECTION_FAILURE);
        }
        if (name.equals("standard_conforming_strings")) {
            if (value.equals("on")) {
                this.setStandardConformingStrings(true);
                return;
            } else if (value.equals("off")) {
                this.setStandardConformingStrings(false);
                return;
            } else {
                this.close();
                throw new RedshiftException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", value), RedshiftState.CONNECTION_FAILURE);
            }
        }
        if ("TimeZone".equals(name)) {
            this.setTimeZone(TimestampUtils.parseBackendTimeZone(value));
            return;
        } else if ("application_name".equals(name)) {
            this.setApplicationName(value);
            return;
        } else if ("server_version_num".equals(name)) {
            this.setServerVersionNum(Integer.parseInt(value));
            return;
        } else if ("server_version".equals(name)) {
            this.setServerVersion(value);
            return;
        } else if ("server_protocol_version".equals(name)) {
            this.setServerProtocolVersion(value);
            return;
        } else if ("integer_datetimes".equals(name)) {
            if ("on".equals(value)) {
                this.setIntegerDateTimes(true);
                return;
            } else {
                if (!"off".equals(value)) throw new RedshiftException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                this.setIntegerDateTimes(false);
            }
            return;
        } else if ("datashare_enabled".equals(name)) {
            if ("on".equals(value)) {
                this.setDatashareEnabled(true);
                return;
            } else {
                if (!"off".equals(value)) throw new RedshiftException(GT.tr("Protocol error.  Session setup failed. Invalid value of datashare_enabled parameter. Only on/off are valid values", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                this.setDatashareEnabled(false);
            }
            return;
        } else {
            if (!"external_database".equals(name)) return;
            if ("on".equals(value)) {
                this.setCrossDatasharingEnabled(true);
                return;
            } else {
                if (!"off".equals(value)) throw new RedshiftException(GT.tr("Protocol error.  Session setup failed. Invalid value of external_database parameter. Only on/off are valid values", new Object[0]), RedshiftState.PROTOCOL_VIOLATION);
                this.setCrossDatasharingEnabled(false);
            }
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getApplicationName() {
        if (this.applicationName == null) {
            return "";
        }
        return this.applicationName;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.replicationProtocol;
    }

    @Override
    public boolean useBinaryForReceive(int oid) {
        return this.useBinaryReceiveForOids.contains(oid);
    }

    @Override
    public void setBinaryReceiveOids(Set<Integer> oids) {
        this.useBinaryReceiveForOids.clear();
        this.useBinaryReceiveForOids.addAll(oids);
    }

    @Override
    public boolean useBinaryForSend(int oid) {
        return this.useBinarySendForOids.contains(oid);
    }

    @Override
    public void setBinarySendOids(Set<Integer> oids) {
        this.useBinarySendForOids.clear();
        this.useBinarySendForOids.addAll(oids);
    }

    private void setIntegerDateTimes(boolean state) {
        this.integerDateTimes = state;
    }

    @Override
    public boolean getIntegerDateTimes() {
        return this.integerDateTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForRingBufferThreadToFinish(boolean calledFromConnectionClose, boolean calledFromResultsetClose, boolean calledFromStatementClose, RedshiftRowsBlockingQueue<Tuple> queueRows, Thread ringBufferThread) {
        Object object = this.m_ringBufferThreadLock;
        synchronized (object) {
            block19: {
                try {
                    this.m_executingLock.lock();
                    if (this.m_ringBufferThread != null) {
                        block18: {
                            try {
                                if (!calledFromConnectionClose) break block18;
                                this.m_ringBufferStopThread = true;
                                this.m_ringBufferThread.interrupt();
                            }
                            catch (Throwable throwable) {}
                            return;
                        }
                        if (calledFromResultsetClose) {
                            if (queueRows != null) {
                                queueRows.setSkipRows();
                            }
                            if (ringBufferThread != null) {
                                ringBufferThread.join();
                            }
                            if (queueRows != null) {
                                queueRows.close();
                            }
                            break block19;
                        }
                        if (calledFromStatementClose) {
                            if (queueRows != null) {
                                queueRows.setSkipRows();
                            }
                            this.m_ringBufferThread.join();
                            break block19;
                        }
                        this.m_ringBufferThread.join();
                        break block19;
                    }
                    if (queueRows != null && calledFromResultsetClose) {
                        queueRows.close();
                    }
                }
                finally {
                    this.m_executingLock.unlock();
                }
            }
        }
    }

    private class RingBufferThread
    extends Thread {
        ResultHandler handler;
        int flags;
        int fetchSize;
        MessageLoopState msgLoopState;
        boolean subQueries;
        int[] rowCount;
        int maxRows;

        public RingBufferThread(ResultHandler handler, int flags, int fetchSize, MessageLoopState msgLoopState, boolean subQueries, int[] rowCount, int maxRows) {
            super("RingBufferThread");
            this.handler = handler;
            this.flags = flags;
            this.fetchSize = fetchSize;
            this.msgLoopState = msgLoopState;
            this.subQueries = subQueries;
            this.rowCount = rowCount;
            this.maxRows = maxRows;
        }

        @Override
        public void run() {
            block17: {
                try {
                    QueryExecutorImpl.this.processResultsOnThread(this.handler, this.flags, this.fetchSize, this.msgLoopState, this.subQueries, this.rowCount, this.maxRows);
                }
                catch (Exception ex) {
                    if (QueryExecutorImpl.this.m_ringBufferStopThread) {
                        Thread.currentThread();
                        Thread.interrupted();
                        if (this.msgLoopState.queueTuples != null) {
                            this.msgLoopState.queueTuples.close();
                        }
                        break block17;
                    }
                    if (this.msgLoopState.queueTuples != null) {
                        try {
                            this.msgLoopState.queueTuples.checkAndAddEndOfRowsIndicator();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.handler.handleError(new RedshiftException(GT.tr("Exception retrieving query results.", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)ex));
                }
                finally {
                    if (this.msgLoopState.queueTuples != null) {
                        try {
                            this.msgLoopState.queueTuples.setHandlerException(this.handler.getException());
                            this.msgLoopState.queueTuples.checkAndAddEndOfRowsIndicator();
                        }
                        catch (Exception exception) {}
                    }
                    this.handler.setStatementStateIdleFromInQuery();
                    this.msgLoopState.queueTuples = null;
                    this.msgLoopState = null;
                    this.handler = null;
                    QueryExecutorImpl.this.m_ringBufferStopThread = false;
                    QueryExecutorImpl.this.m_ringBufferThread = null;
                }
            }
        }
    }
}

