/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.changed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.changed.IChanged;
import org.apache.hop.core.changed.IHopObserver;

public class ChangedFlag
implements IChanged {
    @JsonIgnore
    private Set<IHopObserver> obs = Collections.newSetFromMap(new ConcurrentHashMap());
    @JsonIgnore
    private AtomicBoolean changed = new AtomicBoolean();

    public void addObserver(IHopObserver o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.validateAdd(o);
    }

    private synchronized void validateAdd(IHopObserver o) {
        if (!this.obs.contains(o)) {
            this.obs.add(o);
        }
    }

    public void deleteObserver(IHopObserver o) {
        this.obs.remove(o);
    }

    public void notifyObservers(Object arg) {
        if (!this.changed.get()) {
            return;
        }
        IHopObserver[] lobs = this.obs.toArray(new IHopObserver[this.obs.size()]);
        this.clearChanged();
        for (int i = lobs.length - 1; i >= 0; --i) {
            lobs[i].update(this, arg);
        }
    }

    @Override
    public void setChanged() {
        this.changed.set(true);
    }

    @Override
    public void setChanged(boolean b) {
        this.changed.set(b);
    }

    @Override
    public void clearChanged() {
        this.changed.set(false);
    }

    @Override
    public boolean hasChanged() {
        return this.changed.get();
    }
}

