/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto;

import com.trilead.ssh2.compression.CompressionFactory;
import com.trilead.ssh2.crypto.cipher.BlockCipherFactory;
import com.trilead.ssh2.crypto.digest.MACs;
import com.trilead.ssh2.transport.KexManager;

public class CryptoWishList
implements Cloneable {
    public String[] kexAlgorithms;
    public String[] serverHostKeyAlgorithms;
    public String[] c2s_enc_algos;
    public String[] s2c_enc_algos;
    public String[] c2s_mac_algos;
    public String[] s2c_mac_algos;
    public String[] c2s_comp_algos;
    public String[] s2c_comp_algos;

    public CryptoWishList() {
        this.kexAlgorithms = KexManager.getDefaultKexAlgorithmList();
        this.serverHostKeyAlgorithms = KexManager.getDefaultServerHostkeyAlgorithmList();
        this.c2s_enc_algos = BlockCipherFactory.getDefaultCipherList();
        this.s2c_enc_algos = BlockCipherFactory.getDefaultCipherList();
        this.c2s_mac_algos = MACs.getMacList();
        this.s2c_mac_algos = MACs.getMacList();
        this.c2s_comp_algos = CompressionFactory.getDefaultCompressorList();
        this.s2c_comp_algos = CompressionFactory.getDefaultCompressorList();
    }

    public CryptoWishList(CryptoWishList other) {
        this.kexAlgorithms = (String[])other.kexAlgorithms.clone();
        this.serverHostKeyAlgorithms = (String[])other.serverHostKeyAlgorithms.clone();
        this.c2s_enc_algos = (String[])other.c2s_enc_algos.clone();
        this.s2c_enc_algos = (String[])other.s2c_enc_algos.clone();
        this.c2s_mac_algos = (String[])other.c2s_mac_algos.clone();
        this.s2c_mac_algos = (String[])other.s2c_mac_algos.clone();
        this.c2s_comp_algos = (String[])other.c2s_comp_algos.clone();
        this.s2c_comp_algos = (String[])other.s2c_comp_algos.clone();
    }

    public CryptoWishList clone() {
        return new CryptoWishList(this);
    }
}

