/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

class EditLogBackupOutputStream
extends EditLogOutputStream {
    private static final Log LOG = LogFactory.getLog(EditLogFileOutputStream.class);
    static final int DEFAULT_BUFFER_SIZE = 256;
    private final JournalProtocol backupNode;
    private final NamenodeRegistration bnRegistration;
    private final JournalInfo journalInfo;
    private final DataOutputBuffer out;
    private EditsDoubleBuffer doubleBuf;

    EditLogBackupOutputStream(NamenodeRegistration bnReg, JournalInfo journalInfo) throws IOException {
        this.bnRegistration = bnReg;
        this.journalInfo = journalInfo;
        InetSocketAddress bnAddress = NetUtils.createSocketAddr((String)this.bnRegistration.getAddress());
        try {
            this.backupNode = (JournalProtocol)NameNodeProxies.createNonHAProxy((Configuration)new HdfsConfiguration(), bnAddress, JournalProtocol.class, UserGroupInformation.getCurrentUser(), true).getProxy();
        }
        catch (IOException e) {
            Storage.LOG.error("Error connecting to: " + bnAddress, (Throwable)e);
            throw e;
        }
        this.doubleBuf = new EditsDoubleBuffer(256);
        this.out = new DataOutputBuffer(256);
    }

    @Override
    public void write(FSEditLogOp op) throws IOException {
        this.doubleBuf.writeOp(op);
    }

    @Override
    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void create(int layoutVersion) throws IOException {
        assert (this.doubleBuf.isFlushed()) : "previous data is not flushed yet";
        this.doubleBuf = new EditsDoubleBuffer(256);
    }

    @Override
    public void close() throws IOException {
        int size = this.doubleBuf.countBufferedBytes();
        if (size != 0) {
            throw new IOException("BackupEditStream has " + size + " records still to be flushed and cannot be closed.");
        }
        RPC.stopProxy((Object)this.backupNode);
        this.doubleBuf.close();
        this.doubleBuf = null;
    }

    @Override
    public void abort() throws IOException {
        RPC.stopProxy((Object)this.backupNode);
        this.doubleBuf = null;
    }

    @Override
    public void setReadyToFlush() throws IOException {
        this.doubleBuf.setReadyToFlush();
    }

    @Override
    protected void flushAndSync(boolean durable) throws IOException {
        assert (this.out.getLength() == 0) : "Output buffer is not empty";
        if (this.doubleBuf.isFlushed()) {
            LOG.info((Object)"Nothing to flush");
            return;
        }
        int numReadyTxns = this.doubleBuf.countReadyTxns();
        long firstTxToFlush = this.doubleBuf.getFirstReadyTxId();
        this.doubleBuf.flushTo((OutputStream)this.out);
        if (this.out.getLength() > 0) {
            assert (numReadyTxns > 0);
            byte[] data = Arrays.copyOf(this.out.getData(), this.out.getLength());
            this.out.reset();
            assert (this.out.getLength() == 0) : "Output buffer is not empty";
            this.backupNode.journal(this.journalInfo, 0L, firstTxToFlush, numReadyTxns, data);
        }
    }

    NamenodeRegistration getRegistration() {
        return this.bnRegistration;
    }

    void startLogSegment(long txId) throws IOException {
        this.backupNode.startLogSegment(this.journalInfo, 0L, txId);
    }
}

