/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class MessageParser {
    private Consumer<String> warningHandler;

    protected void emitWarning(String message) {
        if (this.warningHandler != null) {
            this.warningHandler.accept(message);
        }
    }

    void onWarning(Consumer<String> warningHandler) {
        this.warningHandler = warningHandler;
    }

    protected static String getErrorContext(String input, int position, int length) {
        StringBuilder context = new StringBuilder();
        int start = position - length;
        if (start < 0) {
            start = 0;
        } else {
            context.append("...");
        }
        int end = Math.min(input.length(), position + length);
        context.append(input.substring(start, position));
        context.append("<-- HERE -->");
        context.append(input.substring(position, end));
        if (end < input.length()) {
            context.append("...");
        }
        return context.toString();
    }

    protected static String getErrorContext(ByteBuffer buffer, int position, int length) {
        StringBuilder context = new StringBuilder();
        int start = position - length;
        if (start < 0) {
            start = 0;
        } else {
            context.append("...");
        }
        ByteBuffer copy = buffer.duplicate();
        copy.position(start);
        int end = position + length;
        if (end < buffer.limit()) {
            copy.limit(end);
        }
        while (true) {
            if (copy.position() == position) {
                context.append("<-- HERE -->");
            }
            if (!copy.hasRemaining()) break;
            byte c = copy.get();
            if (c < 127 && c >= 32) {
                context.append((char)c);
                continue;
            }
            if (c == 9) {
                context.append("\\t");
                continue;
            }
            if (c == 10) {
                context.append("\\n");
                continue;
            }
            if (c == 13) {
                context.append("\\r");
                continue;
            }
            context.append(String.format("\\x%02x", c));
        }
        if (copy.position() < buffer.limit()) {
            context.append("...");
        }
        return context.toString();
    }
}

