/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class ShardCheckpoint
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String streamName;
    private final @UnknownKeyFor @NonNull @Initialized String shardId;
    private final @UnknownKeyFor @NonNull @Initialized String sequenceNumber;
    private final @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType;
    private final @UnknownKeyFor @NonNull @Initialized Long subSequenceNumber;
    private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

    public ShardCheckpoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) {
        this(streamName, shardId, ShardIteratorType.fromValue((String)startingPoint.getPositionName()), startingPoint.getTimestamp());
    }

    public ShardCheckpoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        this(streamName, shardId, shardIteratorType, null, null, timestamp);
    }

    public ShardCheckpoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType, @UnknownKeyFor @NonNull @Initialized String sequenceNumber, @UnknownKeyFor @NonNull @Initialized Long subSequenceNumber) {
        this(streamName, shardId, shardIteratorType, sequenceNumber, subSequenceNumber, null);
    }

    private ShardCheckpoint(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized ShardIteratorType shardIteratorType, @UnknownKeyFor @NonNull @Initialized String sequenceNumber, @UnknownKeyFor @NonNull @Initialized Long subSequenceNumber, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        this.shardIteratorType = (ShardIteratorType)Preconditions.checkNotNull((Object)shardIteratorType, (Object)"shardIteratorType");
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName, (Object)"streamName");
        this.shardId = (String)Preconditions.checkNotNull((Object)shardId, (Object)"shardId");
        if (shardIteratorType == ShardIteratorType.AT_SEQUENCE_NUMBER || shardIteratorType == ShardIteratorType.AFTER_SEQUENCE_NUMBER) {
            Preconditions.checkNotNull((Object)sequenceNumber, (Object)"You must provide sequence number for AT_SEQUENCE_NUMBER or AFTER_SEQUENCE_NUMBER");
        } else {
            Preconditions.checkArgument((sequenceNumber == null ? 1 : 0) != 0, (Object)"Sequence number must be null for LATEST, TRIM_HORIZON or AT_TIMESTAMP");
        }
        if (shardIteratorType == ShardIteratorType.AT_TIMESTAMP) {
            Preconditions.checkNotNull((Object)timestamp, (Object)"You must provide timestamp for AT_TIMESTAMP");
        } else {
            Preconditions.checkArgument((timestamp == null ? 1 : 0) != 0, (Object)"Timestamp must be null for an iterator type other than AT_TIMESTAMP");
        }
        this.subSequenceNumber = subSequenceNumber;
        this.sequenceNumber = sequenceNumber;
        this.timestamp = timestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isBeforeOrAt(@UnknownKeyFor @NonNull @Initialized KinesisRecord other) {
        if (this.shardIteratorType == ShardIteratorType.AT_TIMESTAMP) {
            return this.timestamp.compareTo((ReadableInstant)other.getApproximateArrivalTimestamp()) <= 0;
        }
        int result = this.extendedSequenceNumber().compareTo(other.getExtendedSequenceNumber());
        if (result == 0) {
            return this.shardIteratorType == ShardIteratorType.AT_SEQUENCE_NUMBER;
        }
        return result < 0;
    }

    private @UnknownKeyFor @NonNull @Initialized ExtendedSequenceNumber extendedSequenceNumber() {
        String fullSequenceNumber = this.sequenceNumber;
        if (fullSequenceNumber == null) {
            fullSequenceNumber = this.shardIteratorType.toString();
        }
        return new ExtendedSequenceNumber(fullSequenceNumber, this.subSequenceNumber);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("Checkpoint %s for stream %s, shard %s: %s", this.shardIteratorType, this.streamName, this.shardId, this.sequenceNumber);
    }

    public @UnknownKeyFor @NonNull @Initialized String getShardIterator(@UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesisClient) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        if (this.checkpointIsInTheMiddleOfAUserRecord()) {
            return kinesisClient.getShardIterator(this.streamName, this.shardId, ShardIteratorType.AT_SEQUENCE_NUMBER, this.sequenceNumber, null);
        }
        return kinesisClient.getShardIterator(this.streamName, this.shardId, this.shardIteratorType, this.sequenceNumber, this.timestamp);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean checkpointIsInTheMiddleOfAUserRecord() {
        return this.shardIteratorType == ShardIteratorType.AFTER_SEQUENCE_NUMBER && this.subSequenceNumber != null;
    }

    public @UnknownKeyFor @NonNull @Initialized ShardCheckpoint moveAfter(@UnknownKeyFor @NonNull @Initialized KinesisRecord record) {
        return new ShardCheckpoint(this.streamName, this.shardId, ShardIteratorType.AFTER_SEQUENCE_NUMBER, record.getSequenceNumber(), record.getSubSequenceNumber());
    }

    public @UnknownKeyFor @NonNull @Initialized String getStreamName() {
        return this.streamName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getShardId() {
        return this.shardId;
    }
}

