/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFetcherImpl<T extends RestfulGateway>
implements MetricFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(MetricFetcherImpl.class);
    private final GatewayRetriever<T> retriever;
    private final MetricQueryServiceRetriever queryServiceRetriever;
    private final Executor executor;
    private final Time timeout;
    private final MetricStore metrics = new MetricStore();
    private final MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
    private final long updateInterval;
    private long lastUpdateTime;

    public MetricFetcherImpl(GatewayRetriever<T> retriever, MetricQueryServiceRetriever queryServiceRetriever, Executor executor, Time timeout, long updateInterval) {
        this.retriever = (GatewayRetriever)Preconditions.checkNotNull(retriever);
        this.queryServiceRetriever = (MetricQueryServiceRetriever)Preconditions.checkNotNull((Object)queryServiceRetriever);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        Preconditions.checkArgument((updateInterval > 0L ? 1 : 0) != 0, (Object)"The update interval must be larger than 0.");
        this.updateInterval = updateInterval;
    }

    @Override
    public MetricStore getMetricStore() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        MetricFetcherImpl metricFetcherImpl = this;
        synchronized (metricFetcherImpl) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime > this.updateInterval) {
                this.lastUpdateTime = currentTime;
                this.fetchMetrics();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdateTime() {
        MetricFetcherImpl metricFetcherImpl = this;
        synchronized (metricFetcherImpl) {
            return this.lastUpdateTime;
        }
    }

    private void fetchMetrics() {
        LOG.debug("Start fetching metrics.");
        try {
            Optional<T> optionalLeaderGateway = this.retriever.getNow();
            if (optionalLeaderGateway.isPresent()) {
                RestfulGateway leaderGateway = (RestfulGateway)optionalLeaderGateway.get();
                CompletableFuture<MultipleJobsDetails> jobDetailsFuture = leaderGateway.requestMultipleJobDetails(this.timeout);
                jobDetailsFuture.whenCompleteAsync((jobDetails, throwable) -> {
                    if (throwable != null) {
                        LOG.debug("Fetching of JobDetails failed.", throwable);
                    } else {
                        ArrayList<String> toRetain = new ArrayList<String>(jobDetails.getJobs().size());
                        for (JobDetails job : jobDetails.getJobs()) {
                            toRetain.add(job.getJobId().toString());
                        }
                        this.metrics.retainJobs(toRetain);
                        this.metrics.updateCurrentExecutionAttempts(jobDetails.getJobs());
                    }
                }, this.executor);
                CompletableFuture<Collection<String>> queryServiceAddressesFuture = leaderGateway.requestMetricQueryServiceAddresses(this.timeout);
                queryServiceAddressesFuture.whenCompleteAsync((queryServiceAddresses, throwable) -> {
                    if (throwable != null) {
                        LOG.debug("Requesting paths for query services failed.", throwable);
                    } else {
                        for (String queryServiceAddress : queryServiceAddresses) {
                            this.retrieveAndQueryMetrics(queryServiceAddress);
                        }
                    }
                }, this.executor);
                CompletableFuture<Collection<Tuple2<ResourceID, String>>> taskManagerQueryServiceGatewaysFuture = leaderGateway.requestTaskManagerMetricQueryServiceAddresses(this.timeout);
                taskManagerQueryServiceGatewaysFuture.whenCompleteAsync((queryServiceGateways, throwable) -> {
                    if (throwable != null) {
                        LOG.debug("Requesting TaskManager's path for query services failed.", throwable);
                    } else {
                        List<String> taskManagersToRetain = queryServiceGateways.stream().map(tuple -> {
                            this.queryServiceRetriever.retrieveService((String)tuple.f1).thenAcceptAsync(this::queryMetrics, this.executor);
                            return ((ResourceID)tuple.f0).getResourceIdString();
                        }).collect(Collectors.toList());
                        this.metrics.retainTaskManagers(taskManagersToRetain);
                    }
                }, this.executor);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while fetching metrics.", (Throwable)e);
        }
    }

    private void retrieveAndQueryMetrics(String queryServiceAddress) {
        LOG.debug("Retrieve metric query service gateway for {}", (Object)queryServiceAddress);
        CompletableFuture<MetricQueryServiceGateway> queryServiceGatewayFuture = this.queryServiceRetriever.retrieveService(queryServiceAddress);
        queryServiceGatewayFuture.whenCompleteAsync((queryServiceGateway, t) -> {
            if (t != null) {
                LOG.debug("Could not retrieve QueryServiceGateway.", t);
            } else {
                this.queryMetrics((MetricQueryServiceGateway)queryServiceGateway);
            }
        }, this.executor);
    }

    private void queryMetrics(MetricQueryServiceGateway queryServiceGateway) {
        LOG.debug("Query metrics for {}.", (Object)queryServiceGateway.getAddress());
        queryServiceGateway.queryMetrics(this.timeout).whenCompleteAsync((result, t) -> {
            if (t != null) {
                LOG.debug("Fetching metrics failed.", t);
            } else {
                this.metrics.addAll(this.deserializer.deserialize((MetricDumpSerialization.MetricSerializationResult)result));
            }
        }, this.executor);
    }

    @Nonnull
    public static <T extends RestfulGateway> MetricFetcherImpl<T> fromConfiguration(Configuration configuration, MetricQueryServiceRetriever metricQueryServiceGatewayRetriever, GatewayRetriever<T> dispatcherGatewayRetriever, ExecutorService executor) {
        Time timeout = Time.milliseconds((long)configuration.getLong(WebOptions.TIMEOUT));
        long updateInterval = configuration.getLong(MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL);
        return new MetricFetcherImpl<T>(dispatcherGatewayRetriever, metricQueryServiceGatewayRetriever, executor, timeout, updateInterval);
    }
}

