/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ping;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.ping.ActionPing;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionPingDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionPing.class;
    private Text wName;
    private TextVar wHostname;
    private Label wlTimeOut;
    private TextVar wTimeOut;
    private ActionPing action;
    private CCombo wPingType;
    private Label wlNbrPackets;
    private TextVar wNbrPackets;
    private boolean changed;

    public ActionPingDialog(Shell parent, ActionPing action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionPing.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        this.shell.setMinimumSize(400, 250);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionPing.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"System.ActionName.Label", (String[])new String[0]));
        wlName.setToolTipText(BaseMessages.getString(PKG, (String)"System.ActionName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlHostname = new Label((Composite)this.shell, 131072);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"ActionPing.Hostname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHostname);
        FormData fdlHostname = new FormData();
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.top = new FormAttachment((Control)this.wName, margin);
        fdlHostname.right = new FormAttachment(middle, -margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wHostname);
        this.wHostname.addModifyListener(lsMod);
        FormData fdHostname = new FormData();
        fdHostname.left = new FormAttachment(middle, 0);
        fdHostname.top = new FormAttachment((Control)this.wName, margin);
        fdHostname.right = new FormAttachment(100, 0);
        this.wHostname.setLayoutData((Object)fdHostname);
        this.wHostname.addModifyListener(e -> this.wHostname.setToolTipText(this.variables.resolve(this.wHostname.getText())));
        Label wlPingType = new Label((Composite)this.shell, 131072);
        wlPingType.setText(BaseMessages.getString(PKG, (String)"ActionPing.PingType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPingType);
        FormData fdlPingType = new FormData();
        fdlPingType.left = new FormAttachment(0, 0);
        fdlPingType.right = new FormAttachment(middle, -margin);
        fdlPingType.top = new FormAttachment((Control)this.wHostname, margin);
        wlPingType.setLayoutData((Object)fdlPingType);
        this.wPingType = new CCombo((Composite)this.shell, 2060);
        this.wPingType.add(BaseMessages.getString(PKG, (String)"ActionPing.ClassicPing.Label", (String[])new String[0]));
        this.wPingType.add(BaseMessages.getString(PKG, (String)"ActionPing.SystemPing.Label", (String[])new String[0]));
        this.wPingType.add(BaseMessages.getString(PKG, (String)"ActionPing.BothPings.Label", (String[])new String[0]));
        this.wPingType.select(1);
        PropsUi.setLook((Widget)this.wPingType);
        FormData fdPingType = new FormData();
        fdPingType.left = new FormAttachment(middle, 0);
        fdPingType.top = new FormAttachment((Control)this.wHostname, margin);
        fdPingType.right = new FormAttachment(100, 0);
        this.wPingType.setLayoutData((Object)fdPingType);
        this.wPingType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionPingDialog.this.setPingType();
                ActionPingDialog.this.action.setChanged();
            }
        });
        this.wlTimeOut = new Label((Composite)this.shell, 131072);
        this.wlTimeOut.setText(BaseMessages.getString(PKG, (String)"ActionPing.TimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTimeOut);
        FormData fdlTimeOut = new FormData();
        fdlTimeOut.left = new FormAttachment(0, 0);
        fdlTimeOut.right = new FormAttachment(middle, -margin);
        fdlTimeOut.top = new FormAttachment((Control)this.wPingType, margin);
        this.wlTimeOut.setLayoutData((Object)fdlTimeOut);
        this.wTimeOut = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wlTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"ActionPing.TimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(middle, 0);
        fdTimeOut.top = new FormAttachment((Control)this.wPingType, margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        this.wlNbrPackets = new Label((Composite)this.shell, 131072);
        this.wlNbrPackets.setText(BaseMessages.getString(PKG, (String)"ActionPing.NrPackets.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNbrPackets);
        FormData fdlNbrPackets = new FormData();
        fdlNbrPackets.left = new FormAttachment(0, 0);
        fdlNbrPackets.right = new FormAttachment(middle, -margin);
        fdlNbrPackets.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.wlNbrPackets.setLayoutData((Object)fdlNbrPackets);
        this.wNbrPackets = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wNbrPackets);
        this.wNbrPackets.addModifyListener(lsMod);
        FormData fdNbrPackets = new FormData();
        fdNbrPackets.left = new FormAttachment(middle, 0);
        fdNbrPackets.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdNbrPackets.right = new FormAttachment(100, 0);
        this.wNbrPackets.setLayoutData((Object)fdNbrPackets);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        this.getData();
        this.setPingType();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setPingType() {
        this.wlTimeOut.setEnabled(this.wPingType.getSelectionIndex() == this.action.isystemPing || this.wPingType.getSelectionIndex() == this.action.ibothPings);
        this.wTimeOut.setEnabled(this.wPingType.getSelectionIndex() == this.action.isystemPing || this.wPingType.getSelectionIndex() == this.action.ibothPings);
        this.wlNbrPackets.setEnabled(this.wPingType.getSelectionIndex() == this.action.iclassicPing || this.wPingType.getSelectionIndex() == this.action.ibothPings);
        this.wNbrPackets.setEnabled(this.wPingType.getSelectionIndex() == this.action.iclassicPing || this.wPingType.getSelectionIndex() == this.action.ibothPings);
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        if (this.action.getHostname() != null) {
            this.wHostname.setText(this.action.getHostname());
        }
        if (this.action.getNbrPackets() != null) {
            this.wNbrPackets.setText(this.action.getNbrPackets());
        } else {
            this.wNbrPackets.setText("2");
        }
        if (this.action.getTimeout() != null) {
            this.wTimeOut.setText(this.action.getTimeout());
        } else {
            this.wTimeOut.setText("3000");
        }
        this.wPingType.select(this.action.ipingtype);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setHostname(this.wHostname.getText());
        this.action.setNbrPackets(this.wNbrPackets.getText());
        this.action.setTimeout(this.wTimeOut.getText());
        this.action.ipingtype = this.wPingType.getSelectionIndex();
        this.action.pingtype = this.wPingType.getSelectionIndex() == this.action.isystemPing ? this.action.systemPing : (this.wPingType.getSelectionIndex() == this.action.ibothPings ? this.action.bothPings : this.action.classicPing);
        this.dispose();
    }
}

