/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.metrics.MetricGroup;

@FunctionalInterface
@PublicEvolving
public interface TimestampAssignerSupplier<T>
extends Serializable {
    public TimestampAssigner<T> createTimestampAssigner(Context var1);

    public static <T> TimestampAssignerSupplier<T> of(SerializableTimestampAssigner<T> assigner) {
        return new SupplierFromSerializableTimestampAssigner<T>(assigner);
    }

    public static class SupplierFromSerializableTimestampAssigner<T>
    implements TimestampAssignerSupplier<T> {
        private static final long serialVersionUID = 1L;
        private final SerializableTimestampAssigner<T> assigner;

        public SupplierFromSerializableTimestampAssigner(SerializableTimestampAssigner<T> assigner) {
            this.assigner = assigner;
        }

        @Override
        public TimestampAssigner<T> createTimestampAssigner(Context context) {
            return this.assigner;
        }
    }

    public static interface Context {
        public MetricGroup getMetricGroup();
    }
}

