/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;

public class CachedShuffleDescriptors {
    private final List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> serializedShuffleDescriptorGroups;
    private final Queue<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex> toBeSerialized;
    private final Map<IntermediateResultPartitionID, Integer> resultPartitionIdToIndex = new HashMap<IntermediateResultPartitionID, Integer>();
    private final int numConsumers;

    public CachedShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup, TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] shuffleDescriptors) {
        this.numConsumers = consumedPartitionGroup.getNumConsumers();
        int index = 0;
        for (IntermediateResultPartitionID resultPartitionID : consumedPartitionGroup) {
            this.resultPartitionIdToIndex.put(resultPartitionID, index++);
        }
        this.toBeSerialized = new ArrayDeque<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex>(consumedPartitionGroup.size());
        this.serializedShuffleDescriptorGroups = new ArrayList<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>>();
        for (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex shuffleDescriptor : shuffleDescriptors) {
            this.toBeSerialized.offer(shuffleDescriptor);
        }
    }

    public List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> getAllSerializedShuffleDescriptorGroups() {
        return new ArrayList<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>>(this.serializedShuffleDescriptorGroups);
    }

    public void serializeShuffleDescriptors(TaskDeploymentDescriptorFactory.ShuffleDescriptorSerializer shuffleDescriptorSerializer) throws IOException {
        if (!this.toBeSerialized.isEmpty()) {
            TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(this.toBeSerialized.toArray(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[0]));
            TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> serializedShuffleDescriptorGroup = shuffleDescriptorSerializer.serializeAndTryOffloadShuffleDescriptor(shuffleDescriptorGroup, this.numConsumers);
            this.toBeSerialized.clear();
            this.serializedShuffleDescriptorGroups.add(serializedShuffleDescriptorGroup);
        }
    }

    public void markPartitionFinished(IntermediateResultPartition resultPartition) {
        ShuffleDescriptor consumedPartitionShuffleDescriptor = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor(resultPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.MUST_BE_KNOWN, false);
        this.toBeSerialized.offer(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex(consumedPartitionShuffleDescriptor, (Integer)Preconditions.checkNotNull((Object)this.resultPartitionIdToIndex.get(resultPartition.getPartitionId()))));
    }
}

